/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.lifecycle.states;

import com.impetus.kundera.client.Client;
import com.impetus.kundera.client.EnhanceEntity;
import com.impetus.kundera.graph.Node;
import com.impetus.kundera.lifecycle.NodeStateContext;
import com.impetus.kundera.lifecycle.states.DetachedState;
import com.impetus.kundera.lifecycle.states.NodeState;
import com.impetus.kundera.lifecycle.states.RemovedState;
import com.impetus.kundera.lifecycle.states.TransientState;
import com.impetus.kundera.metadata.KunderaMetadataManager;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.persistence.EntityReader;
import com.impetus.kundera.property.PropertyAccessorHelper;
import java.util.HashMap;
import javax.persistence.PersistenceContextType;

public class ManagedState
extends NodeState {
    @Override
    public void initialize(NodeStateContext nodeStateContext) {
    }

    @Override
    public void handlePersist(NodeStateContext nodeStateContext) {
    }

    @Override
    public void handleRemove(NodeStateContext nodeStateContext) {
        this.moveNodeToNextState(nodeStateContext, new RemovedState());
        nodeStateContext.setDirty(true);
    }

    @Override
    public void handleRefresh(NodeStateContext nodeStateContext) {
        Client client = nodeStateContext.getClient();
        Class nodeDataClass = nodeStateContext.getDataClass();
        EntityMetadata entityMetadata = KunderaMetadataManager.getEntityMetadata(nodeStateContext.getPersistenceDelegator().getKunderaMetadata(), nodeDataClass);
        Object entityId = nodeStateContext.getEntityId();
        EntityReader reader = client.getReader();
        EnhanceEntity ee = reader.findById(entityId, entityMetadata, client);
        if (ee != null && ee.getEntity() != null) {
            Object nodeData = ee.getEntity();
            nodeStateContext.setData(nodeData);
        }
        this.recursivelyPerformOperation(nodeStateContext, NodeState.OPERATION.REFRESH);
    }

    @Override
    public void handleMerge(NodeStateContext nodeStateContext) {
        ((Node)nodeStateContext).setUpdate(true);
        nodeStateContext.getPersistenceCache().getMainCache().addNodeToCache((Node)nodeStateContext);
    }

    @Override
    public void handleFind(NodeStateContext nodeStateContext) {
        Client client = nodeStateContext.getClient();
        Class nodeDataClass = nodeStateContext.getDataClass();
        EntityMetadata entityMetadata = KunderaMetadataManager.getEntityMetadata(nodeStateContext.getPersistenceDelegator().getKunderaMetadata(), nodeDataClass);
        Object entityId = nodeStateContext.getEntityId();
        Object nodeData = null;
        EntityReader reader = client.getReader();
        if (reader == null) {
            return;
        }
        EnhanceEntity ee = reader.findById(entityId, entityMetadata, client);
        if (ee != null && ee.getEntity() != null) {
            Object entity = ee.getEntity();
            if ((entityMetadata.getRelationNames() == null || entityMetadata.getRelationNames().isEmpty()) && !entityMetadata.isRelationViaJoinTable()) {
                nodeData = entity;
            } else {
                HashMap<Object, Object> relationStack = new HashMap<Object, Object>();
                relationStack.put(nodeDataClass.getCanonicalName() + "#" + PropertyAccessorHelper.getId(entity, entityMetadata), entity);
                nodeData = reader.recursivelyFindEntities(ee.getEntity(), ee.getRelations(), entityMetadata, nodeStateContext.getPersistenceDelegator(), false, relationStack);
            }
        }
        if (nodeData != null) {
            nodeStateContext.setData(nodeData);
            nodeStateContext.getPersistenceCache().getMainCache().processNodeMapping((Node)nodeStateContext);
            nodeStateContext.setDirty(false);
            Node original = ((Node)nodeStateContext).clone();
            ((Node)nodeStateContext).setOriginalNode(original);
        }
    }

    @Override
    public void handleClose(NodeStateContext nodeStateContext) {
        this.handleDetach(nodeStateContext);
    }

    @Override
    public void handleClear(NodeStateContext nodeStateContext) {
        this.handleDetach(nodeStateContext);
    }

    @Override
    public void handleFlush(NodeStateContext nodeStateContext) {
        Client client = nodeStateContext.getClient();
        client.persist((Node)nodeStateContext);
        nodeStateContext.setDirty(false);
    }

    @Override
    public void handleLock(NodeStateContext nodeStateContext) {
    }

    @Override
    public void handleDetach(NodeStateContext nodeStateContext) {
        this.moveNodeToNextState(nodeStateContext, new DetachedState());
        this.recursivelyPerformOperation(nodeStateContext, NodeState.OPERATION.DETACH);
    }

    @Override
    public void handleCommit(NodeStateContext nodeStateContext) {
        nodeStateContext.setCurrentNodeState(new DetachedState());
    }

    @Override
    public void handleRollback(NodeStateContext nodeStateContext) {
        if (PersistenceContextType.EXTENDED.equals((Object)nodeStateContext.getPersistenceCache().getPersistenceContextType())) {
            this.moveNodeToNextState(nodeStateContext, new TransientState());
        } else if (PersistenceContextType.TRANSACTION.equals((Object)nodeStateContext.getPersistenceCache().getPersistenceContextType())) {
            this.moveNodeToNextState(nodeStateContext, new DetachedState());
        }
    }

    @Override
    public void handleGetReference(NodeStateContext nodeStateContext) {
    }

    @Override
    public void handleContains(NodeStateContext nodeStateContext) {
    }
}

