/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.lifecycle.states;

import com.impetus.kundera.graph.Node;
import com.impetus.kundera.graph.NodeLink;
import com.impetus.kundera.lifecycle.NodeStateContext;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;

public abstract class NodeState {
    public abstract void initialize(NodeStateContext var1);

    public abstract void handlePersist(NodeStateContext var1);

    public abstract void handleRemove(NodeStateContext var1);

    public abstract void handleRefresh(NodeStateContext var1);

    public abstract void handleMerge(NodeStateContext var1);

    public abstract void handleDetach(NodeStateContext var1);

    public abstract void handleClose(NodeStateContext var1);

    public abstract void handleLock(NodeStateContext var1);

    public abstract void handleCommit(NodeStateContext var1);

    public abstract void handleRollback(NodeStateContext var1);

    public abstract void handleFind(NodeStateContext var1);

    public abstract void handleGetReference(NodeStateContext var1);

    public abstract void handleContains(NodeStateContext var1);

    public abstract void handleClear(NodeStateContext var1);

    public abstract void handleFlush(NodeStateContext var1);

    void moveNodeToNextState(NodeStateContext nodeStateContext, NodeState nextState) {
        nodeStateContext.setCurrentNodeState(nextState);
    }

    void recursivelyPerformOperation(NodeStateContext nodeStateContext, OPERATION operation) {
        Map<NodeLink, Node> children = nodeStateContext.getChildren();
        if (children != null) {
            for (NodeLink nodeLink : children.keySet()) {
                List cascadeTypes = (List)nodeLink.getLinkProperty(NodeLink.LinkProperty.CASCADE);
                switch (operation) {
                    case REFRESH: {
                        if (!cascadeTypes.contains(CascadeType.REFRESH) && !cascadeTypes.contains(CascadeType.ALL)) break;
                        Node childNode = children.get(nodeLink);
                        childNode.refresh();
                        break;
                    }
                    case DETACH: {
                        if (!cascadeTypes.contains(CascadeType.DETACH) && !cascadeTypes.contains(CascadeType.ALL)) break;
                        Node childNode = children.get(nodeLink);
                        childNode.detach();
                    }
                }
            }
        }
    }

    public static enum OPERATION {
        PERSIST,
        MERGE,
        REMOVE,
        REFRESH,
        DETACH;

    }
}

