/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.loader;

import com.impetus.kundera.loader.PersistenceLoaderException;
import com.impetus.kundera.metadata.model.PersistenceUnitMetadata;
import com.impetus.kundera.utils.InvalidConfigurationException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PersistenceXMLLoader {
    private static Logger log = LoggerFactory.getLogger(PersistenceXMLLoader.class);

    private PersistenceXMLLoader() {
    }

    private static Document getDocument(URL pathToPersistenceXml) throws InvalidConfigurationException {
        InputStream is = null;
        Document xmlRootNode = null;
        try {
            if (pathToPersistenceXml != null) {
                URLConnection conn = pathToPersistenceXml.openConnection();
                conn.setUseCaches(false);
                is = conn.getInputStream();
            }
            if (is == null) {
                throw new IOException("Failed to obtain InputStream from url: " + pathToPersistenceXml);
            }
            xmlRootNode = PersistenceXMLLoader.parseDocument(is);
            PersistenceXMLLoader.validateDocumentAgainstSchema(xmlRootNode);
        }
        catch (IOException e) {
            throw new InvalidConfigurationException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    log.warn("Input stream could not be closed after parsing persistence.xml, caused by: {}", (Throwable)ex);
                }
            }
        }
        return xmlRootNode;
    }

    private static Document parseDocument(InputStream is) throws InvalidConfigurationException {
        Document persistenceXmlDoc;
        ArrayList parsingErrors = new ArrayList();
        InputSource source = new InputSource(is);
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            docBuilder.setErrorHandler(new ErrorLogger("XML InputStream", parsingErrors));
            persistenceXmlDoc = docBuilder.parse(source);
        }
        catch (ParserConfigurationException e) {
            log.error("Error during parsing, Caused by: {}.", (Throwable)e);
            throw new PersistenceLoaderException("Error during parsing persistence.xml, caused by: ", e);
        }
        catch (IOException e) {
            throw new InvalidConfigurationException("Error reading persistence.xml, caused by: ", e);
        }
        catch (SAXException e) {
            throw new InvalidConfigurationException("Error parsing persistence.xml, caused by: ", e);
        }
        if (!parsingErrors.isEmpty()) {
            throw new InvalidConfigurationException("Invalid persistence.xml", (Throwable)parsingErrors.get(0));
        }
        return persistenceXmlDoc;
    }

    private static void validateDocumentAgainstSchema(Document xmlRootNode) throws InvalidConfigurationException {
        Element rootElement = xmlRootNode.getDocumentElement();
        String version = rootElement.getAttribute("version");
        String schemaFileName = "persistence_" + version.replace(".", "_") + ".xsd";
        try {
            ArrayList validationErrors = new ArrayList();
            String schemaLanguage = "http://www.w3.org/2001/XMLSchema";
            StreamSource streamSource = new StreamSource(PersistenceXMLLoader.getStreamFromClasspath(schemaFileName));
            Schema schemaDefinition = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(streamSource);
            Validator schemaValidator = schemaDefinition.newValidator();
            schemaValidator.setErrorHandler(new ErrorLogger("XML InputStream", validationErrors));
            schemaValidator.validate(new DOMSource(xmlRootNode));
            if (!validationErrors.isEmpty()) {
                String exceptionText = "persistence.xml is not conform against the supported schema definitions.";
                throw new InvalidConfigurationException("persistence.xml is not conform against the supported schema definitions.");
            }
        }
        catch (SAXException e) {
            String exceptionText = "Error validating persistence.xml against schema defintion, caused by: ";
            throw new InvalidConfigurationException("Error validating persistence.xml against schema defintion, caused by: ", e);
        }
        catch (IOException e) {
            String exceptionText = "Error opening xsd schema file. The given persistence.xml descriptor version " + version + " might not be supported yet.";
            throw new InvalidConfigurationException(exceptionText, e);
        }
    }

    private static InputStream getStreamFromClasspath(String fileName) {
        String path = fileName;
        InputStream dtdStream = PersistenceXMLLoader.class.getClassLoader().getResourceAsStream(path);
        return dtdStream;
    }

    public static List<PersistenceUnitMetadata> findPersistenceUnits(URL url, String[] persistenceUnits) throws Exception {
        return PersistenceXMLLoader.findPersistenceUnits(url, persistenceUnits, PersistenceUnitTransactionType.JTA);
    }

    public static List<PersistenceUnitMetadata> findPersistenceUnits(URL url, String[] persistenceUnits, PersistenceUnitTransactionType defaultTransactionType) throws InvalidConfigurationException {
        Document doc = PersistenceXMLLoader.getDocument(url);
        doc.getXmlVersion();
        Element top = doc.getDocumentElement();
        String versionName = top.getAttribute("version");
        NodeList children = top.getChildNodes();
        ArrayList<PersistenceUnitMetadata> units = new ArrayList<PersistenceUnitMetadata>();
        for (int i = 0; i < children.getLength(); ++i) {
            PersistenceUnitMetadata metadata;
            Element element;
            String tag;
            if (children.item(i).getNodeType() != 1 || !(tag = (element = (Element)children.item(i)).getTagName()).equals("persistence-unit") || (metadata = PersistenceXMLLoader.parsePersistenceUnit(url, persistenceUnits, element, versionName)) == null) continue;
            units.add(metadata);
        }
        return units;
    }

    private static PersistenceUnitMetadata parsePersistenceUnit(URL url, String[] persistenceUnits, Element top, String versionName) {
        PersistenceUnitMetadata metadata = new PersistenceUnitMetadata(versionName, PersistenceXMLLoader.getPersistenceRootUrl(url), url);
        String puName = top.getAttribute("name");
        if (!Arrays.asList(persistenceUnits).contains(puName)) {
            return null;
        }
        if (!PersistenceXMLLoader.isEmpty(puName)) {
            log.trace("Persistent Unit name from persistence.xml: " + puName);
            metadata.setPersistenceUnitName(puName);
            String transactionType = top.getAttribute("transaction-type");
            if (StringUtils.isEmpty((String)transactionType) || PersistenceUnitTransactionType.RESOURCE_LOCAL.name().equals(transactionType)) {
                metadata.setTransactionType(PersistenceUnitTransactionType.RESOURCE_LOCAL);
            } else if (PersistenceUnitTransactionType.JTA.name().equals(transactionType)) {
                metadata.setTransactionType(PersistenceUnitTransactionType.JTA);
            }
        }
        NodeList children = top.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 1) continue;
            Element element = (Element)children.item(i);
            String tag = element.getTagName();
            if (tag.equals("provider")) {
                metadata.setProvider(PersistenceXMLLoader.getElementContent(element));
                continue;
            }
            if (tag.equals("properties")) {
                NodeList props = element.getChildNodes();
                for (int j = 0; j < props.getLength(); ++j) {
                    Element propElement;
                    if (props.item(j).getNodeType() != 1 || !"property".equals((propElement = (Element)props.item(j)).getTagName())) continue;
                    String propName = propElement.getAttribute("name").trim();
                    String propValue = propElement.getAttribute("value").trim();
                    if (PersistenceXMLLoader.isEmpty(propValue)) {
                        propValue = PersistenceXMLLoader.getElementContent(propElement, "");
                    }
                    metadata.getProperties().put(propName, propValue);
                }
                continue;
            }
            if (tag.equals("class")) {
                metadata.getClasses().add(PersistenceXMLLoader.getElementContent(element));
                continue;
            }
            if (tag.equals("jar-file")) {
                metadata.addJarFile(PersistenceXMLLoader.getElementContent(element));
                continue;
            }
            if (!tag.equals("exclude-unlisted-classes")) continue;
            String excludeUnlisted = PersistenceXMLLoader.getElementContent(element);
            metadata.setExcludeUnlistedClasses(Boolean.parseBoolean(excludeUnlisted));
        }
        PersistenceUnitTransactionType transactionType = PersistenceXMLLoader.getTransactionType(top.getAttribute("transaction-type"));
        if (transactionType != null) {
            metadata.setTransactionType(transactionType);
        }
        return metadata;
    }

    public static PersistenceUnitTransactionType getTransactionType(String elementContent) {
        if (elementContent == null || elementContent.isEmpty()) {
            return null;
        }
        if (elementContent.equalsIgnoreCase("JTA")) {
            return PersistenceUnitTransactionType.JTA;
        }
        if (elementContent.equalsIgnoreCase("RESOURCE_LOCAL")) {
            return PersistenceUnitTransactionType.RESOURCE_LOCAL;
        }
        throw new PersistenceException("Unknown TransactionType: " + elementContent);
    }

    private static boolean isEmpty(String str) {
        return null == str || str.isEmpty();
    }

    public static String getElementContent(Element element) {
        return PersistenceXMLLoader.getElementContent(element, null);
    }

    private static String getElementContent(Element element, String defaultStr) {
        if (element == null) {
            return defaultStr;
        }
        NodeList children = element.getChildNodes();
        StringBuilder result = new StringBuilder("");
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 3 && children.item(i).getNodeType() != 4) continue;
            result.append(children.item(i).getNodeValue());
        }
        return result.toString().trim();
    }

    private static URL getPersistenceRootUrl(URL url) {
        String f = url.getFile();
        f = PersistenceXMLLoader.parseFilePath(f);
        URL jarUrl = url;
        try {
            if (AllowedProtocol.isJarProtocol(url.getProtocol())) {
                jarUrl = new URL(f);
                if (jarUrl.getProtocol() != null && AllowedProtocol.FILE.name().equals(jarUrl.getProtocol().toUpperCase()) && StringUtils.contains((String)f, (String)" ")) {
                    jarUrl = new File(f).toURI().toURL();
                }
            } else if (AllowedProtocol.isValidProtocol(url.getProtocol())) {
                jarUrl = StringUtils.contains((String)f, (String)" ") ? new File(f).toURI().toURL() : new File(f).toURL();
            }
        }
        catch (MalformedURLException mex) {
            log.error("Error during getPersistenceRootUrl(), Caused by: {}.", (Throwable)mex);
            throw new IllegalArgumentException("Invalid jar URL[] provided!" + url);
        }
        return jarUrl;
    }

    private static String parseFilePath(String file) {
        String excludePattern = "/META-INF/persistence.xml";
        file = (file = file.substring(0, file.length() - "/META-INF/persistence.xml".length())).endsWith("!") ? file.substring(0, file.length() - 1) : file;
        return file;
    }

    public static enum AllowedProtocol {
        WSJAR,
        JAR,
        ZIP,
        FILE,
        VFSZIP,
        VFS;


        public static boolean isJarProtocol(String protocol) {
            return protocol != null && (protocol.toUpperCase().equals(JAR.name()) || protocol.toUpperCase().equals(WSJAR.name()));
        }

        public static boolean isValidProtocol(String protocol) {
            try {
                AllowedProtocol.valueOf(protocol.toUpperCase());
                return true;
            }
            catch (IllegalArgumentException iex) {
                return false;
            }
        }
    }

    public static class ErrorLogger
    implements ErrorHandler {
        private String file;
        private List errors;

        ErrorLogger(String file, List errors) {
            this.file = file;
            this.errors = errors;
        }

        @Override
        public void error(SAXParseException error) {
            log.error("Error parsing XML: " + this.file + '(' + error.getLineNumber() + ") " + error.getMessage());
            this.errors.add(error);
        }

        @Override
        public void fatalError(SAXParseException error) {
            log.error("Error parsing XML: " + this.file + '(' + error.getLineNumber() + ") " + error.getMessage());
            this.errors.add(error);
        }

        @Override
        public void warning(SAXParseException warn) {
            log.warn("Warning parsing XML: " + this.file + '(' + warn.getLineNumber() + ") " + warn.getMessage());
        }
    }
}

