/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.metadata;

import com.impetus.kundera.KunderaException;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.MetamodelImpl;
import com.impetus.kundera.metadata.model.PersistenceUnitMetadata;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KunderaMetadataManager {
    private static Logger log = LoggerFactory.getLogger(KunderaMetadataManager.class);

    public static PersistenceUnitMetadata getPersistenceUnitMetadata(EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata, String persistenceUnit) {
        if (persistenceUnit != null && kunderaMetadata != null) {
            return kunderaMetadata.getApplicationMetadata().getPersistenceUnitMetadata(persistenceUnit);
        }
        return null;
    }

    public static MetamodelImpl getMetamodel(EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata, String persistenceUnit) {
        MetamodelImpl metamodel = (MetamodelImpl)kunderaMetadata.getApplicationMetadata().getMetamodel(persistenceUnit);
        return metamodel;
    }

    public static MetamodelImpl getMetamodel(EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata, String ... persistenceUnits) {
        MetamodelImpl metamodel = null;
        for (String pu : persistenceUnits) {
            metamodel = (MetamodelImpl)kunderaMetadata.getApplicationMetadata().getMetamodel(pu);
            if (metamodel == null) continue;
            return metamodel;
        }
        return metamodel;
    }

    public static EntityMetadata getEntityMetadata(EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata, String persistenceUnit, Class entityClass) {
        return KunderaMetadataManager.getMetamodel(kunderaMetadata, persistenceUnit).getEntityMetadata(entityClass);
    }

    public static EntityMetadata getEntityMetadata(EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata, Class entityClass) {
        if (entityClass == null) {
            throw new KunderaException("Invalid class provided " + entityClass);
        }
        List<String> persistenceUnits = kunderaMetadata.getApplicationMetadata().getMappedPersistenceUnit(entityClass);
        if (persistenceUnits != null) {
            for (String pu : persistenceUnits) {
                MetamodelImpl metamodel = KunderaMetadataManager.getMetamodel(kunderaMetadata, pu);
                EntityMetadata metadata = metamodel.getEntityMetadata(entityClass);
                if (metadata == null || !metadata.getPersistenceUnit().equals(pu)) continue;
                return metadata;
            }
        }
        if (log.isDebugEnabled()) {
            log.warn("No Entity metadata found for the class " + entityClass + ". Any CRUD operation on this entity will fail." + "If your entity is for RDBMS, make sure you put fully qualified entity class" + " name under <class></class> tag in persistence.xml for RDBMS " + "persistence unit. Returning null value.");
        }
        return null;
    }
}

