/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.metadata.model;

import com.impetus.kundera.metadata.model.ApplicationLoaderException;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.IdDiscriptor;
import com.impetus.kundera.metadata.model.MetamodelImpl;
import com.impetus.kundera.metadata.model.PersistenceUnitMetadata;
import com.impetus.kundera.metadata.processor.MetaModelBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationMetadata {
    private Map<String, Metamodel> metamodelMap = new ConcurrentHashMap<String, Metamodel>();
    private Map<String, PersistenceUnitMetadata> persistenceUnitMetadataMap = new ConcurrentHashMap<String, PersistenceUnitMetadata>();
    private static Logger logger = LoggerFactory.getLogger(ApplicationMetadata.class);
    private Map<String, MetaModelBuilder> metaModelBuilder = new ConcurrentHashMap<String, MetaModelBuilder>();
    private Map<String, List<String>> clazzToPuMap;
    private Map<String, QueryWrapper> namedNativeQueries;

    public void addEntityMetadata(String persistenceUnit, Class<?> clazz, EntityMetadata entityMetadata) {
        Metamodel metamodel = this.getMetamodelMap().get(persistenceUnit);
        Map<String, EntityMetadata> entityClassToMetadataMap = ((MetamodelImpl)metamodel).getEntityMetadataMap();
        if (entityClassToMetadataMap == null || entityClassToMetadataMap.isEmpty()) {
            entityClassToMetadataMap.put(clazz.getName(), entityMetadata);
        } else if (logger.isDebugEnabled()) {
            logger.debug("Entity meta model already exists for persistence unit " + persistenceUnit + " and class " + clazz + ". Noting needs to be done");
        }
    }

    public void addPersistenceUnitMetadata(Map<String, PersistenceUnitMetadata> metadata) {
        this.getPersistenceUnitMetadataMap().putAll(metadata);
    }

    public Map<String, Metamodel> getMetamodelMap() {
        if (this.metamodelMap == null) {
            this.metamodelMap = new HashMap<String, Metamodel>();
        }
        return this.metamodelMap;
    }

    public PersistenceUnitMetadata getPersistenceUnitMetadata(String persistenceUnit) {
        return this.getPersistenceUnitMetadataMap().get(persistenceUnit);
    }

    public Metamodel getMetamodel(String persistenceUnit) {
        Map<String, Metamodel> model = this.getMetamodelMap();
        return persistenceUnit != null && model.containsKey(persistenceUnit) ? model.get(persistenceUnit) : null;
    }

    public Map<String, PersistenceUnitMetadata> getPersistenceUnitMetadataMap() {
        return this.persistenceUnitMetadataMap;
    }

    public void setClazzToPuMap(Map<String, List<String>> map) {
        if (this.clazzToPuMap == null) {
            this.clazzToPuMap = map;
        } else {
            this.clazzToPuMap.putAll(map);
        }
    }

    public List<String> getMappedPersistenceUnit(Class<?> clazz) {
        return this.clazzToPuMap != null ? this.clazzToPuMap.get(clazz.getName()) : null;
    }

    public String getMappedPersistenceUnit(String clazzName) {
        List<String> pus = this.clazzToPuMap.get(clazzName);
        boolean _first = false;
        String pu = null;
        if (pus != null && !pus.isEmpty()) {
            if (pus.size() == 2) {
                this.onError(clazzName);
            }
            return pus.get(0);
        }
        Set<String> mappedClasses = this.clazzToPuMap.keySet();
        boolean found = false;
        for (String clazz : mappedClasses) {
            if (found && clazz.endsWith("." + clazzName)) {
                this.onError(clazzName);
                continue;
            }
            if (!clazz.endsWith("." + clazzName) && !clazz.endsWith("$" + clazzName)) continue;
            pu = this.clazzToPuMap.get(clazz).get(0);
            found = true;
        }
        return pu;
    }

    public void addQueryToCollection(String queryName, String query, boolean isNativeQuery, Class clazz) {
        if (this.namedNativeQueries == null) {
            this.namedNativeQueries = new ConcurrentHashMap<String, QueryWrapper>();
        }
        if (!this.namedNativeQueries.containsKey(queryName)) {
            this.namedNativeQueries.put(queryName, new QueryWrapper(queryName, query, isNativeQuery, clazz));
        } else if (queryName != null && !this.getQuery(queryName).equals(query)) {
            logger.error("Duplicate named/native query with name:" + queryName + "found! Already there is a query with same name:" + this.namedNativeQueries.get(queryName));
            throw new ApplicationLoaderException("Duplicate named/native query with name:" + queryName + "found! Already there is a query with same name:" + this.namedNativeQueries.get(queryName));
        }
    }

    public String getQuery(String name) {
        QueryWrapper wrapper = this.namedNativeQueries != null && name != null ? this.namedNativeQueries.get(name) : null;
        return wrapper != null ? wrapper.getQuery() : null;
    }

    public boolean isNative(String name) {
        QueryWrapper wrapper = this.namedNativeQueries != null && name != null ? this.namedNativeQueries.get(name) : null;
        return wrapper != null ? wrapper.isNativeQuery() : false;
    }

    public Class getMappedClass(String name) {
        QueryWrapper wrapper = this.namedNativeQueries != null && name != null ? this.namedNativeQueries.get(name) : null;
        return wrapper != null ? wrapper.getMappedClazz() : null;
    }

    private void onError(String clazzName) {
        logger.error("Duplicate name:" + clazzName + "Please provide entity with complete package name.");
        throw new ApplicationLoaderException("Duplicate name:" + clazzName + "Please provide entity with complete package name");
    }

    public MetaModelBuilder getMetaModelBuilder(String persistenceUnit) {
        if (this.metaModelBuilder.containsKey(persistenceUnit)) {
            return this.metaModelBuilder.get(persistenceUnit);
        }
        MetaModelBuilder builder = new MetaModelBuilder();
        this.metaModelBuilder.put(persistenceUnit, builder);
        return builder;
    }

    void unloadApplicationMatadata(String pu) {
        PersistenceUnitMetadata puMetadata;
        MetaModelBuilder builder;
        Metamodel metamodel = this.getMetamodel(pu);
        if (metamodel != null) {
            this.metamodelMap.remove(pu);
            ((MetamodelImpl)metamodel).setEntityMetadataMap(null);
            ((MetamodelImpl)metamodel).setEntityNameToClassMap(null);
            ((MetamodelImpl)metamodel).addKeyValues(new HashMap<String, IdDiscriptor>());
        }
        if ((builder = this.getMetaModelBuilder(pu)) != null) {
            this.metaModelBuilder.remove(pu);
            builder = null;
        }
        if ((puMetadata = this.getPersistenceUnitMetadata(pu)) != null) {
            this.persistenceUnitMetadataMap.remove(pu);
            puMetadata.setClasses(new ArrayList<String>());
            puMetadata.setExcludeUnlistedClasses(false);
            puMetadata.setPackages(new ArrayList<String>());
            puMetadata.setPersistenceUnitName(null);
            puMetadata.setProperties(new Properties());
            puMetadata.setTransactionType(PersistenceUnitTransactionType.RESOURCE_LOCAL);
            puMetadata.setProvider(null);
            puMetadata = null;
        }
    }

    private class QueryWrapper {
        private String queryName;
        private String query;
        private boolean isNativeQuery;
        private Class entityClazz;

        public QueryWrapper(String queryName, String query, boolean isNativeQuery, Class clazz) {
            this.queryName = queryName;
            this.query = query;
            this.isNativeQuery = isNativeQuery;
            this.entityClazz = clazz;
        }

        String getQuery() {
            return this.query;
        }

        boolean isNativeQuery() {
            return this.isNativeQuery;
        }

        Class getMappedClazz() {
            return this.entityClazz;
        }
    }
}

