/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.metadata.model;

import com.impetus.kundera.loader.PersistenceLoaderException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceUnitMetadata
implements PersistenceUnitInfo {
    private static Logger log = LoggerFactory.getLogger(PersistenceUnitMetadata.class);
    private String persistenceUnitName;
    private String provider;
    private PersistenceUnitTransactionType transactionType;
    private List<String> classes = new ArrayList<String>();
    private List<String> packages = new ArrayList<String>();
    private Set<String> jarFiles;
    private Set<URL> jarUrls;
    private Properties properties = new Properties();
    private boolean excludeUnlistedClasses = false;
    private URL rootUrl;
    private String schemaVersion;
    private URL mappedUrl;

    public PersistenceUnitMetadata() {
    }

    public PersistenceUnitMetadata(String xmlSchemaVersion, URL rootUrl, URL mappingFileUrl) {
        this.schemaVersion = xmlSchemaVersion;
        this.rootUrl = rootUrl;
        this.mappedUrl = mappingFileUrl;
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public void setPersistenceUnitName(String persistenceUnitName) {
        this.persistenceUnitName = persistenceUnitName;
    }

    public void setTransactionType(PersistenceUnitTransactionType transactionType) {
        this.transactionType = transactionType;
    }

    public void setProvider(String provider) {
        if (provider != null && provider.endsWith(".class")) {
            this.provider = provider.substring(0, provider.length() - 6);
        }
        this.provider = provider;
    }

    public List<String> getClasses() {
        return this.classes;
    }

    public void setClasses(List<String> classes) {
        this.classes = classes;
    }

    public List<String> getPackages() {
        return this.packages;
    }

    public void setPackages(List<String> packages) {
        this.packages = packages;
    }

    public Set<String> getJarFiles() {
        return this.jarFiles;
    }

    public void addJarFile(String jarFile) {
        if (this.jarFiles == null) {
            this.jarFiles = new HashSet<String>();
        }
        this.jarFiles.add(jarFile);
        this.addJarFileUrl(jarFile);
    }

    public boolean getExcludeUnlistedClasses() {
        return this.excludeUnlistedClasses;
    }

    public void setExcludeUnlistedClasses(boolean excludeUnlistedClasses) {
        this.excludeUnlistedClasses = excludeUnlistedClasses;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PersistenceMetadata [name=");
        builder.append(this.persistenceUnitName);
        builder.append(", provider=");
        builder.append(this.provider);
        builder.append(", transactionType=");
        builder.append(this.transactionType);
        builder.append(", classes=");
        builder.append(this.classes);
        builder.append(", excludeUnlistedClasses=");
        builder.append(this.excludeUnlistedClasses);
        builder.append(", jarFiles=");
        builder.append(this.jarFiles);
        builder.append(", packages=");
        builder.append(this.packages);
        builder.append(", props=");
        builder.append(this.properties);
        builder.append("]");
        return builder.toString();
    }

    public String getPersistenceProviderClassName() {
        return this.provider;
    }

    public PersistenceUnitTransactionType getTransactionType() {
        return this.transactionType;
    }

    public DataSource getJtaDataSource() {
        return null;
    }

    public DataSource getNonJtaDataSource() {
        return null;
    }

    public List<String> getMappingFileNames() {
        return null;
    }

    public List<URL> getJarFileUrls() {
        return this.jarUrls != null ? new ArrayList<URL>(this.jarUrls) : null;
    }

    public URL getPersistenceUnitRootUrl() {
        return this.rootUrl;
    }

    public List<String> getManagedClassNames() {
        return this.classes;
    }

    public boolean excludeUnlistedClasses() {
        return this.excludeUnlistedClasses;
    }

    public SharedCacheMode getSharedCacheMode() {
        return null;
    }

    public ValidationMode getValidationMode() {
        return null;
    }

    public Properties getProperties() {
        if (this.properties == null) {
            throw new PersistenceLoaderException(" Error while loading metadata as perssitenceUnitMetadata is null");
        }
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getPersistenceXMLSchemaVersion() {
        return this.schemaVersion;
    }

    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    public void addTransformer(ClassTransformer paramClassTransformer) {
    }

    public ClassLoader getNewTempClassLoader() {
        return null;
    }

    public String getProperty(String prop) {
        return prop != null ? this.getProperties().getProperty(prop) : null;
    }

    public List<URL> getManagedURLs() {
        List<URL> managedURL = this.getJarFileUrls();
        if (managedURL == null) {
            managedURL = new ArrayList<URL>(1);
        }
        if (!this.getExcludeUnlistedClasses()) {
            managedURL.add(this.getPersistenceUnitRootUrl());
        }
        return managedURL;
    }

    private void addJarFileUrl(String jarFile) {
        if (this.jarUrls == null) {
            this.jarUrls = new HashSet<URL>();
        }
        try {
            this.jarUrls.add(new File(jarFile).toURI().toURL());
        }
        catch (MalformedURLException e) {
            log.error("Error while mapping jar-file url" + jarFile + "caused by:" + e.getMessage());
            throw new IllegalArgumentException("Invalid jar-file URL:" + jarFile + "Caused by: " + e);
        }
    }

    public String getClient() {
        String client = null;
        if (this.properties != null) {
            client = (String)this.properties.get("kundera.client.lookup.class");
        }
        if (client == null) {
            log.error("kundera.client property is missing for persistence unit:" + this.persistenceUnitName);
            throw new IllegalArgumentException("kundera.client property is missing for persistence unit:" + this.persistenceUnitName);
        }
        return client;
    }

    private boolean isBatch() {
        return this.getProperty("kundera.batch.size") != null;
    }

    public int getBatchSize() {
        if (this.isBatch()) {
            String batchSize = this.getProperty("kundera.batch.size");
            int batch_Size = Integer.valueOf(batchSize);
            if (batch_Size == 0) {
                throw new IllegalArgumentException("kundera.batch.size property must be numeric and > 0");
            }
            return batch_Size;
        }
        return 0;
    }

    public URL getMappedUrl() {
        return this.mappedUrl;
    }
}

