/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.metadata.model.attributes;

import com.impetus.kundera.metadata.model.annotation.DefaultFieldAnnotationProcessor;
import com.impetus.kundera.metadata.model.annotation.FieldAnnotationProcessor;
import com.impetus.kundera.metadata.model.type.AbstractManagedType;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.Date;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.JoinColumn;
import javax.persistence.Temporal;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAttribute<X, T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractAttribute.class);
    protected Type<T> attribType;
    private String attribName;
    private Attribute.PersistentAttributeType persistenceAttribType;
    private ManagedType<X> managedType;
    protected Field member;
    private String columnName;
    private String tableName;
    private FieldAnnotationProcessor fieldAnnotationProcessor;

    AbstractAttribute(Type<T> attribType, String attribName, Attribute.PersistentAttributeType persistenceAttribType, ManagedType<X> managedType, Field member) {
        this.attribType = attribType;
        this.attribName = attribName;
        this.persistenceAttribType = persistenceAttribType;
        this.managedType = managedType;
        this.member = member;
        this.columnName = this.getValidJPAColumnName();
        this.fieldAnnotationProcessor = new DefaultFieldAnnotationProcessor(member);
        this.fieldAnnotationProcessor.validateFieldAnnotation(this.fieldAnnotationProcessor.getAnnotation(Column.class.getName()), member, this.managedType);
        this.tableName = this.getTableName();
    }

    public abstract Bindable.BindableType getBindableType();

    public abstract boolean isCollection();

    public Class<T> getBindableJavaType() {
        return this.attribType.getJavaType();
    }

    public String getName() {
        return this.attribName;
    }

    public Attribute.PersistentAttributeType getPersistentAttributeType() {
        return this.persistenceAttribType;
    }

    public ManagedType<X> getDeclaringType() {
        return this.managedType;
    }

    public Member getJavaMember() {
        return this.member;
    }

    public boolean isAssociation() {
        return this.persistenceAttribType.equals((Object)Attribute.PersistentAttributeType.MANY_TO_MANY) || this.persistenceAttribType.equals((Object)Attribute.PersistentAttributeType.MANY_TO_ONE) || this.persistenceAttribType.equals((Object)Attribute.PersistentAttributeType.ONE_TO_MANY) || this.persistenceAttribType.equals((Object)Attribute.PersistentAttributeType.ONE_TO_ONE);
    }

    public String getJPAColumnName() {
        Column column = ((AbstractManagedType)this.managedType).getAttributeBinding(this.member);
        if (column != null) {
            this.columnName = column.name();
        }
        return this.columnName;
    }

    public String getTableName() {
        return ((DefaultFieldAnnotationProcessor)this.fieldAnnotationProcessor).getTableNameOfColumn();
    }

    private final String getValidJPAColumnName() {
        Column c;
        String name = null;
        if (this.member.isAnnotationPresent(Column.class) && !(c = this.member.getAnnotation(Column.class)).name().isEmpty()) {
            name = c.name();
        }
        if (this.member.isAnnotationPresent(Temporal.class)) {
            if (!this.member.getType().equals(Date.class)) {
                log.error("@Temporal must map to java.util.Date for @Entity(" + this.managedType.getJavaType() + "." + this.member.getName() + ")");
                return name;
            }
        } else if (this.member.isAnnotationPresent(JoinColumn.class)) {
            c = this.member.getAnnotation(JoinColumn.class);
            if (!c.name().isEmpty()) {
                name = c.name();
            }
        } else if (this.member.isAnnotationPresent(CollectionTable.class) && !(c = this.member.getAnnotation(CollectionTable.class)).name().isEmpty()) {
            name = c.name();
        }
        return name == null ? this.getName() : name;
    }

    public FieldAnnotationProcessor getFieldAnnotation() {
        return this.fieldAnnotationProcessor;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }
}

