/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.metadata.model.attributes;

import com.impetus.kundera.metadata.model.attributes.AbstractAttribute;
import java.lang.reflect.Field;
import javax.persistence.Column;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSingularAttribute<X, T>
extends AbstractAttribute<X, T>
implements SingularAttribute<X, T> {
    private static Logger log = LoggerFactory.getLogger(DefaultSingularAttribute.class);
    private boolean isId;

    public DefaultSingularAttribute(String attribName, Attribute.PersistentAttributeType persistenceAttribType, Field member, Type<T> attribType, ManagedType<X> managedType, boolean isId) {
        super(attribType, attribName, persistenceAttribType, managedType, member);
        this.isId = isId;
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public Bindable.BindableType getBindableType() {
        return Bindable.BindableType.SINGULAR_ATTRIBUTE;
    }

    public boolean isId() {
        return this.isId;
    }

    public boolean isVersion() {
        log.info("Currently versioning is not supported in kundera, returning false as default");
        return false;
    }

    public boolean isOptional() {
        boolean isNullable = true;
        if (!this.isId()) {
            Column anno = this.member.getAnnotation(Column.class);
            if (anno != null) {
                isNullable = anno.nullable();
            }
        } else {
            isNullable = false;
        }
        return isNullable;
    }

    public Type<T> getType() {
        return this.attribType;
    }

    public Class<T> getJavaType() {
        return this.attribType.getJavaType();
    }
}

