/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.metadata.processor;

import com.impetus.kundera.index.Index;
import com.impetus.kundera.index.IndexCollection;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.PropertyIndex;
import com.impetus.kundera.metadata.model.attributes.AbstractAttribute;
import com.impetus.kundera.metadata.processor.AbstractEntityFieldProcessor;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.persistence.Column;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexProcessor
extends AbstractEntityFieldProcessor {
    private static Logger log = LoggerFactory.getLogger(IndexProcessor.class);

    public IndexProcessor(EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        super(kunderaMetadata);
    }

    @Override
    public final void process(Class<?> clazz, EntityMetadata metadata) {
        if (clazz != null) {
            metadata.setIndexName(clazz.getSimpleName());
        }
        IndexCollection indexes = clazz.getAnnotation(IndexCollection.class);
        EntityType<?> entityType = this.kunderaMetadata.getApplicationMetadata().getMetaModelBuilder(metadata.getPersistenceUnit()).getManagedTypes().get(clazz);
        ArrayList columnsNameToBeIndexed = new ArrayList();
        HashMap<String, Index> indexedColumnsMap = new HashMap<String, Index>();
        if (null != indexes) {
            if (indexes.columns() != null && indexes.columns().length != 0) {
                metadata.setIndexable(true);
                for (Index indexedColumn : indexes.columns()) {
                    if (indexedColumn.type().equals("composite")) {
                        metadata.addIndexProperty(this.prepareCompositeIndexName(indexedColumn.name(), entityType, metadata), IndexProcessor.populatePropertyIndex(indexedColumn.indexName(), indexedColumn.type(), null, null, null));
                        continue;
                    }
                    indexedColumnsMap.put(indexedColumn.name(), indexedColumn);
                }
            }
        } else {
            log.debug("@Entity " + clazz.getName() + " will not be indexed for " + (indexedColumnsMap.isEmpty() ? "all columns" : indexedColumnsMap));
            return;
        }
        log.debug("Processing @Entity " + clazz.getName() + " for Indexes.");
        Set attributes = entityType.getAttributes();
        for (Attribute attrib : attributes) {
            if (attrib.isAssociation()) continue;
            String colName = attrib.getName();
            String columnName = ((AbstractAttribute)attrib).getJPAColumnName();
            if (indexedColumnsMap != null && !indexedColumnsMap.isEmpty() && indexedColumnsMap.containsKey(colName)) {
                Index indexedColumn = (Index)indexedColumnsMap.get(colName);
                String indexName = StringUtils.isBlank((String)indexedColumn.indexName()) ? columnName : indexedColumn.indexName();
                metadata.addIndexProperty(columnName, IndexProcessor.populatePropertyIndex(indexName, indexedColumn.type(), indexedColumn.max(), indexedColumn.min(), (Field)attrib.getJavaMember()));
                continue;
            }
            if (columnsNameToBeIndexed == null || columnsNameToBeIndexed.isEmpty() || !columnsNameToBeIndexed.contains(colName)) continue;
            metadata.addIndexProperty(columnName, IndexProcessor.populatePropertyIndex(columnName, null, null, null, (Field)attrib.getJavaMember()));
        }
    }

    private static PropertyIndex populatePropertyIndex(String indexName, String indexType, Integer max, Integer min, Field f) {
        PropertyIndex pi = new PropertyIndex(f, indexName, indexType);
        pi.setMax(max);
        pi.setMin(min);
        return pi;
    }

    public static Map<String, PropertyIndex> getIndexesOnEmbeddable(Class<?> entityClazz) {
        HashMap<String, PropertyIndex> pis = new HashMap<String, PropertyIndex>();
        IndexCollection indexes = entityClazz.getAnnotation(IndexCollection.class);
        List<String> columnsNameToBeIndexed = null;
        HashMap<String, Index> columnsToBeIndexed = null;
        if (null != indexes) {
            columnsToBeIndexed = new HashMap<String, Index>();
            if (indexes.columns() != null && indexes.columns().length != 0) {
                for (Index indexedColumn : indexes.columns()) {
                    columnsToBeIndexed.put(indexedColumn.name(), indexedColumn);
                }
            }
        }
        IndexProcessor.getPropertyIndexes(entityClazz, pis, columnsNameToBeIndexed, columnsToBeIndexed);
        return pis;
    }

    private static void getPropertyIndexes(Class<?> entityClazz, Map<String, PropertyIndex> pis, List<String> columnsNameToBeIndexed, Map<String, Index> columnsToBeIndexed) {
        for (Field f : entityClazz.getDeclaredFields()) {
            if (!f.isAnnotationPresent(Column.class)) continue;
            String fieldName = f.getName();
            if (columnsToBeIndexed != null && !columnsToBeIndexed.isEmpty() && columnsToBeIndexed.containsKey(fieldName)) {
                Index indexedColumn = columnsToBeIndexed.get(fieldName);
                pis.put(indexedColumn.name(), IndexProcessor.populatePropertyIndex(indexedColumn.name(), indexedColumn.type(), indexedColumn.max(), indexedColumn.min(), f));
                continue;
            }
            if (columnsNameToBeIndexed == null || columnsNameToBeIndexed.isEmpty() || !columnsNameToBeIndexed.contains(fieldName)) continue;
            pis.put(fieldName, IndexProcessor.populatePropertyIndex(fieldName, null, null, null, f));
        }
    }

    private String prepareCompositeIndexName(String indexedColumns, EntityType entityType, EntityMetadata metadata) {
        StringTokenizer tokenizer = new StringTokenizer(indexedColumns, ",");
        StringBuilder builder = new StringBuilder();
        while (tokenizer.hasMoreTokens()) {
            String fieldName = (String)tokenizer.nextElement();
            StringTokenizer stringTokenizer = new StringTokenizer(fieldName, ".");
            if (stringTokenizer.countTokens() > 1) {
                fieldName = stringTokenizer.nextToken();
                String embeddedFieldName = stringTokenizer.nextToken();
                Attribute embeddable = entityType.getAttribute(fieldName);
                EmbeddableType embeddedEntity = (EmbeddableType)this.kunderaMetadata.getApplicationMetadata().getMetaModelBuilder(metadata.getPersistenceUnit()).getEmbeddables().get(((AbstractAttribute)embeddable).getBindableJavaType());
                Attribute embeddedAttribute = embeddedEntity.getAttribute(embeddedFieldName);
                builder.append(((AbstractAttribute)embeddedAttribute).getJPAColumnName());
            } else {
                builder.append(((AbstractAttribute)entityType.getAttribute(fieldName)).getJPAColumnName());
            }
            builder.append(",");
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }
}

