/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.metadata.processor;

import com.impetus.kundera.loader.MetamodelLoaderException;
import com.impetus.kundera.metadata.MetadataUtils;
import com.impetus.kundera.metadata.model.ApplicationMetadata;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.type.AbstractIdentifiableType;
import com.impetus.kundera.metadata.processor.AbstractEntityFieldProcessor;
import com.impetus.kundera.metadata.processor.MetaModelBuilder;
import com.impetus.kundera.metadata.processor.relation.RelationMetadataProcessor;
import com.impetus.kundera.metadata.processor.relation.RelationMetadataProcessorFactory;
import com.impetus.kundera.metadata.validator.EntityValidatorImpl;
import com.impetus.kundera.metadata.validator.InvalidEntityDefinitionException;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import com.impetus.kundera.validation.ValidationFactory;
import com.impetus.kundera.validation.ValidationFactoryGenerator;
import com.impetus.kundera.validation.rules.RelationAttributeRule;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import javassist.Modifier;
import javax.persistence.ElementCollection;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PersistenceException;
import javax.persistence.Transient;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.SingularAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableProcessor
extends AbstractEntityFieldProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(TableProcessor.class);
    private Map puProperties;
    private ValidationFactory factory;

    public TableProcessor(Map puProperty, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        super(kunderaMetadata);
        this.validator = new EntityValidatorImpl(puProperty);
        ValidationFactoryGenerator generator = new ValidationFactoryGenerator();
        this.factory = generator.getFactory(ValidationFactoryGenerator.ValidationFactoryType.BOOT_STRAP_VALIDATION);
        this.puProperties = puProperty;
    }

    public void process(Class clazz, EntityMetadata metadata) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing @Entity(" + clazz.getName() + ") for Persistence Object.");
        }
        this.populateMetadata(metadata, clazz, this.puProperties);
    }

    private <X extends Class, T> void populateMetadata(EntityMetadata metadata, Class<X> clazz, Map puProperties) {
        if (metadata.getPersistenceUnit() != null) {
            MetaModelBuilder metaModelBuilder = this.kunderaMetadata.getApplicationMetadata().getMetaModelBuilder(metadata.getPersistenceUnit());
            this.onBuildMetaModelSuperClass(clazz.getSuperclass(), metaModelBuilder);
            metaModelBuilder.process(clazz);
            for (Field f : clazz.getDeclaredFields()) {
                if (f == null || Modifier.isStatic((int)f.getModifiers()) || Modifier.isTransient((int)f.getModifiers()) || f.isAnnotationPresent(Transient.class)) continue;
                metaModelBuilder.construct(clazz, f);
                this.onIdAttribute(metaModelBuilder, metadata, clazz, f);
                this.onFamilyType(metadata, clazz, f);
            }
            EntityType<?> entityType = metaModelBuilder.getManagedTypes().get(metadata.getEntityClazz());
            this.validateAndSetId(metadata, clazz, metaModelBuilder);
            this.validateandSetEntityType(metadata, clazz, metaModelBuilder);
            MetadataUtils.onJPAColumnMapping(entityType, metadata);
            this.populateRelationMetaData(entityType, clazz, metadata);
        }
    }

    private <X> void populateRelationMetaData(EntityType entityType, Class<X> clazz, EntityMetadata metadata) {
        Set attributes = entityType.getAttributes();
        for (Attribute attribute : attributes) {
            if (!attribute.isAssociation()) continue;
            this.addRelationIntoMetadata(clazz, (Field)attribute.getJavaMember(), metadata);
        }
    }

    private <X, T> void onBuildMetaModelSuperClass(Class<? super X> clazz, MetaModelBuilder<X, T> metaModelBuilder) {
        if (clazz != null && clazz.isAnnotationPresent(Entity.class)) {
            while (clazz != null && clazz.isAnnotationPresent(Entity.class)) {
                metaModelBuilder.process(clazz);
                for (Field f : clazz.getDeclaredFields()) {
                    if (f == null || Modifier.isStatic((int)f.getModifiers()) || Modifier.isTransient((int)f.getModifiers()) || f.isAnnotationPresent(Transient.class)) continue;
                    metaModelBuilder.construct(clazz, f);
                }
                clazz = clazz.getSuperclass();
            }
        }
    }

    private void addRelationIntoMetadata(Class<?> entityClass, Field relationField, EntityMetadata metadata) {
        RelationMetadataProcessor relProcessor = null;
        try {
            relProcessor = RelationMetadataProcessorFactory.getRelationMetadataProcessor(relationField, this.kunderaMetadata);
            this.factory.validate(relationField, new RelationAttributeRule());
            relProcessor = RelationMetadataProcessorFactory.getRelationMetadataProcessor(relationField, this.kunderaMetadata);
            if (relProcessor != null) {
                relProcessor.addRelationIntoMetadata(relationField, metadata);
            }
        }
        catch (PersistenceException pe) {
            throw new MetamodelLoaderException("Error with relationship in @Entity(" + entityClass + "." + relationField.getName() + "), reason: " + (Object)((Object)pe));
        }
    }

    private void addNamedNativeQueryMetadata(Class clazz) {
        NamedQuery[] anns;
        NamedQuery ann;
        ApplicationMetadata appMetadata = this.kunderaMetadata.getApplicationMetadata();
        Object query = null;
        if (clazz.isAnnotationPresent(NamedQuery.class)) {
            ann = clazz.getAnnotation(NamedQuery.class);
            appMetadata.addQueryToCollection(ann.name(), ann.query(), false, clazz);
        }
        if (clazz.isAnnotationPresent(NamedQueries.class)) {
            ann = clazz.getAnnotation(NamedQueries.class);
            for (NamedQuery a : anns = ann.value()) {
                appMetadata.addQueryToCollection(a.name(), a.query(), false, clazz);
            }
        }
        if (clazz.isAnnotationPresent(NamedNativeQuery.class)) {
            ann = clazz.getAnnotation(NamedNativeQuery.class);
            appMetadata.addQueryToCollection(ann.name(), ann.query(), true, clazz);
        }
        if (clazz.isAnnotationPresent(NamedNativeQueries.class)) {
            ann = clazz.getAnnotation(NamedNativeQueries.class);
            for (NamedQuery a : anns = ann.value()) {
                appMetadata.addQueryToCollection(a.name(), a.query(), true, clazz);
            }
        }
    }

    private void onIdAttribute(MetaModelBuilder builder, EntityMetadata entityMetadata, Class clazz, Field f) {
        EntityType<?> entity = builder.getManagedTypes().get(clazz);
        Attribute attrib = entity.getAttribute(f.getName());
        if (!attrib.isCollection() && ((SingularAttribute)attrib).isId()) {
            entityMetadata.setIdAttribute((SingularAttribute)attrib);
            this.populateIdAccessorMethods(entityMetadata, clazz, f);
        }
    }

    private void onFamilyType(EntityMetadata entityMetadata, Class clazz, Field f) {
        if (entityMetadata.getType() == null || !entityMetadata.getType().equals((Object)EntityMetadata.Type.SUPER_COLUMN_FAMILY)) {
            if (f.isAnnotationPresent(Embedded.class) && f.getType().getAnnotation(Embeddable.class) != null) {
                entityMetadata.setType(EntityMetadata.Type.SUPER_COLUMN_FAMILY);
            } else if (f.isAnnotationPresent(ElementCollection.class) && !MetadataUtils.isBasicElementCollectionField(f)) {
                entityMetadata.setType(EntityMetadata.Type.SUPER_COLUMN_FAMILY);
            } else {
                entityMetadata.setType(EntityMetadata.Type.COLUMN_FAMILY);
            }
        }
    }

    private <X, T> void validateAndSetId(EntityMetadata metadata, Class<X> clazz, MetaModelBuilder<X, T> metaModelBuilder) {
        EntityType<?> entityType;
        if (metadata.getIdAttribute() == null && (entityType = metaModelBuilder.getManagedTypes().get(clazz)).getSupertype() != null) {
            SingularAttribute idAttribute = ((AbstractIdentifiableType)entityType.getSupertype()).getIdAttribute();
            metadata.setIdAttribute(idAttribute);
            this.populateIdAccessorMethods(metadata, clazz, (Field)idAttribute.getJavaMember());
        }
        this.validateIdAttribute(metadata.getIdAttribute(), clazz);
    }

    private <X, T> void validateandSetEntityType(EntityMetadata metadata, Class<X> clazz, MetaModelBuilder<X, T> metaModelBuilder) {
        if (metadata.getType() == null && clazz != null && !clazz.equals(Object.class) && clazz.isAnnotationPresent(Entity.class)) {
            EntityType<?> entityType = metaModelBuilder.getManagedTypes().get(clazz);
            if (entityType.getSupertype() != null) {
                Set attributes = ((AbstractIdentifiableType)entityType.getSupertype()).getAttributes();
                for (Attribute attribute : attributes) {
                    Field f = (Field)attribute.getJavaMember();
                    this.onFamilyType(metadata, clazz, f);
                }
            }
            this.validateandSetEntityType(metadata, clazz.getSuperclass(), metaModelBuilder);
        }
    }

    private void validateIdAttribute(SingularAttribute idAttribute, Class clazz) {
        if (idAttribute == null) {
            throw new InvalidEntityDefinitionException(clazz.getName() + " must have an @Id field.");
        }
    }
}

