/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.metadata.processor.relation;

import com.impetus.kundera.loader.MetamodelLoaderException;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.JoinTableMetadata;
import com.impetus.kundera.metadata.model.Relation;
import com.impetus.kundera.metadata.processor.AbstractEntityFieldProcessor;
import com.impetus.kundera.metadata.processor.relation.RelationMetadataProcessor;
import com.impetus.kundera.metadata.validator.EntityValidatorImpl;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import com.impetus.kundera.property.PropertyAccessorHelper;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.MapKeyClass;
import javax.persistence.MapKeyJoinColumn;

public class ManyToManyRelationMetadataProcessor
extends AbstractEntityFieldProcessor
implements RelationMetadataProcessor {
    public ManyToManyRelationMetadataProcessor(EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        super(kunderaMetadata);
        this.validator = new EntityValidatorImpl();
    }

    @Override
    public void addRelationIntoMetadata(Field relationField, EntityMetadata metadata) {
        ManyToMany m2mAnnotation = relationField.getAnnotation(ManyToMany.class);
        boolean isJoinedByTable = relationField.isAnnotationPresent(JoinTable.class);
        boolean isJoinedByMap = false;
        if (m2mAnnotation != null && relationField.getType().isAssignableFrom(Map.class)) {
            isJoinedByMap = true;
        }
        Class<?> targetEntity = null;
        Class mapKeyClass = null;
        if (!isJoinedByMap) {
            targetEntity = PropertyAccessorHelper.getGenericClass(relationField);
        } else {
            List<Class<?>> genericClasses = PropertyAccessorHelper.getGenericClasses(relationField);
            if (!genericClasses.isEmpty() && genericClasses.size() == 2) {
                mapKeyClass = genericClasses.get(0);
                targetEntity = genericClasses.get(1);
            }
            MapKeyClass mapKeyClassAnn = relationField.getAnnotation(MapKeyClass.class);
            if (mapKeyClass == null && mapKeyClassAnn != null && mapKeyClassAnn.value() != null && !mapKeyClassAnn.value().getSimpleName().equals("void")) {
                mapKeyClass = mapKeyClassAnn.value();
            }
        }
        if (targetEntity == null && null != m2mAnnotation.targetEntity() && !m2mAnnotation.targetEntity().getSimpleName().equals("void")) {
            targetEntity = m2mAnnotation.targetEntity();
        }
        Relation relation = new Relation(relationField, targetEntity, relationField.getType(), m2mAnnotation.fetch(), Arrays.asList(m2mAnnotation.cascade()), Boolean.TRUE, m2mAnnotation.mappedBy(), Relation.ForeignKey.MANY_TO_MANY);
        if (isJoinedByTable) {
            JoinTableMetadata jtMetadata = new JoinTableMetadata(relationField);
            relation.setRelatedViaJoinTable(true);
            relation.setJoinTableMetadata(jtMetadata);
        }
        if (isJoinedByMap) {
            relation.setMapKeyJoinClass(mapKeyClass);
            MapKeyJoinColumn mapKeyJoinColumnAnn = relationField.getAnnotation(MapKeyJoinColumn.class);
            if (mapKeyJoinColumnAnn != null) {
                String mapKeyJoinColumnName = mapKeyJoinColumnAnn.name();
                relation.setJoinColumnName(mapKeyJoinColumnName);
            }
        }
        relation.setBiDirectionalField(metadata.getEntityClazz());
        metadata.addRelation(relationField.getName(), relation);
        if (!metadata.isRelationViaJoinTable()) {
            metadata.setRelationViaJoinTable(relation.isRelatedViaJoinTable());
        }
    }

    @Override
    public void process(Class<?> clazz, EntityMetadata metadata) {
        throw new MetamodelLoaderException("Method call not applicable for Relation processors");
    }
}

