/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.metadata.processor.relation;

import com.impetus.kundera.loader.MetamodelLoaderException;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.Relation;
import com.impetus.kundera.metadata.processor.AbstractEntityFieldProcessor;
import com.impetus.kundera.metadata.processor.relation.RelationMetadataProcessor;
import com.impetus.kundera.metadata.validator.EntityValidatorImpl;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import java.lang.reflect.Field;
import java.util.Arrays;
import javax.persistence.AssociationOverride;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import org.apache.commons.lang.StringUtils;

public class ManyToOneRelationMetadataProcessor
extends AbstractEntityFieldProcessor
implements RelationMetadataProcessor {
    public ManyToOneRelationMetadataProcessor(EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        super(kunderaMetadata);
        this.validator = new EntityValidatorImpl();
    }

    @Override
    public void addRelationIntoMetadata(Field relationField, EntityMetadata metadata) {
        Class<?> targetEntity = relationField.getType();
        ManyToOne ann = relationField.getAnnotation(ManyToOne.class);
        Relation relation = new Relation(relationField, targetEntity, null, ann.fetch(), Arrays.asList(ann.cascade()), ann.optional(), null, Relation.ForeignKey.MANY_TO_ONE);
        boolean isJoinedByFK = relationField.isAnnotationPresent(JoinColumn.class);
        if (relationField.isAnnotationPresent(AssociationOverride.class)) {
            AssociationOverride annotation = relationField.getAnnotation(AssociationOverride.class);
            JoinColumn[] joinColumns = annotation.joinColumns();
            relation.setJoinColumnName(joinColumns[0].name());
        } else if (isJoinedByFK) {
            JoinColumn joinColumnAnn = relationField.getAnnotation(JoinColumn.class);
            relation.setJoinColumnName(StringUtils.isBlank((String)joinColumnAnn.name()) ? relationField.getName() : joinColumnAnn.name());
        } else {
            relation.setJoinColumnName(relationField.getName());
        }
        relation.setBiDirectionalField(metadata.getEntityClazz());
        metadata.addRelation(relationField.getName(), relation);
    }

    @Override
    public void process(Class<?> clazz, EntityMetadata metadata) {
        throw new MetamodelLoaderException("Method call not applicable for Relation processors");
    }
}

