/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.metadata.processor.relation;

import com.impetus.kundera.loader.MetamodelLoaderException;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.Relation;
import com.impetus.kundera.metadata.model.attributes.AbstractAttribute;
import com.impetus.kundera.metadata.processor.AbstractEntityFieldProcessor;
import com.impetus.kundera.metadata.processor.relation.RelationMetadataProcessor;
import com.impetus.kundera.metadata.validator.EntityValidatorImpl;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import com.impetus.kundera.property.PropertyAccessorHelper;
import java.lang.reflect.Field;
import java.util.Arrays;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import org.apache.commons.lang.StringUtils;

public class OneToManyRelationMetadataProcessor
extends AbstractEntityFieldProcessor
implements RelationMetadataProcessor {
    public OneToManyRelationMetadataProcessor(EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        super(kunderaMetadata);
        this.validator = new EntityValidatorImpl();
    }

    @Override
    public void process(Class<?> clazz, EntityMetadata metadata) {
        throw new MetamodelLoaderException("Method call not applicable for Relation processors");
    }

    @Override
    public void addRelationIntoMetadata(Field relationField, EntityMetadata metadata) {
        OneToMany ann = relationField.getAnnotation(OneToMany.class);
        Class targetEntity = PropertyAccessorHelper.getGenericClass(relationField);
        if (null != ann.targetEntity() && !ann.targetEntity().getSimpleName().equals("void")) {
            targetEntity = ann.targetEntity();
        }
        Relation relation = new Relation(relationField, targetEntity, relationField.getType(), ann.fetch(), Arrays.asList(ann.cascade()), Boolean.TRUE, ann.mappedBy(), Relation.ForeignKey.ONE_TO_MANY);
        boolean isJoinedByFK = relationField.isAnnotationPresent(JoinColumn.class);
        if (isJoinedByFK) {
            JoinColumn joinColumnAnn = relationField.getAnnotation(JoinColumn.class);
            relation.setJoinColumnName(StringUtils.isBlank((String)joinColumnAnn.name()) ? relationField.getName() : joinColumnAnn.name());
        } else {
            String joinColumnName = ((AbstractAttribute)metadata.getIdAttribute()).getJPAColumnName();
            if (relation.getMappedBy() != null) {
                try {
                    Field mappedField = metadata.getEntityClazz().getDeclaredField(relation.getMappedBy());
                    if (mappedField != null && mappedField.isAnnotationPresent(JoinColumn.class)) {
                        joinColumnName = mappedField.getAnnotation(JoinColumn.class).name();
                    }
                }
                catch (NoSuchFieldException e) {
                }
                catch (SecurityException e) {
                    // empty catch block
                }
            }
            relation.setJoinColumnName(joinColumnName);
        }
        relation.setBiDirectionalField(metadata.getEntityClazz());
        metadata.addRelation(relationField.getName(), relation);
        metadata.setParent(true);
    }
}

