/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.metadata.validator;

import com.impetus.kundera.client.ClientResolver;
import com.impetus.kundera.configure.schema.api.SchemaManager;
import com.impetus.kundera.metadata.KunderaMetadataManager;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.validator.EntityValidator;
import com.impetus.kundera.metadata.validator.InvalidEntityDefinitionException;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityValidatorImpl
implements EntityValidator {
    private static final Logger log = LoggerFactory.getLogger(EntityValidatorImpl.class);
    private List<Class<?>> classes = new ArrayList();
    private Map<String, Object> puProperties;

    public EntityValidatorImpl(Map puPropertyMap) {
        this.puProperties = puPropertyMap;
    }

    public EntityValidatorImpl() {
        this(null);
    }

    @Override
    public final void validate(Class<?> clazz) {
        if (this.classes.contains(clazz)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Validating " + clazz.getName());
        }
        if (!clazz.isAnnotationPresent(Entity.class)) {
            throw new InvalidEntityDefinitionException(clazz.getName() + " is not annotated with @Entity.");
        }
        try {
            clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException nsme) {
            throw new InvalidEntityDefinitionException(clazz.getName() + " must have a default no-argument constructor.");
        }
        ArrayList<Field> keys = new ArrayList<Field>();
        for (Field field : clazz.getDeclaredFields()) {
            if (field.isAnnotationPresent(Id.class) && field.isAnnotationPresent(EmbeddedId.class)) {
                throw new InvalidEntityDefinitionException(clazz.getName() + " must have either @Id field or @EmbeddedId field");
            }
            if (field.isAnnotationPresent(Id.class)) {
                keys.add(field);
                if (!field.isAnnotationPresent(GeneratedValue.class)) continue;
                this.validateGeneratedValueAnnotation(clazz, field);
                continue;
            }
            if (!field.isAnnotationPresent(EmbeddedId.class)) continue;
            keys.add(field);
        }
        if (keys.size() < 0) {
            throw new InvalidEntityDefinitionException(clazz.getName() + " must have an @Id field.");
        }
        if (keys.size() > 1) {
            throw new InvalidEntityDefinitionException(clazz.getName() + " can only have 1 @Id field.");
        }
        this.classes.add(clazz);
    }

    private void validateGeneratedValueAnnotation(Class<?> clazz, Field field) {
        String schemaName;
        Table table = clazz.getAnnotation(Table.class);
        if (table != null && (schemaName = table.schema()) != null && schemaName.indexOf(64) > 0) {
            schemaName = schemaName.substring(0, schemaName.indexOf(64));
            GeneratedValue generatedValue = field.getAnnotation(GeneratedValue.class);
            if (generatedValue != null && generatedValue.generator() != null && !generatedValue.generator().isEmpty()) {
                if (!(field.isAnnotationPresent(TableGenerator.class) || field.isAnnotationPresent(SequenceGenerator.class) || clazz.isAnnotationPresent(TableGenerator.class) || clazz.isAnnotationPresent(SequenceGenerator.class))) {
                    log.error("Unknown Id.generator{}: for class{}", (Object)generatedValue.generator(), clazz);
                    throw new IllegalArgumentException("Unknown Id.generator: " + generatedValue.generator());
                }
                this.checkForGenerator(clazz, field, generatedValue, schemaName);
            }
        }
    }

    private void checkForGenerator(Class<?> clazz, Field field, GeneratedValue generatedValue, String schemaName) {
        TableGenerator tableGenerator = field.getAnnotation(TableGenerator.class);
        SequenceGenerator sequenceGenerator = field.getAnnotation(SequenceGenerator.class);
        if (tableGenerator == null || !tableGenerator.name().equals(generatedValue.generator())) {
            tableGenerator = clazz.getAnnotation(TableGenerator.class);
        }
        if (sequenceGenerator == null || !sequenceGenerator.name().equals(generatedValue.generator())) {
            sequenceGenerator = clazz.getAnnotation(SequenceGenerator.class);
        }
        if (tableGenerator == null && sequenceGenerator == null || tableGenerator != null && !tableGenerator.name().equals(generatedValue.generator()) || sequenceGenerator != null && !sequenceGenerator.name().equals(generatedValue.generator())) {
            throw new IllegalArgumentException("Unknown Id.generator: " + generatedValue.generator());
        }
        if (tableGenerator != null && !tableGenerator.schema().isEmpty() && !tableGenerator.schema().equals(schemaName) || sequenceGenerator != null && !sequenceGenerator.schema().isEmpty() && !sequenceGenerator.schema().equals(schemaName)) {
            throw new InvalidEntityDefinitionException("Generator " + generatedValue.generator() + " in entity : " + clazz.getName() + " has different schema name ,it should be same as entity have");
        }
    }

    @Override
    public void validateEntity(Class<?> clazz, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        SchemaManager schemaManager;
        EntityMetadata metadata = KunderaMetadataManager.getEntityMetadata(kunderaMetadata, clazz);
        if (metadata != null && (schemaManager = ClientResolver.getClientFactory(metadata.getPersistenceUnit()).getSchemaManager(this.puProperties)) != null && !schemaManager.validateEntity(clazz)) {
            log.warn("Validation for : " + clazz + " failed , any operation on this class will result in fail.");
        }
    }
}

