/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.persistence;

import com.impetus.kundera.client.Client;
import com.impetus.kundera.client.EnhanceEntity;
import com.impetus.kundera.index.IndexManager;
import com.impetus.kundera.metadata.KunderaMetadataManager;
import com.impetus.kundera.metadata.MetadataUtils;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.JoinTableMetadata;
import com.impetus.kundera.metadata.model.Relation;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import com.impetus.kundera.persistence.EntityReaderException;
import com.impetus.kundera.persistence.PersistenceDelegator;
import com.impetus.kundera.persistence.context.PersistenceCacheManager;
import com.impetus.kundera.property.PropertyAccessException;
import com.impetus.kundera.property.PropertyAccessorHelper;
import com.impetus.kundera.proxy.KunderaProxy;
import com.impetus.kundera.proxy.ProxyHelper;
import com.impetus.kundera.proxy.collection.AbstractProxyBase;
import com.impetus.kundera.proxy.collection.ProxyList;
import com.impetus.kundera.proxy.collection.ProxyMap;
import com.impetus.kundera.proxy.collection.ProxySet;
import com.impetus.kundera.utils.ObjectUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AssociationBuilder {
    private static Logger log = LoggerFactory.getLogger(AssociationBuilder.class);

    List getAssociatedEntitiesFromIndex(Class owningClazz, Object entityId, Class<?> childClass, Client childClient) {
        IndexManager indexManager = childClient.getIndexManager();
        HashMap results = indexManager != null ? indexManager.search(owningClazz, childClass, entityId) : new HashMap();
        HashSet rsSet = results != null ? new HashSet(results.values()) : new HashSet();
        List<?> associatedEntities = childClass.equals(owningClazz) ? childClient.findAll(childClass, null, rsSet.toArray(new Object[0])) : childClient.findAll(childClass, null, rsSet.toArray(new Object[0]));
        return associatedEntities;
    }

    void populateRelationForM2M(Object entity, EntityMetadata entityMetadata, PersistenceDelegator delegator, Relation relation, Object relObject, Map<String, Object> relationsMap) {
        if (relation.getPropertyType().isAssignableFrom(List.class) || relation.getPropertyType().isAssignableFrom(Set.class)) {
            if (relation.isRelatedViaJoinTable() && (relObject == null || ProxyHelper.isProxyOrCollection(relObject))) {
                this.populateCollectionFromJoinTable(entity, entityMetadata, delegator, relation);
            }
        } else if (relation.getPropertyType().isAssignableFrom(Map.class) && !relation.isRelatedViaJoinTable()) {
            this.populateCollectionFromMap(entity, delegator, relation, relObject, relationsMap);
        }
    }

    private void populateCollectionFromJoinTable(Object entity, EntityMetadata entityMetadata, PersistenceDelegator delegator, Relation relation) {
        JoinTableMetadata jtMetadata = relation.getJoinTableMetadata();
        Client pClient = delegator.getClient(entityMetadata);
        String schema = entityMetadata.getSchema();
        EntityMetadata owningEntityMetadata = KunderaMetadataManager.getEntityMetadata(delegator.getKunderaMetadata(), relation.getTargetEntity());
        Class columnJavaType = owningEntityMetadata.getIdAttribute().getJavaType();
        if (jtMetadata == null) {
            columnJavaType = entityMetadata.getIdAttribute().getJavaType();
            Relation owningEntityMetadataRelation = owningEntityMetadata.getRelation(relation.getMappedBy());
            jtMetadata = owningEntityMetadataRelation.getJoinTableMetadata();
            pClient = delegator.getClient(owningEntityMetadata);
            schema = owningEntityMetadata.getSchema();
        }
        String joinTableName = jtMetadata.getJoinTableName();
        Set<String> joinColumns = jtMetadata.getJoinColumns();
        Set<String> inverseJoinColumns = jtMetadata.getInverseJoinColumns();
        String joinColumnName = (String)joinColumns.toArray()[0];
        String inverseJoinColumnName = (String)inverseJoinColumns.toArray()[0];
        Object entityId = PropertyAccessorHelper.getId(entity, entityMetadata);
        List foreignKeys = pClient.getColumnsById(schema, joinTableName, joinColumnName, inverseJoinColumnName, entityId, columnJavaType);
        ArrayList childrenEntities = new ArrayList();
        if (foreignKeys != null) {
            for (Object foreignKey : foreignKeys) {
                boolean isBidirectionalRelation;
                EntityMetadata childMetadata = KunderaMetadataManager.getEntityMetadata(delegator.getKunderaMetadata(), relation.getTargetEntity());
                Object child = delegator.find(relation.getTargetEntity(), foreignKey);
                Object obj = child instanceof EnhanceEntity && child != null ? ((EnhanceEntity)child).getEntity() : child;
                Field biDirectionalField = relation.getBiDirectionalField();
                boolean bl = isBidirectionalRelation = biDirectionalField != null;
                if (isBidirectionalRelation && obj != null) {
                    Object columnValue = PropertyAccessorHelper.getId(obj, childMetadata);
                    Object[] pKeys = pClient.findIdsByColumn(entityMetadata.getSchema(), joinTableName, joinColumnName, inverseJoinColumnName, columnValue, entityMetadata.getEntityClazz());
                    List<?> parents = delegator.find(entity.getClass(), pKeys);
                    PropertyAccessorHelper.set(obj, biDirectionalField, ObjectUtils.getFieldInstance(parents, biDirectionalField));
                    PersistenceCacheManager.addEntityToPersistenceCache(obj, delegator, columnValue);
                }
                childrenEntities.add(obj);
            }
        }
        Field childField = relation.getProperty();
        try {
            PropertyAccessorHelper.set(entity, childField, PropertyAccessorHelper.isCollection(childField.getType()) ? ObjectUtils.getFieldInstance(childrenEntities, childField) : childrenEntities.get(0));
            PersistenceCacheManager.addEntityToPersistenceCache(entity, delegator, entityId);
        }
        catch (PropertyAccessException ex) {
            throw new EntityReaderException(ex);
        }
    }

    private void populateCollectionFromMap(Object entity, PersistenceDelegator delegator, Relation relation, Object relObject, Map<String, Object> relationsMap) {
        EntityMetadata childMetadata = KunderaMetadataManager.getEntityMetadata(delegator.getKunderaMetadata(), relation.getTargetEntity());
        HashMap relationshipEntityMap = new HashMap();
        if ((relObject == null || ProxyHelper.isProxyCollection(relObject)) && relationsMap != null && !relationsMap.isEmpty()) {
            for (String relationName : relationsMap.keySet()) {
                Object relationValue = relationsMap.get(relationName);
                if (!(relationValue instanceof Map)) continue;
                Map relationValueMap = (Map)relationValue;
                Client targetEntityClient = delegator.getClient(childMetadata);
                for (Object targetEntityKey : relationValueMap.keySet()) {
                    Object targetEntity = targetEntityClient.find(childMetadata.getEntityClazz(), targetEntityKey);
                    if (targetEntity != null && targetEntity instanceof EnhanceEntity) {
                        targetEntity = ((EnhanceEntity)targetEntity).getEntity();
                    }
                    Object mapKeyEntity = relationValueMap.get(targetEntityKey);
                    Class<?> relationshipClass = relation.getMapKeyJoinClass();
                    for (Field f : relationshipClass.getDeclaredFields()) {
                        if (f.getType().equals(entity.getClass())) {
                            PropertyAccessorHelper.set(mapKeyEntity, f, entity);
                            continue;
                        }
                        if (!f.getType().equals(childMetadata.getEntityClazz())) continue;
                        PropertyAccessorHelper.set(mapKeyEntity, f, targetEntity);
                    }
                    relationshipEntityMap.put(mapKeyEntity, targetEntity);
                }
            }
            relObject = relationshipEntityMap;
        }
        PropertyAccessorHelper.set(entity, relation.getProperty(), relObject);
        if (relObject != null && !ProxyHelper.isProxyCollection(relObject)) {
            for (String child : ((Map)relObject).values()) {
                if (child == null) continue;
                Object childId = PropertyAccessorHelper.getId(child, childMetadata);
                PersistenceCacheManager.addEntityToPersistenceCache(child, delegator, childId);
            }
        }
    }

    public void setProxyRelationObject(Object entity, Map<String, Object> relationsMap, EntityMetadata m, PersistenceDelegator pd, Object entityId, Relation relation) {
        Object relationValue;
        EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata = pd.getKunderaMetadata();
        String relationName = MetadataUtils.getMappedName(m, relation, kunderaMetadata);
        Object object = relationValue = relationsMap != null ? relationsMap.get(relationName) : null;
        if (relation.getType().equals((Object)Relation.ForeignKey.ONE_TO_ONE) || relation.getType().equals((Object)Relation.ForeignKey.MANY_TO_ONE)) {
            boolean isBidirectionalRelation;
            Field biDirectionalField = relation.getBiDirectionalField();
            boolean bl = isBidirectionalRelation = biDirectionalField != null;
            if (isBidirectionalRelation && relationValue == null && !relation.isJoinedByPrimaryKey()) {
                EntityMetadata parentEntityMetadata = KunderaMetadataManager.getEntityMetadata(kunderaMetadata, relation.getTargetEntity());
                Object owner = null;
                String entityName = m.getEntityClazz().getName() + "_" + entityId + "#" + relation.getProperty().getName();
                KunderaProxy kp = kunderaMetadata.getCoreMetadata().getLazyInitializerFactory().getProxy(entityName);
                if (kp != null) {
                    owner = kp.getKunderaLazyInitializer().getOwner();
                    if (owner != null && owner.getClass().equals(parentEntityMetadata.getEntityClazz())) {
                        relationValue = PropertyAccessorHelper.getId(owner, parentEntityMetadata);
                    }
                    if (relationValue != null) {
                        if (log.isDebugEnabled()) {
                            log.debug("Creating proxy for >> " + parentEntityMetadata.getEntityClazz().getName() + "#" + relation.getProperty().getName() + "_" + relationValue);
                        }
                        KunderaProxy proxy = this.getLazyEntity(entityName, relation.getTargetEntity(), parentEntityMetadata.getReadIdentifierMethod(), parentEntityMetadata.getWriteIdentifierMethod(), relationValue, pd);
                        PropertyAccessorHelper.set(entity, relation.getProperty(), proxy);
                    }
                }
            } else if (relationValue != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Creating proxy for >> " + m.getEntityClazz().getName() + "#" + relation.getProperty().getName() + "_" + relationValue);
                }
                String entityName = m.getEntityClazz().getName() + "_" + entityId + "#" + relation.getProperty().getName();
                KunderaProxy proxy = this.getLazyEntity(entityName, relation.getTargetEntity(), m.getReadIdentifierMethod(), m.getWriteIdentifierMethod(), relationValue, pd);
                PropertyAccessorHelper.set(entity, relation.getProperty(), proxy);
            } else if (relation.isJoinedByPrimaryKey()) {
                if (log.isDebugEnabled()) {
                    log.debug("Creating proxy for >> " + m.getEntityClazz().getName() + "#" + relation.getProperty().getName() + "_" + relationValue);
                }
                String entityName = m.getEntityClazz().getName() + "_" + entityId + "#" + relation.getProperty().getName();
                KunderaProxy proxy = this.getLazyEntity(entityName, relation.getTargetEntity(), m.getReadIdentifierMethod(), m.getWriteIdentifierMethod(), entityId, pd);
                PropertyAccessorHelper.set(entity, relation.getProperty(), proxy);
            }
        } else if (relation.getType().equals((Object)Relation.ForeignKey.ONE_TO_MANY) || relation.getType().equals((Object)Relation.ForeignKey.MANY_TO_MANY)) {
            AbstractProxyBase proxyCollection = null;
            if (relation.getPropertyType().isAssignableFrom(Set.class)) {
                proxyCollection = new ProxySet(pd, relation);
            } else if (relation.getPropertyType().isAssignableFrom(List.class)) {
                proxyCollection = new ProxyList(pd, relation);
            } else if (relation.getPropertyType().isAssignableFrom(Map.class)) {
                proxyCollection = new ProxyMap(pd, relation);
            }
            proxyCollection.setOwner(entity);
            proxyCollection.setRelationsMap(relationsMap);
            PropertyAccessorHelper.set(entity, relation.getProperty(), proxyCollection);
        }
    }

    private KunderaProxy getLazyEntity(String entityName, Class<?> persistentClass, Method getIdentifierMethod, Method setIdentifierMethod, Object id, PersistenceDelegator pd) {
        return pd.getKunderaMetadata().getCoreMetadata().getLazyInitializerFactory().getProxy(entityName, persistentClass, getIdentifierMethod, setIdentifierMethod, id, pd);
    }
}

