/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.persistence;

import com.impetus.kundera.metadata.model.attributes.DefaultSingularAttribute;
import com.impetus.kundera.metadata.model.type.DefaultEmbeddableType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;

public class DefaultPath<X>
implements Path<X> {
    private PathType pathType;
    protected ManagedType<X> managedType;
    private Attribute<X, ?> attribute;
    private Attribute embeddedAttribute;
    protected EntityType<X> entityType;
    private String alias;
    private PathCache cache = new PathCache();

    DefaultPath() {
    }

    private DefaultPath(PathType pathType, ManagedType<X> managedType, Attribute<X, ?> attribute, EntityType<X> entityType, Attribute embeddedAttribute) {
        this.pathType = pathType;
        this.managedType = managedType;
        this.attribute = attribute;
        this.entityType = entityType;
        if (embeddedAttribute != null && embeddedAttribute.getPersistentAttributeType().equals((Object)Attribute.PersistentAttributeType.EMBEDDED)) {
            this.embeddedAttribute = embeddedAttribute;
        }
    }

    public <Y> Path<Y> get(SingularAttribute<? super X, Y> paramSingularAttribute) {
        return this.cache.get((Attribute)paramSingularAttribute, this.entityType, (Attribute)this.attribute);
    }

    public <E, C extends Collection<E>> Expression<C> get(PluralAttribute<X, C, E> paramPluralAttribute) {
        throw new UnsupportedOperationException("Support for plural attribute is not yet available");
    }

    public <K, V, M extends Map<K, V>> Expression<M> get(MapAttribute<X, K, V> paramMapAttribute) {
        throw new UnsupportedOperationException("Support for map attribute is not yet available");
    }

    public Expression<Class<? extends X>> type() {
        return null;
    }

    public <Y> Path<Y> get(String paramString) {
        Attribute attribute = null;
        if (this.attribute != null && this.attribute.getPersistentAttributeType().equals((Object)Attribute.PersistentAttributeType.EMBEDDED)) {
            try {
                DefaultEmbeddableType embeddableType = (DefaultEmbeddableType)((DefaultSingularAttribute)this.attribute).getType();
                attribute = embeddableType.getAttribute(paramString);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        attribute = attribute == null ? this.managedType.getAttribute(paramString) : attribute;
        return this.cache.get(attribute, this.entityType, this.attribute);
    }

    public Predicate isNull() {
        throw new UnsupportedOperationException("Method isNull() not yet supported");
    }

    public Predicate isNotNull() {
        throw new UnsupportedOperationException("Method isNotNull() not yet supported");
    }

    public Predicate in(Object ... paramArrayOfObject) {
        throw new UnsupportedOperationException("Method in(Object... paramArrayOfObject) not yet supported");
    }

    public Predicate in(Expression<?> ... paramArrayOfExpression) {
        throw new UnsupportedOperationException("Method in(Expression<?>... paramArrayOfExpression) not yet supported");
    }

    public Predicate in(Collection<?> paramCollection) {
        throw new UnsupportedOperationException("Method in(Collection<?> paramCollection) not yet supported");
    }

    public Predicate in(Expression<Collection<?>> paramExpression) {
        throw new UnsupportedOperationException("Method in(Expression<Collection<?>> paramExpression) not yet supported");
    }

    public <X> Expression<X> as(Class<X> paramClass) {
        return null;
    }

    public Selection<X> alias(String alias) {
        this.alias = alias;
        return this;
    }

    public boolean isCompoundSelection() {
        return false;
    }

    public List<Selection<?>> getCompoundSelectionItems() {
        return null;
    }

    public Class<? extends X> getJavaType() {
        return this.managedType.getJavaType();
    }

    public String getAlias() {
        return this.alias;
    }

    public EntityType<X> getEntityType() {
        return this.entityType;
    }

    Attribute getAttribute() {
        return this.attribute;
    }

    ManagedType<X> getManagedType() {
        return this.managedType;
    }

    Attribute getEmbeddedAttribute() {
        return this.embeddedAttribute;
    }

    private <Y> Path<Y> getPath(Attribute attribute, EntityType<Y> entityType, Attribute embeddedAttribute) {
        DefaultPath<Y> path = null;
        path = attribute.isCollection() ? new DefaultPath<Y>(PathType.PLURAL, attribute.getDeclaringType(), attribute, entityType, embeddedAttribute) : new DefaultPath<Y>(PathType.SINGULAR, attribute.getDeclaringType(), attribute, entityType, embeddedAttribute);
        return path;
    }

    public Bindable<X> getModel() {
        return (Bindable)this.attribute;
    }

    public Path<?> getParentPath() {
        return null;
    }

    class PathCache {
        private Map<String, Path> cacheAttributes = new ConcurrentHashMap<String, Path>();

        PathCache() {
        }

        synchronized Path get(Attribute attribute, EntityType<X> entityType, Attribute embeddedAttribute) {
            if (!this.cacheAttributes.containsKey(attribute.getName())) {
                this.cacheAttributes.put(attribute.getName(), DefaultPath.this.getPath(attribute, entityType, embeddedAttribute));
            }
            return this.cacheAttributes.get(attribute.getName());
        }
    }

    static enum PathType {
        SINGULAR,
        PLURAL;

    }
}

