/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.persistence;

import com.impetus.kundera.KunderaException;
import com.impetus.kundera.cache.Cache;
import com.impetus.kundera.client.Client;
import com.impetus.kundera.client.ClientResolverException;
import com.impetus.kundera.loader.ClientFactory;
import com.impetus.kundera.persistence.CriteriaQueryTranslator;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import com.impetus.kundera.persistence.KunderaEntityTransaction;
import com.impetus.kundera.persistence.PersistenceDelegator;
import com.impetus.kundera.persistence.ResourceManager;
import com.impetus.kundera.persistence.context.PersistenceCache;
import com.impetus.kundera.persistence.jta.KunderaJTAUserTransaction;
import com.impetus.kundera.query.KunderaTypedQuery;
import com.impetus.kundera.query.QueryImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceContextType;
import javax.persistence.Query;
import javax.persistence.StoredProcedureQuery;
import javax.persistence.TransactionRequiredException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.transaction.UserTransaction;
import org.apache.commons.lang.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityManagerImpl
implements EntityManager,
ResourceManager {
    private static Logger logger = LoggerFactory.getLogger(EntityManagerImpl.class);
    private final EntityManagerFactory factory;
    private boolean closed;
    private FlushModeType flushMode = FlushModeType.AUTO;
    private Map<String, Object> properties;
    private final PersistenceDelegator persistenceDelegator;
    private final PersistenceContextType persistenceContextType;
    private final PersistenceUnitTransactionType transactionType;
    private final PersistenceCache persistenceCache;
    private UserTransaction utx;
    private EntityTransaction entityTransaction;

    EntityManagerImpl(EntityManagerFactory factory, Map properties, PersistenceUnitTransactionType transactionType, PersistenceContextType persistenceContextType) {
        this(factory, transactionType, persistenceContextType);
        this.properties = properties;
        this.getPersistenceDelegator().populateClientProperties(this.properties);
    }

    EntityManagerImpl(EntityManagerFactory factory, PersistenceUnitTransactionType transactionType, PersistenceContextType persistenceContextType) {
        this.factory = factory;
        if (logger.isDebugEnabled()) {
            logger.debug("Creating EntityManager for persistence unit : " + this.getPersistenceUnit());
        }
        this.persistenceContextType = persistenceContextType;
        this.persistenceCache = new PersistenceCache((Cache)factory.getCache());
        this.persistenceCache.setPersistenceContextType(this.persistenceContextType);
        this.transactionType = transactionType;
        this.persistenceDelegator = new PersistenceDelegator(((EntityManagerFactoryImpl)this.factory).getKunderaMetadataInstance(), this.persistenceCache);
        for (String pu : ((EntityManagerFactoryImpl)this.factory).getPersistenceUnits()) {
            this.persistenceDelegator.loadClient(pu, this.discoverClient(pu));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Created EntityManager for persistence unit : " + this.getPersistenceUnit());
        }
    }

    public final void persist(Object e) {
        this.checkClosed();
        this.checkTransactionNeeded();
        try {
            this.getPersistenceDelegator().persist(e);
        }
        catch (Exception ex) {
            this.doRollback();
            throw new KunderaException(ex);
        }
    }

    public final <E> E merge(E e) {
        this.checkClosed();
        this.checkTransactionNeeded();
        try {
            return this.getPersistenceDelegator().merge(e);
        }
        catch (Exception ex) {
            this.doRollback();
            throw new KunderaException(ex);
        }
    }

    public final void remove(Object e) {
        this.checkClosed();
        this.checkTransactionNeeded();
        try {
            this.getPersistenceDelegator().remove(e);
        }
        catch (Exception ex) {
            this.doRollback();
            throw new KunderaException(ex);
        }
    }

    public final <E> E find(Class<E> entityClass, Object primaryKey) {
        this.checkClosed();
        this.checkTransactionNeeded();
        return this.getPersistenceDelegator().findById(entityClass, primaryKey);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        this.checkClosed();
        this.checkTransactionNeeded();
        Map<String, Object> currentProperties = this.getProperties();
        this.getPersistenceDelegator().populateClientProperties(properties);
        T result = this.find(entityClass, primaryKey);
        this.getPersistenceDelegator().populateClientProperties(currentProperties);
        return result;
    }

    public <T> T find(Class<T> paramClass, Object paramObject, LockModeType paramLockModeType) {
        this.checkClosed();
        throw new NotImplementedException("Lock mode type currently not supported by Kundera");
    }

    public <T> T find(Class<T> arg0, Object arg1, LockModeType arg2, Map<String, Object> arg3) {
        this.checkClosed();
        throw new NotImplementedException("Lock mode type currently not supported by Kundera");
    }

    public final void clear() {
        this.checkClosed();
        if (!PersistenceUnitTransactionType.JTA.equals((Object)this.transactionType)) {
            this.getPersistenceDelegator().clear();
        }
    }

    public final void close() {
        this.clear();
        this.getPersistenceDelegator().close();
        this.closed = true;
    }

    public final boolean contains(Object entity) {
        this.checkClosed();
        return this.getPersistenceDelegator().contains(entity);
    }

    public final Query createQuery(String query) {
        this.checkClosed();
        this.checkTransactionNeeded();
        return this.getPersistenceDelegator().createQuery(query);
    }

    public final void flush() {
        this.checkClosed();
        this.getPersistenceDelegator().doFlush();
    }

    public final Object getDelegate() {
        this.checkClosed();
        return this.getPersistenceDelegator().getDelegate();
    }

    public final Query createNamedQuery(String name) {
        this.checkClosed();
        this.checkTransactionNeeded();
        return this.getPersistenceDelegator().createQuery(name);
    }

    public final Query createNativeQuery(String sqlString) {
        this.checkClosed();
        return this.getPersistenceDelegator().createQuery(sqlString, this.getPersistenceUnit());
    }

    public final Query createNativeQuery(String sqlString, Class resultClass) {
        this.checkClosed();
        this.checkTransactionNeeded();
        return this.getPersistenceDelegator().createNativeQuery(sqlString, resultClass);
    }

    public final Query createNativeQuery(String sqlString, String resultSetMapping) {
        this.checkClosed();
        throw new NotImplementedException("ResultSetMapping currently not supported by Kundera. Please use createNativeQuery(String sqlString, Class resultClass) instead.");
    }

    public final <T> T getReference(Class<T> entityClass, Object primaryKey) {
        this.checkClosed();
        throw new NotImplementedException("getReference currently not supported by Kundera");
    }

    public final FlushModeType getFlushMode() {
        this.checkClosed();
        return this.flushMode;
    }

    public final EntityTransaction getTransaction() {
        this.checkClosed();
        if (this.transactionType == PersistenceUnitTransactionType.JTA) {
            throw new IllegalStateException("A JTA EntityManager cannot use getTransaction()");
        }
        if (this.entityTransaction == null) {
            this.entityTransaction = new KunderaEntityTransaction(this);
        }
        return this.entityTransaction;
    }

    public final void joinTransaction() {
        this.checkClosed();
        if (this.utx != null) {
            return;
        }
        throw new TransactionRequiredException("No transaction in progress");
    }

    public final void lock(Object entity, LockModeType lockMode) {
        this.checkClosed();
        throw new NotImplementedException("lock currently not supported by Kundera");
    }

    public final void refresh(Object entity) {
        this.checkClosed();
        this.checkTransactionNeeded();
        this.getPersistenceDelegator().refresh(entity);
    }

    public void refresh(Object entity, Map<String, Object> properties) {
        this.checkClosed();
        Map<String, Object> currentProperties = this.getProperties();
        this.getPersistenceDelegator().populateClientProperties(properties);
        this.refresh(entity);
        this.getPersistenceDelegator().populateClientProperties(currentProperties);
    }

    public void lock(Object paramObject, LockModeType paramLockModeType, Map<String, Object> paramMap) {
        this.checkClosed();
        throw new NotImplementedException("Lock currently not supported by Kundera.");
    }

    public void refresh(Object paramObject, LockModeType paramLockModeType) {
        this.checkClosed();
        throw new NotImplementedException("Lock mode type currently not supported by Kundera.");
    }

    public void refresh(Object paramObject, LockModeType paramLockModeType, Map<String, Object> paramMap) {
        this.checkClosed();
        throw new NotImplementedException("LockModeType currently not supported by Kundera.");
    }

    public void detach(Object entity) {
        this.checkClosed();
        if (entity == null) {
            throw new IllegalArgumentException("Entity is null, can't detach it.");
        }
        this.getPersistenceDelegator().detach(entity);
    }

    public LockModeType getLockMode(Object paramObject) {
        this.checkClosed();
        throw new NotImplementedException("Lock mode type currently not supported by Kundera.");
    }

    public void setProperty(String paramString, Object paramObject) {
        this.checkClosed();
        if (this.getProperties() == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put(paramString, paramObject);
        this.getPersistenceDelegator().populateClientProperties(this.properties);
    }

    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> paramCriteriaQuery) {
        this.checkClosed();
        return this.createQuery(CriteriaQueryTranslator.translate(paramCriteriaQuery), paramCriteriaQuery.getResultType());
    }

    public <T> TypedQuery<T> createQuery(String paramString, Class<T> paramClass) {
        Query q = this.createQuery(paramString);
        return this.onTypedQuery(paramClass, q);
    }

    public <T> TypedQuery<T> createNamedQuery(String paramString, Class<T> paramClass) {
        Query q = this.createNamedQuery(paramString);
        return this.onTypedQuery(paramClass, q);
    }

    public <T> T unwrap(Class<T> paramClass) {
        this.checkClosed();
        throw new NotImplementedException("Unwrap currently not supported by Kundera");
    }

    public final void setFlushMode(FlushModeType flushMode) {
        this.checkClosed();
        this.flushMode = flushMode;
        this.getPersistenceDelegator().setFlushMode(flushMode);
    }

    public Map<String, Object> getProperties() {
        this.checkClosed();
        return this.properties;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        this.checkClosed();
        return this.factory;
    }

    public CriteriaBuilder getCriteriaBuilder() {
        this.checkClosed();
        return this.getEntityManagerFactory().getCriteriaBuilder();
    }

    public Metamodel getMetamodel() {
        this.checkClosed();
        return this.getEntityManagerFactory().getMetamodel();
    }

    public final boolean isOpen() {
        return !this.closed;
    }

    private void checkClosed() {
        if (!this.isOpen()) {
            throw new IllegalStateException("EntityManager has already been closed.");
        }
    }

    private void checkTransactionNeeded() {
        this.onLookUp(this.transactionType);
        if (this.getPersistenceContextType() != PersistenceContextType.TRANSACTION || this.getPersistenceDelegator().isTransactionInProgress()) {
            return;
        }
        throw new TransactionRequiredException("no transaction is in progress for a TRANSACTION type persistence context");
    }

    private void onLookUp(PersistenceUnitTransactionType transactionType) {
        if (transactionType != null && transactionType.equals((Object)PersistenceUnitTransactionType.JTA)) {
            if (this.entityTransaction == null) {
                this.entityTransaction = new KunderaEntityTransaction(this);
            }
            try {
                InitialContext ctx = new InitialContext();
                this.utx = (UserTransaction)ctx.lookup("java:comp/UserTransaction");
                if (this.utx == null) {
                    throw new KunderaException("Lookup for UserTransaction returning null for :{java:comp/UserTransaction}");
                }
                if (!(this.utx instanceof KunderaJTAUserTransaction)) {
                    throw new KunderaException("Please bind [" + KunderaJTAUserTransaction.class.getName() + "] for :{java:comp/UserTransaction} lookup" + this.utx.getClass());
                }
                if (!this.entityTransaction.isActive()) {
                    this.entityTransaction.begin();
                    this.setFlushMode(FlushModeType.COMMIT);
                    ((KunderaJTAUserTransaction)this.utx).setImplementor(this);
                }
            }
            catch (NamingException e) {
                logger.error("Error during initialization of entity manager, Caused by:", (Throwable)e);
                throw new KunderaException(e);
            }
        }
    }

    private String getPersistenceUnit() {
        return (String)this.getEntityManagerFactory().getProperties().get("persistenceUnitName");
    }

    PersistenceDelegator getPersistenceDelegator() {
        this.checkClosed();
        return this.persistenceDelegator;
    }

    private PersistenceContextType getPersistenceContextType() {
        return this.persistenceContextType;
    }

    @Override
    public void doCommit() {
        this.checkClosed();
        this.entityTransaction.commit();
    }

    @Override
    public void doRollback() {
        this.checkClosed();
        if (this.entityTransaction != null) {
            this.entityTransaction.rollback();
        } else {
            this.getPersistenceDelegator().rollback();
        }
    }

    private <T> TypedQuery<T> onTypedQuery(Class<T> paramClass, Query q) {
        if (paramClass.equals(((QueryImpl)q).getKunderaQuery().getEntityClass()) || paramClass.equals(Object.class)) {
            return new KunderaTypedQuery(q);
        }
        throw new IllegalArgumentException("Mismatch in expected return type. Expected:" + paramClass + " But actual class is:" + ((QueryImpl)q).getKunderaQuery().getEntityClass());
    }

    private Client discoverClient(String persistenceUnit) {
        ClientFactory clientFactory;
        if (logger.isInfoEnabled()) {
            logger.info("Returning client instance for persistence unit {}.", (Object)persistenceUnit);
        }
        if ((clientFactory = ((EntityManagerFactoryImpl)this.getEntityManagerFactory()).getClientFactory(persistenceUnit)) != null) {
            return clientFactory.getClientInstance();
        }
        throw new ClientResolverException("No client configured for persistence unit " + persistenceUnit + ".");
    }

    public <T> EntityGraph<T> createEntityGraph(Class<T> arg0) {
        return null;
    }

    public EntityGraph<?> createEntityGraph(String arg0) {
        return null;
    }

    public StoredProcedureQuery createNamedStoredProcedureQuery(String arg0) {
        return null;
    }

    public Query createQuery(CriteriaUpdate arg0) {
        return null;
    }

    public Query createQuery(CriteriaDelete arg0) {
        return null;
    }

    public StoredProcedureQuery createStoredProcedureQuery(String arg0) {
        return null;
    }

    public StoredProcedureQuery createStoredProcedureQuery(String arg0, Class ... arg1) {
        return null;
    }

    public StoredProcedureQuery createStoredProcedureQuery(String arg0, String ... arg1) {
        return null;
    }

    public EntityGraph<?> getEntityGraph(String arg0) {
        return null;
    }

    public <T> List<EntityGraph<? super T>> getEntityGraphs(Class<T> arg0) {
        return null;
    }

    public boolean isJoinedToTransaction() {
        return false;
    }
}

