/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.persistence;

import com.impetus.kundera.cache.Cache;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityManagerSession {
    private static final Logger LOG = LoggerFactory.getLogger(EntityManagerSession.class);
    private Map<Object, Object> sessionCache = new ConcurrentHashMap<Object, Object>();
    private Cache l2Cache;

    public EntityManagerSession(Cache cache) {
        this.setL2Cache(cache);
    }

    protected <T> T lookup(Class<T> entityClass, Object id) {
        String key = this.cacheKey(entityClass, id);
        LOG.debug("Reading from L1 >> " + key);
        Object o = this.sessionCache.get(key);
        if (o == null) {
            LOG.debug("Reading from L2 >> " + key);
            Cache c = this.getL2Cache();
            if (c != null && (o = c.get(key)) != null) {
                LOG.debug("Found item in second level cache!");
            }
        }
        return (T)o;
    }

    protected void store(Object id, Object entity) {
        this.store(id, entity, Boolean.TRUE);
    }

    protected void store(Object id, Object entity, boolean spillOverToL2) {
        String key = this.cacheKey(entity.getClass(), id);
        LOG.debug("Writing to L1 >> " + key);
        this.sessionCache.put(key, entity);
        if (spillOverToL2) {
            LOG.debug("Writing to L2 >>" + key);
            Cache c = this.getL2Cache();
            if (c != null) {
                c.put(key, entity);
            }
        }
    }

    protected <T> void remove(Class<T> entityClass, Object id) {
        this.remove(entityClass, id, Boolean.TRUE);
    }

    protected <T> void remove(Class<T> entityClass, Object id, boolean spillOverToL2) {
        String key = this.cacheKey(entityClass, id);
        LOG.debug("Removing from L1 >> " + key);
        Object o = this.sessionCache.remove(key);
        if (spillOverToL2) {
            LOG.debug("Removing from L2 >> " + key);
            Cache c = this.getL2Cache();
            if (c != null) {
                c.evict(entityClass, key);
            }
        }
    }

    private String cacheKey(Class<?> clazz, Object id) {
        return clazz.getName() + "_" + id;
    }

    public final void clear() {
        this.sessionCache = new ConcurrentHashMap<Object, Object>();
        if (this.getL2Cache() != null) {
            this.getL2Cache().evictAll();
        }
    }

    public Cache getL2Cache() {
        return this.l2Cache;
    }

    public void setL2Cache(Cache l2Cache) {
        this.l2Cache = l2Cache;
    }
}

