/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.persistence;

import com.impetus.kundera.KunderaException;
import com.impetus.kundera.client.Client;
import com.impetus.kundera.client.ClientBase;
import com.impetus.kundera.generator.AutoGenerator;
import com.impetus.kundera.generator.Generator;
import com.impetus.kundera.generator.SequenceGenerator;
import com.impetus.kundera.generator.TableGenerator;
import com.impetus.kundera.metadata.KunderaMetadataManager;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.IdDiscriptor;
import com.impetus.kundera.metadata.model.MetamodelImpl;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import com.impetus.kundera.persistence.PersistenceDelegator;
import com.impetus.kundera.property.PropertyAccessorHelper;
import com.impetus.kundera.utils.KunderaCoreUtils;
import javax.persistence.GenerationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdGenerator {
    private static final Logger log = LoggerFactory.getLogger(IdGenerator.class);

    public Object generateAndSetId(Object e, EntityMetadata m, PersistenceDelegator pd, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        MetamodelImpl metamodel = KunderaMetadataManager.getMetamodel(kunderaMetadata, m.getPersistenceUnit());
        Client client = pd.getClient(m);
        return this.generateId(e, m, client, kunderaMetadata);
    }

    private Object generateId(Object e, EntityMetadata m, Client<?> client, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        MetamodelImpl metamodel = KunderaMetadataManager.getMetamodel(kunderaMetadata, m.getPersistenceUnit());
        IdDiscriptor keyValue = metamodel.getKeyValue(e.getClass().getName());
        if (keyValue != null) {
            if (!client.getQueryImplementor().getSimpleName().equalsIgnoreCase("RDBMSQuery")) {
                if (client != null) {
                    GenerationType type = keyValue.getStrategy();
                    switch (type) {
                        case TABLE: {
                            return this.onTableGenerator(m, client, keyValue, e);
                        }
                        case SEQUENCE: {
                            return this.onSequenceGenerator(m, client, keyValue, e);
                        }
                        case AUTO: {
                            return this.onAutoGenerator(m, client, e);
                        }
                        case IDENTITY: {
                            throw new UnsupportedOperationException(GenerationType.class.getSimpleName() + "." + type + " Strategy not supported by this client :" + client.getClass().getName());
                        }
                    }
                }
            } else {
                int hashCode = e.hashCode();
                Object generatedId = PropertyAccessorHelper.fromSourceToTargetClass(m.getIdAttribute().getJavaType(), Integer.class, new Integer(hashCode));
                PropertyAccessorHelper.setId(e, m, generatedId);
                return generatedId;
            }
        }
        return null;
    }

    private Object onAutoGenerator(EntityMetadata m, Client<?> client, Object e) {
        Generator autogenerator = this.getAutoGenClazz(client);
        if (autogenerator instanceof AutoGenerator) {
            Object generatedId = ((AutoGenerator)autogenerator).generate(client, m.getIdAttribute().getJavaType().getSimpleName());
            try {
                generatedId = PropertyAccessorHelper.fromSourceToTargetClass(m.getIdAttribute().getJavaType(), generatedId.getClass(), generatedId);
                PropertyAccessorHelper.setId(e, m, generatedId);
                return generatedId;
            }
            catch (IllegalArgumentException iae) {
                log.error("Unknown data type for ids : " + m.getIdAttribute().getJavaType());
                throw new KunderaException("Unknown data type for ids : " + m.getIdAttribute().getJavaType(), iae);
            }
        }
        throw new IllegalArgumentException(GenerationType.class.getSimpleName() + "." + GenerationType.AUTO + " Strategy not supported by this client :" + client.getClass().getName());
    }

    private Generator getAutoGenClazz(Client<?> client) {
        Generator autoGenerator = null;
        String autoGen = ((ClientBase)((Object)client)).getAutoGenerator();
        if (null != autoGen) {
            try {
                Class<?> autogenClazz = Class.forName(autoGen);
                autoGenerator = (Generator)KunderaCoreUtils.createNewInstance(autogenClazz);
            }
            catch (ClassNotFoundException cnfe) {
                log.error("The autogen custom class is invalid");
                throw new KunderaException("The autogen custom class should implement AutoGenerator class", cnfe);
            }
        } else {
            autoGenerator = client.getIdGenerator();
        }
        return autoGenerator;
    }

    private Object onSequenceGenerator(EntityMetadata m, Client<?> client, IdDiscriptor keyValue, Object e) {
        Generator seqgenerator = this.getAutoGenClazz(client);
        if (seqgenerator instanceof SequenceGenerator) {
            Object generatedId = ((SequenceGenerator)seqgenerator).generate(keyValue.getSequenceDiscriptor(), client, m.getIdAttribute().getJavaType().getSimpleName());
            try {
                generatedId = PropertyAccessorHelper.fromSourceToTargetClass(m.getIdAttribute().getJavaType(), generatedId.getClass(), generatedId);
                PropertyAccessorHelper.setId(e, m, generatedId);
                return generatedId;
            }
            catch (IllegalArgumentException iae) {
                log.error("Unknown integral data type for ids : " + m.getIdAttribute().getJavaType());
                throw new KunderaException("Unknown integral data type for ids : " + m.getIdAttribute().getJavaType(), iae);
            }
        }
        throw new IllegalArgumentException(GenerationType.class.getSimpleName() + "." + GenerationType.SEQUENCE + " Strategy not supported by this client :" + client.getClass().getName());
    }

    private Object onTableGenerator(EntityMetadata m, Client<?> client, IdDiscriptor keyValue, Object e) {
        Generator tablegenerator = this.getAutoGenClazz(client);
        if (tablegenerator instanceof TableGenerator) {
            Object generatedId = ((TableGenerator)tablegenerator).generate(keyValue.getTableDiscriptor(), (ClientBase)((Object)client), m.getIdAttribute().getJavaType().getSimpleName());
            try {
                generatedId = PropertyAccessorHelper.fromSourceToTargetClass(m.getIdAttribute().getJavaType(), generatedId.getClass(), generatedId);
                PropertyAccessorHelper.setId(e, m, generatedId);
                return generatedId;
            }
            catch (IllegalArgumentException iae) {
                log.error("Unknown integral data type for ids : " + m.getIdAttribute().getJavaType());
                throw new KunderaException("Unknown integral data type for ids : " + m.getIdAttribute().getJavaType(), iae);
            }
        }
        throw new IllegalArgumentException(GenerationType.class.getSimpleName() + "." + GenerationType.TABLE + " Strategy not supported by this client :" + client.getClass().getName());
    }
}

