/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.persistence;

import com.impetus.kundera.persistence.DefaultRoot;
import com.impetus.kundera.persistence.KunderaCriteriaBuilder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Tuple;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.EntityType;

public class KunderaCritieriaQuery<T>
implements CriteriaQuery<T> {
    private KunderaCriteriaBuilder criteriaBuilder;
    private Class<T> returnType;
    private QueryPlan queryPlan = new QueryPlan();

    KunderaCritieriaQuery(KunderaCriteriaBuilder kunderaCriteriaBuilder) {
        this.criteriaBuilder = kunderaCriteriaBuilder;
        this.returnType = Object.class;
    }

    KunderaCritieriaQuery(KunderaCriteriaBuilder kunderaCriteriaBuilder, Class<T> returnClazz) {
        this.criteriaBuilder = kunderaCriteriaBuilder;
        this.returnType = returnClazz;
    }

    public <X> Root<X> from(Class<X> paramClass) {
        EntityType entityType = this.criteriaBuilder.getMetaModel().entity(paramClass);
        return this.fromEntityType(entityType);
    }

    public <X> Root<X> from(EntityType<X> paramEntityType) {
        if (!this.criteriaBuilder.getMetaModel().getEntities().contains(paramEntityType)) {
            throw new IllegalArgumentException("Invalid entity type, {class:" + paramEntityType.getName() + "}");
        }
        return this.fromEntityType(paramEntityType);
    }

    public <U> Subquery<U> subquery(Class<U> paramClass) {
        return null;
    }

    public Set<Root<?>> getRoots() {
        return this.queryPlan.from;
    }

    public Selection<T> getSelection() {
        return this.queryPlan.select;
    }

    public Predicate getRestriction() {
        return this.queryPlan.where;
    }

    public List<Expression<?>> getGroupList() {
        return null;
    }

    public Predicate getGroupRestriction() {
        return null;
    }

    public boolean isDistinct() {
        return false;
    }

    public Class<T> getResultType() {
        return this.returnType;
    }

    public CriteriaQuery<T> select(Selection<? extends T> paramSelection) {
        this.queryPlan.setSelection(paramSelection);
        return this;
    }

    public CriteriaQuery<T> multiselect(Selection<?> ... paramArrayOfSelection) {
        SelectionType type = SelectionType.getSelectionType(this.getResultType());
        switch (type) {
            case TUPLE: {
                this.queryPlan.setSelection((Selection)this.criteriaBuilder.tuple(paramArrayOfSelection));
                break;
            }
            case ARRAY: {
                this.queryPlan.setSelection((Selection)this.criteriaBuilder.array(this.getResultType(), paramArrayOfSelection));
                break;
            }
            case OBJECT: {
                this.queryPlan.setSelection((Selection)this.criteriaBuilder.construct(this.getResultType(), paramArrayOfSelection));
            }
        }
        return this;
    }

    public CriteriaQuery<T> multiselect(List<Selection<?>> paramList) {
        return this.multiselect((Selection[])paramList.toArray());
    }

    public CriteriaQuery<T> where(Expression<Boolean> paramExpression) {
        if (Predicate.class.isAssignableFrom(paramExpression.getClass())) {
            this.queryPlan.setWhere(this.criteriaBuilder.and((Predicate)paramExpression));
        }
        return this;
    }

    public CriteriaQuery<T> where(Predicate ... paramArrayOfPredicate) {
        this.queryPlan.setWhere(this.criteriaBuilder.and(paramArrayOfPredicate));
        return this;
    }

    public CriteriaQuery<T> groupBy(Expression<?> ... paramArrayOfExpression) {
        return null;
    }

    public CriteriaQuery<T> groupBy(List<Expression<?>> paramList) {
        return null;
    }

    public CriteriaQuery<T> having(Expression<Boolean> paramExpression) {
        return null;
    }

    public CriteriaQuery<T> having(Predicate ... paramArrayOfPredicate) {
        return null;
    }

    public CriteriaQuery<T> orderBy(Order ... paramArrayOfOrder) {
        return this.orderBy(Arrays.asList(paramArrayOfOrder));
    }

    public CriteriaQuery<T> orderBy(List<Order> paramList) {
        this.queryPlan.setOrderBy(paramList);
        return this;
    }

    public CriteriaQuery<T> distinct(boolean paramBoolean) {
        return null;
    }

    public List<Order> getOrderList() {
        return this.queryPlan.orderBy;
    }

    public Set<ParameterExpression<?>> getParameters() {
        return null;
    }

    private <X> Root<X> fromEntityType(EntityType<X> paramEntityType) {
        DefaultRoot<X> root = new DefaultRoot<X>(paramEntityType);
        this.queryPlan.add(root);
        return root;
    }

    class QueryPlan {
        private Selection<?> select;
        private Set<Root<?>> from = new HashSet();
        private Predicate where;
        private List<Order> orderBy;

        QueryPlan() {
        }

        void add(Root root) {
            this.from.add(root);
        }

        void setWhere(Predicate predicate) {
            this.where = predicate;
        }

        void setSelection(Selection selection) {
            this.select = selection;
        }

        void setOrderBy(List<Order> orderBy) {
            this.orderBy = orderBy;
        }
    }

    static enum SelectionType {
        TUPLE,
        ARRAY,
        OBJECT;


        static SelectionType getSelectionType(Class clazz) {
            if (clazz.isAssignableFrom(Tuple.class)) {
                return TUPLE;
            }
            if (clazz.isArray()) {
                return ARRAY;
            }
            return OBJECT;
        }
    }
}

