/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.persistence;

import com.impetus.kundera.metadata.KunderaMetadataManager;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.MetamodelImpl;
import com.impetus.kundera.metadata.model.type.AbstractManagedType;
import com.impetus.kundera.metadata.processor.MetaModelBuilder;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import com.impetus.kundera.property.PropertyAccessorHelper;
import com.impetus.kundera.validation.ValidationFactory;
import com.impetus.kundera.validation.ValidationFactoryGenerator;
import com.impetus.kundera.validation.rules.AttributeConstraintRule;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Set;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceValidator {
    private static final Logger log = LoggerFactory.getLogger(PersistenceValidator.class);
    private ValidationFactoryGenerator generator = new ValidationFactoryGenerator();
    private ValidationFactory factory = this.generator.getFactory(ValidationFactoryGenerator.ValidationFactoryType.OPERATIONAL_VALIDATION);

    public boolean isValidEntityObject(Object entity, EntityMetadata metadata) {
        if (entity == null) {
            log.error("Entity to be persisted must not be null, operation failed");
            return false;
        }
        Object id = PropertyAccessorHelper.getId(entity, metadata);
        if (id == null) {
            log.error("Entity to be persisted can't have Primary key set to null.");
            throw new IllegalArgumentException("Entity to be persisted can't have Primary key set to null.");
        }
        return true;
    }

    public void validate(Object entity, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        this.validateEntityAttributes(entity, kunderaMetadata);
    }

    private <X extends Class, T> void validateEntityAttributes(Object entity, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        EntityMetadata entityMetadata = KunderaMetadataManager.getEntityMetadata(kunderaMetadata, entity.getClass());
        MetamodelImpl metaModel = (MetamodelImpl)kunderaMetadata.getApplicationMetadata().getMetamodel(entityMetadata.getPersistenceUnit());
        AbstractManagedType managedType = (AbstractManagedType)metaModel.entity(entityMetadata.getEntityClazz());
        MetaModelBuilder metaModelBuilder = kunderaMetadata.getApplicationMetadata().getMetaModelBuilder(entityMetadata.getPersistenceUnit());
        EntityType<?> entityType = metaModelBuilder.getManagedTypes().get(entityMetadata.getEntityClazz());
        if (managedType.hasValidationConstraints()) {
            Set attributes = entityType.getAttributes();
            for (Attribute attribute : attributes) {
                Field f = (Field)attribute.getJavaMember();
                if (metaModel.isEmbeddable(attribute.getJavaType())) {
                    EmbeddableType embeddedColumn = (EmbeddableType)metaModelBuilder.getEmbeddables().get(attribute.getJavaType());
                    Object embeddedObject = PropertyAccessorHelper.getObject(entity, (Field)entityType.getAttribute(attribute.getName()).getJavaMember());
                    this.onValidateEmbeddable(embeddedObject, embeddedColumn);
                }
                this.factory.validate(f, entity, new AttributeConstraintRule());
            }
        }
    }

    private void onValidateEmbeddable(Object embeddedObject, EmbeddableType embeddedColumn) {
        if (embeddedObject instanceof Collection) {
            for (Object obj : (Collection)embeddedObject) {
                for (Object column : embeddedColumn.getAttributes()) {
                    Attribute columnAttribute = (Attribute)column;
                    Field f = (Field)columnAttribute.getJavaMember();
                    this.factory.validate(f, embeddedObject, new AttributeConstraintRule());
                }
            }
        } else {
            for (Object column : embeddedColumn.getAttributes()) {
                Attribute columnAttribute = (Attribute)column;
                Field f = (Field)columnAttribute.getJavaMember();
                this.factory.validate(f, embeddedObject, new AttributeConstraintRule());
            }
        }
    }
}

