/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.persistence.context;

import com.impetus.kundera.client.Client;
import com.impetus.kundera.graph.Node;
import com.impetus.kundera.graph.NodeLink;
import com.impetus.kundera.lifecycle.states.ManagedState;
import com.impetus.kundera.lifecycle.states.RemovedState;
import com.impetus.kundera.lifecycle.states.TransientState;
import com.impetus.kundera.metadata.KunderaMetadataManager;
import com.impetus.kundera.metadata.MetadataUtils;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.JoinTableMetadata;
import com.impetus.kundera.metadata.model.Relation;
import com.impetus.kundera.persistence.PersistenceDelegator;
import com.impetus.kundera.persistence.context.EventLog;
import com.impetus.kundera.persistence.context.EventLogQueue;
import com.impetus.kundera.persistence.context.jointable.JoinTableData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingDeque;
import javax.persistence.CascadeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlushManager {
    private Deque<Node> stackQueue;
    private List<JoinTableData> joinTableDataCollection = new ArrayList<JoinTableData>();
    private EventLogQueue eventLogQueue = new EventLogQueue();
    private static final Logger log = LoggerFactory.getLogger(FlushManager.class);
    private static Map<EventLog.EventType, List<CascadeType>> cascadePermission = new HashMap<EventLog.EventType, List<CascadeType>>();

    public FlushManager() {
        this.stackQueue = new LinkedBlockingDeque<Node>();
    }

    public void buildFlushStack(Node headNode, EventLog.EventType eventType) {
        if (headNode != null) {
            headNode.setTraversed(false);
            this.addNodesToFlushStack(headNode, eventType);
        }
    }

    private void addNodesToFlushStack(Node node, EventLog.EventType eventType) {
        Map<NodeLink, Node> children = node.getChildren();
        this.performOperation(node, eventType);
        if (children != null) {
            Node childNode;
            HashMap<NodeLink, Node> oneToOneChildren = new HashMap<NodeLink, Node>();
            HashMap<NodeLink, Node> oneToManyChildren = new HashMap<NodeLink, Node>();
            HashMap<NodeLink, Node> manyToOneChildren = new HashMap<NodeLink, Node>();
            HashMap<NodeLink, Node> manyToManyChildren = new HashMap<NodeLink, Node>();
            for (NodeLink nodeLink : children.keySet()) {
                List cascadeTypes = (List)nodeLink.getLinkProperty(NodeLink.LinkProperty.CASCADE);
                if (!cascadeTypes.contains(cascadePermission.get((Object)eventType).get(0)) && !cascadeTypes.contains(cascadePermission.get((Object)eventType).get(1))) continue;
                Relation.ForeignKey multiplicity = nodeLink.getMultiplicity();
                Node childNode2 = children.get(nodeLink);
                switch (multiplicity) {
                    case ONE_TO_ONE: {
                        oneToOneChildren.put(nodeLink, childNode2);
                        break;
                    }
                    case ONE_TO_MANY: {
                        oneToManyChildren.put(nodeLink, childNode2);
                        break;
                    }
                    case MANY_TO_ONE: {
                        manyToOneChildren.put(nodeLink, childNode2);
                        break;
                    }
                    case MANY_TO_MANY: {
                        manyToManyChildren.put(nodeLink, childNode2);
                    }
                }
            }
            for (NodeLink nodeLink : oneToManyChildren.keySet()) {
                childNode = children.get(nodeLink);
                if (childNode == null || childNode.isTraversed()) continue;
                this.addNodesToFlushStack(childNode, eventType);
            }
            for (NodeLink nodeLink : manyToManyChildren.keySet()) {
                JoinTableMetadata jtmd;
                if (!node.isTraversed() && !((Boolean)nodeLink.getLinkProperty(NodeLink.LinkProperty.IS_RELATED_VIA_JOIN_TABLE)).booleanValue()) {
                    node.setTraversed(true);
                    this.stackQueue.push(node);
                    this.logEvent(node, eventType);
                }
                if ((childNode = children.get(nodeLink)) == null) continue;
                if (node.isDirty() && !node.isTraversed() && (jtmd = (JoinTableMetadata)nodeLink.getLinkProperty(NodeLink.LinkProperty.JOIN_TABLE_METADATA)) != null) {
                    String joinColumnName = (String)jtmd.getJoinColumns().toArray()[0];
                    String inverseJoinColumnName = (String)jtmd.getInverseJoinColumns().toArray()[0];
                    Object entityId = node.getEntityId();
                    Object childId = childNode.getEntityId();
                    HashSet<Object> childValues = new HashSet<Object>();
                    childValues.add(childId);
                    JoinTableData.OPERATION operation = null;
                    if (node.getCurrentNodeState().getClass().equals(ManagedState.class)) {
                        operation = JoinTableData.OPERATION.INSERT;
                    } else if (node.getCurrentNodeState().getClass().equals(RemovedState.class)) {
                        operation = JoinTableData.OPERATION.DELETE;
                    }
                    this.addJoinTableData(operation, jtmd.getJoinTableSchema(), jtmd.getJoinTableName(), joinColumnName, inverseJoinColumnName, node.getDataClass(), entityId, childValues);
                }
                if (childNode.isTraversed()) continue;
                this.addNodesToFlushStack(childNode, eventType);
            }
            for (NodeLink nodeLink : oneToOneChildren.keySet()) {
                if (!node.isTraversed()) {
                    node.setTraversed(true);
                    this.stackQueue.push(node);
                    this.logEvent(node, eventType);
                }
                childNode = children.get(nodeLink);
                this.addNodesToFlushStack(childNode, eventType);
            }
            for (NodeLink nodeLink : manyToOneChildren.keySet()) {
                if (!node.isTraversed()) {
                    node.setTraversed(true);
                    this.stackQueue.push(node);
                    this.logEvent(node, eventType);
                }
                childNode = children.get(nodeLink);
                Map<NodeLink, Node> parents = childNode.getParents();
                for (NodeLink parentLink : parents.keySet()) {
                    List cascadeTypes = (List)nodeLink.getLinkProperty(NodeLink.LinkProperty.CASCADE);
                    if (!cascadeTypes.contains(cascadePermission.get((Object)eventType).get(0)) && !cascadeTypes.contains(cascadePermission.get((Object)eventType).get(1))) continue;
                    Relation.ForeignKey multiplicity = parentLink.getMultiplicity();
                    Node parentNode = parents.get(parentLink);
                    if (!multiplicity.equals((Object)Relation.ForeignKey.MANY_TO_ONE) || parentNode.isTraversed() || !parentNode.isDirty()) continue;
                    this.addNodesToFlushStack(parentNode, eventType);
                }
                if (!childNode.isTraversed() && childNode.isDirty()) {
                    this.addNodesToFlushStack(childNode, eventType);
                    continue;
                }
                if (childNode.isDirty()) continue;
                childNode.setTraversed(true);
                this.stackQueue.push(childNode);
                this.logEvent(childNode, eventType);
            }
        }
        if (!node.isTraversed() && node.isDirty()) {
            node.setTraversed(true);
            this.stackQueue.push(node);
            this.logEvent(node, eventType);
        }
    }

    public Deque<Node> getFlushStack() {
        return this.stackQueue;
    }

    public List<JoinTableData> getJoinTableData() {
        return this.joinTableDataCollection;
    }

    public void clearFlushStack() {
        if (this.stackQueue != null && !this.stackQueue.isEmpty()) {
            this.stackQueue.clear();
        }
        if (this.joinTableDataCollection != null && !this.joinTableDataCollection.isEmpty()) {
            this.joinTableDataCollection.clear();
        }
        if (this.eventLogQueue != null) {
            this.eventLogQueue.clear();
        }
    }

    public void rollback(PersistenceDelegator delegator) {
        if (this.eventLogQueue != null) {
            this.onRollBack(delegator, this.eventLogQueue.getInsertEvents());
            this.onRollBack(delegator, this.eventLogQueue.getUpdateEvents());
            this.onRollBack(delegator, this.eventLogQueue.getDeleteEvents());
            this.rollbackJoinTableData(delegator);
        }
    }

    public void commit() {
        this.onCommit(this.eventLogQueue.getInsertEvents());
        this.onCommit(this.eventLogQueue.getUpdateEvents());
        this.onCommit(this.eventLogQueue.getDeleteEvents());
    }

    private void onCommit(Map<Object, EventLog> eventCol) {
        if (eventCol != null && !eventCol.isEmpty()) {
            Collection<EventLog> events = eventCol.values();
            Iterator<EventLog> iter = events.iterator();
            while (iter.hasNext()) {
                try {
                    EventLog event = iter.next();
                    Node node = event.getNode();
                    if (node.isProcessed()) {
                        Node original = node.clone();
                        node.setOriginalNode(original);
                    }
                    event = null;
                }
                catch (Exception ex) {
                    log.warn("Caught exception during rollback, Caused by:", (Throwable)ex);
                }
            }
        }
    }

    private void onRollBack(PersistenceDelegator delegator, Map<Object, EventLog> eventCol) {
        if (eventCol != null && !eventCol.isEmpty()) {
            Collection<EventLog> events = eventCol.values();
            Iterator<EventLog> iter = events.iterator();
            while (iter.hasNext()) {
                try {
                    EventLog event = iter.next();
                    Node node = event.getNode();
                    Class clazz = node.getDataClass();
                    EntityMetadata metadata = KunderaMetadataManager.getEntityMetadata(delegator.getKunderaMetadata(), clazz);
                    Client client = delegator.getClient(metadata);
                    if (node.isProcessed() && (!delegator.isTransactionInProgress() || MetadataUtils.defaultTransactionSupported(metadata.getPersistenceUnit(), delegator.getKunderaMetadata()))) {
                        if (node.getOriginalNode() == null) {
                            Object entityId = node.getEntityId();
                            client.remove(node.getData(), entityId);
                        } else {
                            client.persist(node.getOriginalNode());
                        }
                    }
                    event = null;
                }
                catch (Exception ex) {
                    log.warn("Caught exception during rollback, Caused by:", (Throwable)ex);
                }
            }
        }
        eventCol = null;
    }

    private void addJoinTableData(JoinTableData.OPERATION operation, String schemaName, String joinTableName, String joinColumnName, String invJoinColumnName, Class<?> entityClass, Object joinColumnValue, Set<Object> invJoinColumnValues) {
        JoinTableData joinTableData = new JoinTableData(operation, schemaName, joinTableName, joinColumnName, invJoinColumnName, entityClass);
        joinTableData.addJoinTableRecord(joinColumnValue, invJoinColumnValues);
        this.joinTableDataCollection.add(joinTableData);
    }

    private void logEvent(Node node, EventLog.EventType eventType) {
        EventLog log = new EventLog(eventType, node);
        this.eventLogQueue.onEvent(log, eventType);
    }

    private void rollbackJoinTableData(PersistenceDelegator delegator) {
        for (JoinTableData jtData : this.joinTableDataCollection) {
            if (!jtData.isProcessed()) continue;
            EntityMetadata m = KunderaMetadataManager.getEntityMetadata(delegator.getKunderaMetadata(), jtData.getEntityClass());
            Client client = delegator.getClient(m);
            if (JoinTableData.OPERATION.INSERT.equals((Object)jtData.getOperation())) {
                for (Object pk : jtData.getJoinTableRecords().keySet()) {
                    client.deleteByColumn(jtData.getSchemaName(), jtData.getJoinTableName(), m.getIdAttribute().getName(), pk);
                }
                continue;
            }
            if (!JoinTableData.OPERATION.DELETE.equals((Object)jtData.getOperation())) continue;
            client.persistJoinTable(jtData);
        }
        this.joinTableDataCollection.clear();
        this.joinTableDataCollection = null;
        this.joinTableDataCollection = new ArrayList<JoinTableData>();
    }

    private void performOperation(Node node, EventLog.EventType eventType) {
        switch (eventType) {
            case INSERT: {
                node.persist();
                break;
            }
            case UPDATE: {
                if (node.isInState(TransientState.class)) {
                    node.persist();
                    break;
                }
                node.merge();
                break;
            }
            case DELETE: {
                node.remove();
            }
        }
    }

    static {
        ArrayList<CascadeType> cascades = new ArrayList<CascadeType>();
        cascades.add(CascadeType.ALL);
        cascades.add(CascadeType.PERSIST);
        cascadePermission.put(EventLog.EventType.INSERT, cascades);
        cascades = new ArrayList();
        cascades.add(CascadeType.ALL);
        cascades.add(CascadeType.MERGE);
        cascadePermission.put(EventLog.EventType.UPDATE, cascades);
        cascades = new ArrayList();
        cascades.add(CascadeType.ALL);
        cascades.add(CascadeType.REMOVE);
        cascadePermission.put(EventLog.EventType.DELETE, cascades);
    }
}

