/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.persistence.event;

import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.persistence.event.CallbackMethod;
import java.util.List;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityEventDispatcher {
    private static final Logger log = LoggerFactory.getLogger(EntityManager.class);

    public void fireEventListeners(EntityMetadata metadata, Object entity, Class<?> event) {
        List<? extends CallbackMethod> callBackMethods = metadata.getCallbackMethods(event);
        if (null != callBackMethods && !callBackMethods.isEmpty() && null != entity) {
            log.debug("Callback >> " + event.getSimpleName() + " on " + metadata.getEntityClazz().getName());
            for (CallbackMethod callbackMethod : callBackMethods) {
                log.debug("Firing >> " + callbackMethod);
                callbackMethod.invoke(entity);
            }
        }
    }
}

