/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.persistence.event;

import com.impetus.kundera.persistence.event.CallbackMethod;
import com.impetus.kundera.persistence.event.EventListenerException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class ExternalCallbackMethod
implements CallbackMethod {
    private Class<?> clazz;
    private Method method;

    public ExternalCallbackMethod(Class<?> clazz, Method method) {
        this.clazz = clazz;
        this.method = method;
    }

    @Override
    public void invoke(Object entity) throws EventListenerException {
        if (!this.method.isAccessible()) {
            this.method.setAccessible(true);
        }
        try {
            this.method.invoke(this.clazz.newInstance(), entity);
        }
        catch (IllegalArgumentException e) {
            throw new EventListenerException(e);
        }
        catch (IllegalAccessException e) {
            throw new EventListenerException(e);
        }
        catch (InvocationTargetException e) {
            throw new EventListenerException(e);
        }
        catch (InstantiationException e) {
            throw new EventListenerException(e);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.clazz.getName() + "." + this.method.getName());
        return builder.toString();
    }
}

