/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.persistence.jta;

import com.impetus.kundera.persistence.ResourceManager;
import com.impetus.kundera.persistence.jta.KunderaTransaction;
import com.impetus.kundera.persistence.jta.UserTransactionFactory;
import java.io.Serializable;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.UserTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KunderaJTAUserTransaction
implements UserTransaction,
Referenceable,
Serializable {
    private static transient ThreadLocal<KunderaTransaction> threadLocal = new ThreadLocal();
    private static transient ThreadLocal<Integer> timerThead = new ThreadLocal();
    private static final Integer DEFAULT_TIME_OUT = 60;
    private static transient KunderaJTAUserTransaction currentTx;
    private static final Logger log;

    public KunderaJTAUserTransaction() {
        currentTx = this;
    }

    public static KunderaJTAUserTransaction getCurrentTx() {
        return currentTx;
    }

    public void begin() throws NotSupportedException, SystemException {
        Transaction tx;
        if (log.isDebugEnabled()) {
            log.info("beginning JTA transaction");
        }
        if ((tx = (Transaction)threadLocal.get()) != null && tx.getStatus() == 1) {
            throw new NotSupportedException("Nested Transaction not supported!");
        }
        Integer timer = timerThead.get();
        threadLocal.set(new KunderaTransaction(timer != null ? timer : DEFAULT_TIME_OUT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        Transaction tx = threadLocal.get();
        try {
            if (tx != null) {
                if (log.isDebugEnabled()) {
                    log.info("Commiting transaction:" + tx);
                }
                tx.commit();
            } else {
                log.debug("Cannot locate a transaction to commit.");
            }
        }
        finally {
            if (log.isDebugEnabled()) {
                log.info("Resetting after commit.");
            }
            threadLocal.set(null);
            timerThead.set(null);
        }
    }

    public int getStatus() throws SystemException {
        Transaction tx = threadLocal.get();
        if (tx == null) {
            return 6;
        }
        return tx.getStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        try {
            Transaction tx = threadLocal.get();
            if (tx == null) {
                throw new IllegalStateException("Cannot locate a Transaction for rollback.");
            }
            if (log.isDebugEnabled()) {
                log.info("Rollback transaction:" + tx);
            }
            tx.rollback();
        }
        finally {
            if (log.isDebugEnabled()) {
                log.info("Resetting after rollback.");
            }
            threadLocal.set(null);
            timerThead.set(null);
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        Transaction tx = threadLocal.get();
        if (tx == null) {
            throw new IllegalStateException("Cannot get Transaction for setRollbackOnly");
        }
        tx.setRollbackOnly();
    }

    public void setTransactionTimeout(int timeout) throws SystemException {
        Transaction tx = threadLocal.get();
        if (tx == null) {
            timerThead.set(timeout);
        } else if (log.isDebugEnabled()) {
            log.debug("Cannot reset running transaction:" + tx);
        }
    }

    public int getTransactionTimeout() {
        Integer timeOut = timerThead.get();
        if (timeOut == null) {
            return DEFAULT_TIME_OUT;
        }
        return timeOut;
    }

    public void setImplementor(ResourceManager implementor) {
        KunderaTransaction tx = threadLocal.get();
        if (tx == null) {
            throw new IllegalStateException("Cannot get Transaction to start");
        }
        tx.setImplementor(implementor);
    }

    @Override
    public Reference getReference() throws NamingException {
        return UserTransactionFactory.getReference(this);
    }

    static {
        log = LoggerFactory.getLogger(KunderaJTAUserTransaction.class);
    }
}

