/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.persistence.jta;

import com.impetus.kundera.persistence.ResourceManager;
import java.util.HashSet;
import java.util.Set;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KunderaTransaction
implements Transaction {
    private Set<ResourceManager> implementors = new HashSet<ResourceManager>();
    private boolean setRollBackOnly;
    private int status = 0;
    private int timeOutInMillis;
    private static final Logger log = LoggerFactory.getLogger(KunderaTransaction.class);

    KunderaTransaction(int timeOutInMillis) {
        this.timeOutInMillis = timeOutInMillis;
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (!this.setRollBackOnly) {
            for (ResourceManager implementor : this.implementors) {
                if (implementor == null) continue;
                implementor.doCommit();
            }
            this.status = 3;
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Transaction is set for rollback only, processing rollback.");
            }
            for (ResourceManager implementor : this.implementors) {
                if (implementor == null) continue;
                implementor.doRollback();
                this.status = 4;
            }
        }
    }

    public boolean delistResource(XAResource paramXAResource, int paramInt) throws IllegalStateException, SystemException {
        return false;
    }

    public boolean enlistResource(XAResource paramXAResource) throws RollbackException, IllegalStateException, SystemException {
        return false;
    }

    public int getStatus() throws SystemException {
        return this.status;
    }

    public void registerSynchronization(Synchronization paramSynchronization) throws RollbackException, IllegalStateException, SystemException {
        throw new UnsupportedOperationException("Currently it is not supported.");
    }

    public void rollback() throws IllegalStateException, SystemException {
        for (ResourceManager implementor : this.implementors) {
            if (implementor == null) continue;
            implementor.doRollback();
            this.status = 4;
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.setRollBackOnly = true;
        this.status = 1;
    }

    void setImplementor(ResourceManager implementor) {
        this.implementors.add(implementor);
    }

    public int getTransactionTimeout() {
        return this.timeOutInMillis;
    }
}

