/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.property.accessor;

import com.impetus.kundera.property.PropertyAccessor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;

public class BigDecimalAccessor
implements PropertyAccessor<BigDecimal> {
    @Override
    public BigDecimal fromBytes(Class targetClass, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        int scale = bytes[0] << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
        byte[] bibytes = Arrays.copyOfRange(bytes, 4, bytes.length);
        BigInteger bi = new BigInteger(bibytes);
        return new BigDecimal(bi, scale);
    }

    @Override
    public byte[] toBytes(Object object) {
        if (object == null) {
            return null;
        }
        BigDecimal b = (BigDecimal)object;
        int scale = b.scale();
        BigInteger unscaled = b.unscaledValue();
        byte[] value = unscaled.toByteArray();
        byte[] bytes = new byte[value.length + 4];
        bytes[0] = (byte)(scale >>> 24);
        bytes[1] = (byte)(scale >>> 16);
        bytes[2] = (byte)(scale >>> 8);
        bytes[3] = (byte)(scale >>> 0);
        System.arraycopy(value, 0, bytes, 4, value.length);
        return bytes;
    }

    @Override
    public String toString(Object object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    @Override
    public BigDecimal fromString(Class targetClass, String s) {
        return s != null ? new BigDecimal(s) : null;
    }

    @Override
    public BigDecimal getCopy(Object object) {
        BigDecimal b = (BigDecimal)object;
        return object != null ? b : null;
    }

    @Override
    public BigDecimal getInstance(Class<?> clazz) {
        return BigDecimal.TEN;
    }
}

