/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.property.accessor;

import com.impetus.kundera.property.PropertyAccessException;
import com.impetus.kundera.property.PropertyAccessor;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteAccessor
implements PropertyAccessor<Byte> {
    private static Logger log = LoggerFactory.getLogger(ByteAccessor.class);

    @Override
    public Byte fromBytes(Class targetClass, byte[] b) {
        try {
            if (b == null) {
                return null;
            }
            return ByteBuffer.wrap(b).get();
        }
        catch (NumberFormatException e) {
            log.warn("Number format exception caught!,returning null!");
            return null;
        }
    }

    @Override
    public byte[] toBytes(Object object) {
        if (object == null) {
            return null;
        }
        Byte b = (Byte)object;
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.put(b);
        return buffer.array();
    }

    @Override
    public String toString(Object object) {
        return object != null ? object.toString() : null;
    }

    @Override
    public Byte fromString(Class targetClass, String s) {
        try {
            if (s == null) {
                return null;
            }
            Byte b = new Byte(s);
            return b;
        }
        catch (NumberFormatException e) {
            log.error("Number fromat exception, Caused by {}.", (Throwable)e);
            throw new PropertyAccessException(e);
        }
    }

    @Override
    public Byte getCopy(Object object) {
        return object != null ? new Byte((Byte)object) : null;
    }

    @Override
    public Byte getInstance(Class<?> clazz) {
        return (byte)127;
    }
}

