/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.property.accessor;

import com.impetus.kundera.property.PropertyAccessor;
import com.impetus.kundera.property.accessor.DateAccessor;
import com.impetus.kundera.property.accessor.LongAccessor;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class CalendarAccessor
implements PropertyAccessor<Calendar> {
    private static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss", Locale.ENGLISH);

    @Override
    public Calendar fromBytes(Class targetClass, byte[] b) {
        Calendar cal = Calendar.getInstance();
        Date d = new Date();
        if (b == null) {
            return null;
        }
        LongAccessor longAccessor = new LongAccessor();
        d.setTime(longAccessor.fromBytes(targetClass, b));
        cal.setTime(d);
        return cal;
    }

    @Override
    public byte[] toBytes(Object object) {
        if (object == null) {
            return null;
        }
        Calendar cal = (Calendar)object;
        LongAccessor longAccessor = new LongAccessor();
        return longAccessor.toBytes(cal.getTime().getTime());
    }

    @Override
    public String toString(Object object) {
        Calendar calendar = (Calendar)object;
        if (calendar == null) {
            return null;
        }
        return String.valueOf(calendar.getTime().getTime());
    }

    @Override
    public Calendar fromString(Class targetClass, String s) {
        if (s == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        Date d = DateAccessor.getDateByPattern(s);
        cal.setTime(d);
        return cal;
    }

    @Override
    public Calendar getCopy(Object object) {
        if (object == null) {
            return null;
        }
        Calendar c = (Calendar)object;
        Calendar copy = Calendar.getInstance();
        copy.setTimeInMillis(c.getTimeInMillis());
        return copy;
    }

    @Override
    public Calendar getInstance(Class<?> clazz) {
        return Calendar.getInstance();
    }
}

