/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.property.accessor;

import com.impetus.kundera.property.PropertyAccessException;
import com.impetus.kundera.property.PropertyAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharAccessor
implements PropertyAccessor<Character> {
    private static final Logger log = LoggerFactory.getLogger(CharAccessor.class);

    @Override
    public Character fromBytes(Class targetClass, byte[] data) {
        if (data == null || data.length != 2) {
            if (log.isWarnEnabled()) {
                log.warn("Data length is not matching");
            }
            return Character.valueOf('\u0000');
        }
        return Character.valueOf((char)((0xFF & data[0]) << 8 | (0xFF & data[1]) << 0));
    }

    @Override
    public byte[] toBytes(Object object) {
        if (object == null) {
            return null;
        }
        Character data = null;
        data = object.getClass().isAssignableFrom(String.class) ? Character.valueOf(((String)object).charAt(0)) : (Character)object;
        return new byte[]{(byte)(data.charValue() >> 8 & 0xFF), (byte)(data.charValue() >> 0 & 0xFF)};
    }

    @Override
    public String toString(Object object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    @Override
    public Character fromString(Class targetClass, String s) {
        try {
            if (s == null) {
                log.error("Can't convert String " + s + " to character");
                throw new PropertyAccessException("Can't convert String " + s + " to character");
            }
            Character c = null;
            c = s.length() == 1 ? Character.valueOf(s.charAt(0)) : Character.valueOf('\u0000');
            return c;
        }
        catch (NumberFormatException e) {
            log.error("Number format exception caught,Caused by {}.", (Throwable)e);
            throw new PropertyAccessException(e);
        }
    }

    @Override
    public Character getCopy(Object object) {
        return object != null ? new Character(((Character)object).charValue()) : null;
    }

    @Override
    public Character getInstance(Class<?> clazz) {
        return Character.valueOf('\uffff');
    }
}

