/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.property.accessor;

import com.impetus.kundera.property.PropertyAccessException;
import com.impetus.kundera.property.PropertyAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoubleAccessor
implements PropertyAccessor<Double> {
    private static final Logger log = LoggerFactory.getLogger(DoubleAccessor.class);

    @Override
    public Double fromBytes(Class targetClass, byte[] data) {
        if (data == null || data.length != 8) {
            return 0.0;
        }
        return Double.longBitsToDouble(this.toLong(data));
    }

    @Override
    public byte[] toBytes(Object object) throws PropertyAccessException {
        return object != null ? this.fromLong(Double.doubleToRawLongBits((Double)object)) : null;
    }

    @Override
    public String toString(Object object) {
        return object != null ? object.toString() : null;
    }

    private long toLong(byte[] data) {
        if (data == null || data.length != 8) {
            return 0L;
        }
        return (long)(0xFF & data[0]) << 56 | (long)(0xFF & data[1]) << 48 | (long)(0xFF & data[2]) << 40 | (long)(0xFF & data[3]) << 32 | (long)(0xFF & data[4]) << 24 | (long)(0xFF & data[5]) << 16 | (long)(0xFF & data[6]) << 8 | (long)(0xFF & data[7]) << 0;
    }

    private byte[] fromLong(long data) {
        return new byte[]{(byte)(data >> 56 & 0xFFL), (byte)(data >> 48 & 0xFFL), (byte)(data >> 40 & 0xFFL), (byte)(data >> 32 & 0xFFL), (byte)(data >> 24 & 0xFFL), (byte)(data >> 16 & 0xFFL), (byte)(data >> 8 & 0xFFL), (byte)(data >> 0 & 0xFFL)};
    }

    @Override
    public Double fromString(Class targetClass, String s) {
        try {
            if (s == null) {
                return null;
            }
            Double d = new Double(s);
            return d;
        }
        catch (NumberFormatException e) {
            log.error("Number format exception, Caused by {}.", (Throwable)e);
            throw new PropertyAccessException(e);
        }
    }

    @Override
    public Double getCopy(Object object) {
        return object != null ? new Double((Double)object) : null;
    }

    @Override
    public Double getInstance(Class<?> clazz) {
        return Double.MAX_VALUE;
    }
}

