/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.property.accessor;

import com.impetus.kundera.property.PropertyAccessException;
import com.impetus.kundera.property.PropertyAccessor;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumAccessor
implements PropertyAccessor<Enum> {
    private static final Logger log = LoggerFactory.getLogger(EnumAccessor.class);

    @Override
    public Enum fromBytes(Class targetClass, byte[] b) {
        String s = null;
        try {
            if (b == null) {
                return null;
            }
            s = new String(b, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("Unsupported encoding exception, Caused by {}.", (Throwable)e);
            throw new PropertyAccessException(e);
        }
        return this.fromString(targetClass, s);
    }

    @Override
    public byte[] toBytes(Object object) {
        if (object == null) {
            return null;
        }
        String s = this.toString(object);
        try {
            return s.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("Unsupported encoding exception, Caused by {}.", (Throwable)e);
            throw new PropertyAccessException(e);
        }
    }

    @Override
    public String toString(Object object) {
        if (object == null) {
            return null;
        }
        Enum en = (Enum)object;
        return en.name();
    }

    @Override
    public Enum fromString(Class targetClass, String string) {
        if (targetClass != null && string != null) {
            try {
                return Enum.valueOf(targetClass, string.trim());
            }
            catch (IllegalArgumentException ex) {
                log.error("Illegal argument exception, Caused by {}.", (Throwable)ex);
                throw new PropertyAccessException(ex);
            }
        }
        return null;
    }

    @Override
    public Enum getCopy(Object object) {
        if (object != null) {
            return this.fromString(object.getClass(), this.toString(object));
        }
        return null;
    }

    @Override
    public Enum getInstance(Class<?> clazz) {
        return null;
    }
}

