/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.property.accessor;

import com.impetus.kundera.property.PropertyAccessException;
import com.impetus.kundera.property.PropertyAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FloatAccessor
implements PropertyAccessor<Float> {
    private static final Logger log = LoggerFactory.getLogger(FloatAccessor.class);

    @Override
    public Float fromBytes(Class targetClass, byte[] data) {
        if (data == null || data.length != 4) {
            return Float.valueOf(0.0f);
        }
        return Float.valueOf(Float.intBitsToFloat(this.toInt(data)));
    }

    @Override
    public byte[] toBytes(Object object) {
        return object != null ? this.fromInt(Float.floatToRawIntBits(((Float)object).floatValue())) : null;
    }

    @Override
    public String toString(Object object) {
        return object != null ? object.toString() : null;
    }

    private byte[] fromInt(int data) {
        return new byte[]{(byte)(data >> 24 & 0xFF), (byte)(data >> 16 & 0xFF), (byte)(data >> 8 & 0xFF), (byte)(data >> 0 & 0xFF)};
    }

    private int toInt(byte[] data) {
        if (data == null || data.length != 4) {
            return 0;
        }
        return (0xFF & data[0]) << 24 | (0xFF & data[1]) << 16 | (0xFF & data[2]) << 8 | (0xFF & data[3]) << 0;
    }

    @Override
    public Float fromString(Class targetClass, String s) {
        try {
            if (s == null) {
                return null;
            }
            Float f = new Float(s);
            return f;
        }
        catch (NumberFormatException e) {
            log.error("Number format exception, Caused by {}.", (Throwable)e);
            throw new PropertyAccessException(e);
        }
    }

    @Override
    public Float getCopy(Object object) {
        return object != null ? (Float)object : null;
    }

    @Override
    public Float getInstance(Class<?> clazz) {
        return Float.valueOf(Float.MAX_VALUE);
    }
}

