/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.property.accessor;

import com.impetus.kundera.property.PropertyAccessException;
import com.impetus.kundera.property.PropertyAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegerAccessor
implements PropertyAccessor<Integer> {
    private static final Logger log = LoggerFactory.getLogger(IntegerAccessor.class);

    @Override
    public final Integer fromBytes(Class targetClass, byte[] b) {
        if (b == null) {
            return null;
        }
        return (b[0] << 24) + ((b[1] & 0xFF) << 16) + ((b[2] & 0xFF) << 8) + (b[3] & 0xFF);
    }

    @Override
    public final byte[] toBytes(Object val) {
        if (val != null) {
            Integer value = (Integer)val;
            return new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value.intValue()};
        }
        return null;
    }

    @Override
    public String toString(Object object) {
        return object != null ? object.toString() : null;
    }

    @Override
    public Integer fromString(Class targetClass, String s) {
        try {
            if (s == null) {
                return null;
            }
            Integer i = new Integer(s);
            return i;
        }
        catch (NumberFormatException e) {
            log.error("Number format exception, Caused by {}.", (Throwable)e);
            throw new PropertyAccessException(e);
        }
    }

    @Override
    public Integer getCopy(Object object) {
        return object != null ? (Integer)object : null;
    }

    @Override
    public Integer getInstance(Class<?> clazz) {
        return Integer.MAX_VALUE;
    }
}

