/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.property.accessor;

import com.impetus.kundera.property.PropertyAccessException;
import com.impetus.kundera.property.PropertyAccessor;
import com.impetus.kundera.property.accessor.LongAccessor;
import java.sql.Date;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLDateAccessor
implements PropertyAccessor<Date> {
    public static Logger log = LoggerFactory.getLogger(SQLDateAccessor.class);

    @Override
    public Date fromBytes(Class targetClass, byte[] b) {
        try {
            if (b == null) {
                return null;
            }
            LongAccessor longAccessor = new LongAccessor();
            return new Date(longAccessor.fromBytes(targetClass, b));
        }
        catch (Exception e) {
            log.error("Error occured, Caused by {}.", (Throwable)e);
            throw new PropertyAccessException(e);
        }
    }

    @Override
    public byte[] toBytes(Object object) {
        try {
            if (object == null) {
                return null;
            }
            LongAccessor longAccessor = new LongAccessor();
            return longAccessor.toBytes(((Date)object).getTime());
        }
        catch (Exception e) {
            log.error("Error occured, Caused by {}.", (Throwable)e);
            throw new PropertyAccessException(e);
        }
    }

    @Override
    public String toString(Object object) {
        Date date = (Date)object;
        if (date == null) {
            return null;
        }
        return String.valueOf(date.getTime());
    }

    @Override
    public Date fromString(Class targetClass, String s) {
        if (s == null) {
            return null;
        }
        if (StringUtils.isNumeric((String)s)) {
            return new Date(Long.parseLong(s));
        }
        Date d = Date.valueOf(s);
        return d;
    }

    @Override
    public Date getCopy(Object object) {
        Date d = (Date)object;
        return d != null ? new Date(d.getTime()) : null;
    }

    @Override
    public Date getInstance(Class<?> clazz) {
        return new Date(Integer.MAX_VALUE);
    }
}

