/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.property.accessor;

import com.impetus.kundera.property.PropertyAccessException;
import com.impetus.kundera.property.PropertyAccessor;
import com.impetus.kundera.property.accessor.LongAccessor;
import java.sql.Time;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLTimeAccessor
implements PropertyAccessor<Time> {
    public static Logger log = LoggerFactory.getLogger(SQLTimeAccessor.class);

    @Override
    public Time fromBytes(Class targetClass, byte[] b) {
        try {
            if (b == null) {
                return null;
            }
            LongAccessor longAccessor = new LongAccessor();
            return new Time(longAccessor.fromBytes(targetClass, b));
        }
        catch (Exception e) {
            log.error("Error occured, Caused by {}.", (Throwable)e);
            throw new PropertyAccessException(e);
        }
    }

    @Override
    public byte[] toBytes(Object object) {
        try {
            if (object == null) {
                return null;
            }
            LongAccessor longAccessor = new LongAccessor();
            return longAccessor.toBytes(((Time)object).getTime());
        }
        catch (Exception e) {
            log.error("Error occured, Caused by {}.", (Throwable)e);
            throw new PropertyAccessException(e);
        }
    }

    @Override
    public String toString(Object object) {
        Time time = (Time)object;
        if (time == null) {
            return null;
        }
        return String.valueOf(time.getTime());
    }

    @Override
    public Time fromString(Class targetClass, String s) {
        if (s == null) {
            return null;
        }
        if (StringUtils.isNumeric((String)s)) {
            return new Time(Long.parseLong(s));
        }
        Time t = Time.valueOf(s);
        return t;
    }

    @Override
    public Time getCopy(Object object) {
        Time t = (Time)object;
        return t != null ? new Time(t.getTime()) : null;
    }

    @Override
    public Time getInstance(Class<?> clazz) {
        return new Time(Integer.MAX_VALUE);
    }
}

