/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.property.accessor;

import com.impetus.kundera.property.PropertyAccessException;
import com.impetus.kundera.property.PropertyAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShortAccessor
implements PropertyAccessor<Short> {
    public static Logger log = LoggerFactory.getLogger(ShortAccessor.class);

    @Override
    public Short fromBytes(Class targetClass, byte[] data) {
        if (data == null || data.length != 2) {
            if (log.isWarnEnabled()) {
                log.warn("Bytes length not equal to 2");
            }
            return (short)0;
        }
        return (short)((0xFF & data[0]) << 8 | (0xFF & data[1]) << 0);
    }

    @Override
    public byte[] toBytes(Object object) {
        Short s = null;
        if (object != null) {
            s = object.getClass().isAssignableFrom(String.class) ? Short.valueOf(object.toString()) : (Short)object;
            return new byte[]{(byte)(s >> 8 & 0xFF), (byte)(s >> 0 & 0xFF)};
        }
        return null;
    }

    @Override
    public String toString(Object object) {
        return object != null ? object.toString() : null;
    }

    @Override
    public Short fromString(Class targetClass, String s) {
        try {
            if (s == null) {
                return null;
            }
            Short sh = new Short(s);
            return sh;
        }
        catch (NumberFormatException e) {
            log.error("Number format exception, Caused by {}.", (Throwable)e);
            throw new PropertyAccessException(e);
        }
    }

    @Override
    public Short getCopy(Object object) {
        return object != null ? (Short)object : null;
    }

    @Override
    public Short getInstance(Class<?> clazz) {
        return (short)Short.MAX_VALUE;
    }
}

