/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.proxy;

import com.impetus.kundera.proxy.KunderaProxy;
import com.impetus.kundera.proxy.collection.ProxyCollection;
import java.util.ArrayList;
import java.util.List;
import javassist.util.proxy.ProxyFactory;

public class ProxyHelper {
    static List<String> proxyTypes = new ArrayList<String>();
    static List<String> persistentCollectionTypes = new ArrayList<String>();

    public static boolean isKunderaProxy(Object o) {
        return o == null ? false : o instanceof KunderaProxy;
    }

    public static boolean isHibernateProxy(Object o) {
        return o == null ? false : proxyTypes.contains(o.getClass().getName());
    }

    public static boolean isKunderaProxyCollection(Object collection) {
        return collection == null ? false : collection instanceof ProxyCollection;
    }

    public static boolean isPersistentCollection(Object collection) {
        return collection == null ? false : persistentCollectionTypes.contains(collection.getClass().getName());
    }

    public static boolean isProxy(Object o) {
        return ProxyHelper.isKunderaProxy(o) || ProxyHelper.isHibernateProxy(o) || ProxyFactory.isProxyClass(o.getClass());
    }

    public static boolean isProxyCollection(Object o) {
        return ProxyHelper.isKunderaProxyCollection(o) || ProxyHelper.isPersistentCollection(o);
    }

    public static boolean isProxyOrCollection(Object o) {
        return ProxyHelper.isProxy(o) || ProxyHelper.isProxyCollection(o);
    }

    static {
        proxyTypes.add("org.hibernate.proxy.HibernateProxy");
        proxyTypes.add("org.hibernate.proxy.map.MapProxy");
        proxyTypes.add("org.hibernate.proxy.dom4j.Dom4jProxy");
        persistentCollectionTypes.add("org.hibernate.collection.spi.PersistentCollection");
        persistentCollectionTypes.add("org.hibernate.collection.internal.AbstractPersistentCollection");
        persistentCollectionTypes.add("org.hibernate.collection.internal.PersistentBag");
        persistentCollectionTypes.add("org.hibernate.collection.internal.PersistentList");
        persistentCollectionTypes.add("org.hibernate.collection.internal.PersistentSet");
        persistentCollectionTypes.add("org.hibernate.collection.internal.PersistentSortedSet");
        persistentCollectionTypes.add("org.hibernate.collection.internal.PersistentMap");
        persistentCollectionTypes.add("org.hibernate.collection.internal.PersistentSortedMap");
    }
}

