/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.proxy.collection;

import com.impetus.kundera.metadata.KunderaMetadataManager;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.Relation;
import com.impetus.kundera.persistence.PersistenceDelegator;
import com.impetus.kundera.property.PropertyAccessorHelper;
import com.impetus.kundera.proxy.LazyInitializationException;
import com.impetus.kundera.proxy.collection.ProxyCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractProxyBase
implements ProxyCollection {
    private PersistenceDelegator delegator;
    private Object owner;
    private Map<String, Object> relationsMap;
    private Relation relation;
    protected Object dataCollection;

    public AbstractProxyBase() {
    }

    public AbstractProxyBase(PersistenceDelegator delegator, Relation relation) {
        this.delegator = delegator;
        this.relation = relation;
    }

    @Override
    public Object getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(Object owner) {
        this.owner = owner;
    }

    @Override
    public PersistenceDelegator getPersistenceDelegator() {
        return this.delegator;
    }

    @Override
    public Map<String, Object> getRelationsMap() {
        return this.relationsMap;
    }

    @Override
    public void setRelationsMap(Map<String, Object> relationsMap) {
        this.relationsMap = relationsMap;
    }

    @Override
    public Relation getRelation() {
        return this.relation;
    }

    protected void eagerlyLoadDataCollection() {
        if (this.getDataCollection() == null || this.getDataCollection() instanceof ProxyCollection) {
            EntityMetadata m = KunderaMetadataManager.getEntityMetadata(this.getPersistenceDelegator().getKunderaMetadata(), this.getOwner().getClass());
            if (!this.getPersistenceDelegator().isOpen()) {
                throw new LazyInitializationException("Unable to load Proxy Collection. This happens when you access a lazily loaded proxy collection in an entity after entity manager has been closed.");
            }
            HashMap<Object, Object> relationStack = new HashMap<Object, Object>();
            this.getPersistenceDelegator().getClient(m).getReader().recursivelyFindEntities(this.getOwner(), this.relationsMap, m, this.getPersistenceDelegator(), true, relationStack);
            this.dataCollection = this.getRelation().getProperty().getType().isAssignableFrom(Map.class) ? (Map)PropertyAccessorHelper.getObject(this.getOwner(), this.getRelation().getProperty()) : (Collection)PropertyAccessorHelper.getObject(this.getOwner(), this.getRelation().getProperty());
            if (this.dataCollection instanceof ProxyCollection) {
                this.dataCollection = this.getRelation().getProperty().getType().isAssignableFrom(Set.class) ? new HashSet() : (this.getRelation().getProperty().getType().isAssignableFrom(List.class) ? new ArrayList() : null);
            }
            PropertyAccessorHelper.set(this.getOwner(), this.getRelation().getProperty(), this.dataCollection);
        }
    }
}

