/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.proxy.collection;

import com.impetus.kundera.metadata.model.Relation;
import com.impetus.kundera.persistence.PersistenceDelegator;
import com.impetus.kundera.property.PropertyAccessorHelper;
import com.impetus.kundera.proxy.collection.AbstractProxyBase;
import com.impetus.kundera.proxy.collection.ProxyCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class AbstractProxyCollection
extends AbstractProxyBase {
    public AbstractProxyCollection() {
    }

    public AbstractProxyCollection(PersistenceDelegator delegator, Relation relation) {
        super(delegator, relation);
    }

    @Override
    public Object getDataCollection() {
        return this.dataCollection != null ? this.dataCollection : null;
    }

    protected boolean add(Object object) {
        this.eagerlyLoadDataCollection();
        boolean result = false;
        if (this.dataCollection == null) {
            this.createEmptyDataCollection();
        }
        if (this.dataCollection != null && !(this.dataCollection instanceof ProxyCollection) && !((Collection)this.dataCollection).contains(object) && object != null) {
            ((Collection)this.dataCollection).add(object);
            PropertyAccessorHelper.set(this.getOwner(), this.getRelation().getProperty(), this.dataCollection);
            result = true;
        }
        return result;
    }

    protected void clear() {
        this.eagerlyLoadDataCollection();
        if (this.getDataCollection() != null && !(this.getDataCollection() instanceof ProxyCollection)) {
            ((Collection)this.getDataCollection()).clear();
        }
    }

    protected boolean contains(Object arg0) {
        boolean result = false;
        this.eagerlyLoadDataCollection();
        if (this.getDataCollection() != null && !(this.getDataCollection() instanceof ProxyCollection)) {
            result = ((Collection)this.getDataCollection()).contains(arg0);
        }
        return result;
    }

    protected boolean isEmpty() {
        boolean result = true;
        this.eagerlyLoadDataCollection();
        if (this.getDataCollection() != null && !(this.getDataCollection() instanceof ProxyCollection)) {
            result = ((Collection)this.getDataCollection()).isEmpty();
        }
        return result;
    }

    protected int size() {
        this.eagerlyLoadDataCollection();
        return this.dataCollection == null || this.dataCollection instanceof ProxyCollection ? 0 : ((Collection)this.dataCollection).size();
    }

    protected boolean addAll(Collection collection) {
        this.eagerlyLoadDataCollection();
        boolean result = false;
        if (this.dataCollection == null) {
            this.createEmptyDataCollection();
        }
        if (this.dataCollection != null && !(this.dataCollection instanceof ProxyCollection) && collection != null && !collection.isEmpty()) {
            ((Collection)this.dataCollection).addAll(collection);
            result = true;
        }
        return result;
    }

    protected boolean remove(Object object) {
        this.eagerlyLoadDataCollection();
        boolean result = false;
        if (this.dataCollection == null) {
            this.createEmptyDataCollection();
        }
        if (this.dataCollection != null && !(this.dataCollection instanceof ProxyCollection) && object != null) {
            ((Collection)this.dataCollection).remove(object);
            result = true;
        }
        return result;
    }

    protected boolean removeAll(Collection collection) {
        this.eagerlyLoadDataCollection();
        boolean result = false;
        if (this.dataCollection == null) {
            this.createEmptyDataCollection();
        }
        if (this.dataCollection != null && !(this.dataCollection instanceof ProxyCollection) && collection != null && !collection.isEmpty()) {
            ((Collection)this.dataCollection).removeAll(collection);
            result = true;
        }
        return result;
    }

    protected boolean containsAll(Collection arg0) {
        this.eagerlyLoadDataCollection();
        boolean result = false;
        if (this.dataCollection == null) {
            this.createEmptyDataCollection();
        }
        if (this.getDataCollection() != null && !(this.dataCollection instanceof ProxyCollection) && arg0 != null && !arg0.isEmpty()) {
            result = ((Collection)this.getDataCollection()).containsAll(arg0);
        }
        return result;
    }

    protected boolean retainAll(Collection collection) {
        boolean result = false;
        this.eagerlyLoadDataCollection();
        if (this.dataCollection == null) {
            this.createEmptyDataCollection();
        }
        if (this.dataCollection != null && !(this.dataCollection instanceof ProxyCollection) && collection != null && !collection.isEmpty()) {
            result = ((Collection)this.dataCollection).retainAll(collection);
        }
        return result;
    }

    protected Iterator iterator() {
        this.eagerlyLoadDataCollection();
        Iterator result = null;
        if (this.getDataCollection() != null && !(this.getDataCollection() instanceof ProxyCollection)) {
            result = ((Collection)this.getDataCollection()).iterator();
        }
        return result;
    }

    protected Object[] toArray() {
        this.eagerlyLoadDataCollection();
        return this.dataCollection == null ? new Object[]{} : ((Collection)this.dataCollection).toArray();
    }

    protected Object[] toArray(Object[] arg0) {
        this.eagerlyLoadDataCollection();
        return this.dataCollection == null ? new Object[]{} : ((Collection)this.dataCollection).toArray(arg0);
    }

    private void createEmptyDataCollection() {
        Class collectionClass = this.getRelation().getProperty().getType();
        if (collectionClass.isAssignableFrom(Set.class)) {
            this.dataCollection = new HashSet();
        } else if (collectionClass.isAssignableFrom(List.class)) {
            this.dataCollection = new ArrayList();
        }
    }
}

