/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.query;

import com.impetus.kundera.KunderaException;
import com.impetus.kundera.metadata.KunderaMetadataManager;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.MetamodelImpl;
import com.impetus.kundera.metadata.model.type.AbstractManagedType;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import com.impetus.kundera.query.JPQLParseException;
import com.impetus.kundera.query.KunderaQueryUtils;
import com.impetus.kundera.query.QueryHandlerException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.StringTokenizer;
import javax.el.ExpressionFactory;
import javax.persistence.Parameter;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.eclipse.persistence.jpa.jpql.parser.DeleteStatement;
import org.eclipse.persistence.jpa.jpql.parser.EclipseLinkJPQLGrammar2_4;
import org.eclipse.persistence.jpa.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.jpql.parser.JPQLGrammar;
import org.eclipse.persistence.jpa.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.UpdateStatement;
import org.eclipse.persistence.jpa.jpql.parser.WhereClause;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KunderaQuery {
    public static final String[] SINGLE_STRING_KEYWORDS = new String[]{"SELECT", "UPDATE", "SET", "DELETE", "UNIQUE", "FROM", "WHERE", "GROUP BY", "HAVING", "ORDER BY"};
    public static final String[] INTER_CLAUSE_OPERATORS = new String[]{"AND", "OR", "BETWEEN", "(", ")"};
    public static final String[] INTRA_CLAUSE_OPERATORS = new String[]{"=", "LIKE", "IN", ">", ">=", "<", "<=", "<>", "NOT IN"};
    private static Logger logger = LoggerFactory.getLogger(KunderaQuery.class);
    private String[] result;
    private String[] aggregationResult;
    private String from;
    private String filter;
    private String ordering;
    private String entityName;
    private String entityAlias;
    private Class<?> entityClass;
    private List<SortOrdering> sortOrders;
    private boolean isAggregate;
    private String persistenceUnit;
    private Queue filtersQueue = new LinkedList();
    private boolean isDeleteUpdate;
    private Queue<UpdateClause> updateClauseQueue = new LinkedList<UpdateClause>();
    private TypedParameter typedParameter;
    private Map<String, Object> parametersMap = new HashMap<String, Object>();
    boolean isNativeQuery;
    private String jpaQuery;
    private final EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata;
    private JPQLExpression jpqlExpression;
    private ExpressionFactory expressionFactory;
    private SelectStatement selectStatement;
    private UpdateStatement updateStatement;
    private DeleteStatement deleteStatement;

    public void setExpressionFactory(ExpressionFactory expressionFactory) {
        this.expressionFactory = expressionFactory;
    }

    public JPQLExpression getJpqlExpression() {
        return this.jpqlExpression;
    }

    public KunderaQuery(String jpaQuery, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        this.jpaQuery = jpaQuery;
        this.kunderaMetadata = kunderaMetadata;
        this.initiateJPQLObject(jpaQuery);
    }

    private void initiateJPQLObject(String jpaQuery) {
        JPQLGrammar jpqlGrammar = EclipseLinkJPQLGrammar2_4.instance();
        this.jpqlExpression = new JPQLExpression((CharSequence)jpaQuery, jpqlGrammar, "ql_statement", true);
        this.setKunderaQueryTypeObject();
    }

    private void setKunderaQueryTypeObject() {
        try {
            if (this.isSelectStatement()) {
                this.setSelectStatement((SelectStatement)this.getJpqlExpression().getQueryStatement());
            } else if (this.isUpdateStatement()) {
                this.setUpdateStatement((UpdateStatement)this.getJpqlExpression().getQueryStatement());
            } else if (this.isDeleteStatement()) {
                this.setDeleteStatement((DeleteStatement)this.getJpqlExpression().getQueryStatement());
            }
        }
        catch (ClassCastException cce) {
            throw new JPQLParseException("Bad query format : " + cce.getMessage());
        }
    }

    public SelectStatement getSelectStatement() {
        return this.selectStatement;
    }

    public void setSelectStatement(SelectStatement selectStatement) {
        this.selectStatement = selectStatement;
    }

    public void setUpdateStatement(UpdateStatement updateStatement) {
        this.updateStatement = updateStatement;
    }

    public UpdateStatement getUpdateStatement() {
        return this.updateStatement;
    }

    public DeleteStatement getDeleteStatement() {
        return this.deleteStatement;
    }

    public void setDeleteStatement(DeleteStatement deleteStatement) {
        this.deleteStatement = deleteStatement;
    }

    public boolean isSelectStatement() {
        return this.getJpqlExpression().getQueryStatement().getClass().isAssignableFrom(SelectStatement.class);
    }

    public boolean isDeleteStatement() {
        return this.getJpqlExpression().getQueryStatement().getClass().isAssignableFrom(DeleteStatement.class);
    }

    public boolean isUpdateStatement() {
        return this.getJpqlExpression().getQueryStatement().getClass().isAssignableFrom(UpdateStatement.class);
    }

    public ExpressionFactory getExpressionFactory() {
        return this.expressionFactory;
    }

    public void setGrouping(String groupingClause) {
    }

    public final void setResult(String[] result) {
        this.result = result;
    }

    public final void setAggregationResult(String[] aggResult) {
        this.aggregationResult = aggResult;
    }

    public final String[] getAggResult() {
        return this.aggregationResult;
    }

    public boolean isAggregated() {
        return this.isAggregate;
    }

    public void setAggregated(boolean isAggregated) {
        this.isAggregate = isAggregated;
    }

    public final void setFrom(String from) {
        this.from = from;
    }

    public final void setFilter(String filter) {
        this.filter = filter;
    }

    public final void setOrdering(String ordering) {
        this.ordering = ordering;
        this.parseOrdering(this.ordering);
    }

    public final String getFilter() {
        return this.filter;
    }

    public final String getFrom() {
        return this.from;
    }

    public final List<SortOrdering> getOrdering() {
        return this.sortOrders;
    }

    public final String[] getResult() {
        return this.result;
    }

    public Map<String, Object> getParametersMap() {
        return this.parametersMap;
    }

    public final boolean isAliasOnly() {
        return this.result != null && this.result[0].indexOf(".") == -1;
    }

    public Set<Parameter<?>> getParameters() {
        return this.typedParameter != null ? this.typedParameter.jpaParameters : null;
    }

    public boolean isBound(Parameter param) {
        return this.getClauseValue(param) != null;
    }

    public List<Object> getClauseValue(String paramString) {
        if (this.typedParameter != null && this.typedParameter.getParameters() != null) {
            List<FilterClause> clauses = this.typedParameter.getParameters().get(paramString);
            if (clauses != null) {
                return clauses.get(0).getValue();
            }
            throw new IllegalArgumentException("parameter is not a parameter of the query");
        }
        logger.error("Parameter {} is not a parameter of the query.", (Object)paramString);
        throw new IllegalArgumentException("Parameter is not a parameter of the query.");
    }

    public List<Object> getClauseValue(Parameter param) {
        Parameter match = null;
        if (this.typedParameter != null && this.typedParameter.jpaParameters != null) {
            for (Parameter p : this.typedParameter.jpaParameters) {
                if (!p.equals(param)) continue;
                match = p;
                if (this.typedParameter.getType().equals((Object)Type.NAMED)) {
                    List<FilterClause> clauses = this.typedParameter.getParameters().get(":" + p.getName());
                    if (clauses == null) break;
                    return clauses.get(0).getValue();
                }
                List<FilterClause> clauses = this.typedParameter.getParameters().get("?" + p.getPosition());
                if (clauses != null) {
                    return clauses.get(0).getValue();
                }
                UpdateClause updateClause = this.typedParameter.getUpdateParameters().get("?" + p.getPosition());
                if (updateClause == null) break;
                ArrayList<Object> value = new ArrayList<Object>();
                value.add(updateClause.getValue());
                return value;
            }
            if (match == null) {
                throw new IllegalArgumentException("parameter is not a parameter of the query");
            }
        }
        logger.error("parameter{} is not a parameter of the query", (Object)param);
        throw new IllegalArgumentException("parameter is not a parameter of the query");
    }

    protected void postParsingInit() {
        this.initEntityClass();
        this.initFilter();
        this.initUpdateClause();
    }

    private void initUpdateClause() {
        for (UpdateClause updateClause : this.updateClauseQueue) {
            this.onTypedParameter(updateClause.getValue(), updateClause, updateClause.getProperty().trim());
        }
    }

    private void initEntityClass() {
        if (this.from == null) {
            throw new JPQLParseException("Bad query format FROM clause is mandatory for SELECT queries");
        }
        String[] fromArray = this.from.split(" ");
        if (!this.isDeleteUpdate) {
            if (fromArray.length != 2) {
                throw new JPQLParseException("Bad query format: " + this.from + ". Identification variable is mandatory in FROM clause for SELECT queries");
            }
            StringTokenizer tokenizer = new StringTokenizer(this.result[0], ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (StringUtils.containsAny((String)(fromArray[1] + "."), (String)token)) continue;
                throw new QueryHandlerException("bad query format with invalid alias:" + token);
            }
        }
        this.entityName = fromArray[0];
        if (fromArray.length == 2) {
            this.entityAlias = fromArray[1];
        }
        this.persistenceUnit = this.kunderaMetadata.getApplicationMetadata().getMappedPersistenceUnit(this.entityName);
        MetamodelImpl model = this.getMetamodel(this.persistenceUnit);
        if (model != null) {
            this.entityClass = model.getEntityClass(this.entityName);
        }
        if (null == this.entityClass) {
            logger.error("No entity {} found, please verify it is properly annotated with @Entity and not a mapped Super class", (Object)this.entityName);
            throw new QueryHandlerException("No entity found by the name: " + this.entityName);
        }
        EntityMetadata metadata = model.getEntityMetadata(this.entityClass);
        if (metadata != null && !metadata.isIndexable()) {
            throw new QueryHandlerException(this.entityClass + " is not indexed. Not possible to run a query on it." + " Check whether it was properly annotated for indexing.");
        }
    }

    private void initFilter() {
        EntityMetadata metadata = KunderaMetadataManager.getEntityMetadata(this.kunderaMetadata, this.entityClass);
        Metamodel metaModel = this.kunderaMetadata.getApplicationMetadata().getMetamodel(this.getPersistenceUnit());
        EntityType entityType = metaModel.entity(this.entityClass);
        if (null == this.filter) {
            ArrayList<String> clauses = new ArrayList<String>();
            this.addDiscriminatorClause(clauses, entityType);
            return;
        }
        WhereClause whereClause = KunderaQueryUtils.getWhereClause(this.getJpqlExpression());
        KunderaQueryUtils.traverse(whereClause.getConditionalExpression(), metadata, this.kunderaMetadata, this, false);
        for (Object filterClause : this.filtersQueue) {
            if (filterClause instanceof String) continue;
            this.onTypedParameter((FilterClause)filterClause);
        }
        this.addDiscriminatorClause(null, entityType);
    }

    private void addDiscriminatorClause(List<String> clauses, EntityType entityType) {
        if (((AbstractManagedType)entityType).isInherited()) {
            String discrColumn = ((AbstractManagedType)entityType).getDiscriminatorColumn();
            String discrValue = ((AbstractManagedType)entityType).getDiscriminatorValue();
            if (discrColumn != null && discrValue != null) {
                if (clauses != null && !clauses.isEmpty()) {
                    this.filtersQueue.add("AND");
                }
                FilterClause filterClause = new FilterClause(discrColumn, "=", discrValue, discrColumn);
                this.filtersQueue.add(filterClause);
            }
        }
    }

    private void onTypedParameter(Object value, UpdateClause updateClause, String fieldName) {
        String token = value.toString();
        if (token != null && token.startsWith(":")) {
            this.addTypedParameter(Type.NAMED, token, updateClause);
            this.filterJPAParameterInfo(Type.NAMED, token.substring(1), fieldName);
        } else if (token != null && token.startsWith("?")) {
            this.addTypedParameter(Type.INDEXED, token, updateClause);
            this.filterJPAParameterInfo(Type.INDEXED, token.substring(1), fieldName);
        }
    }

    private void onTypedParameter(FilterClause filterClause) {
        if (filterClause.value != null && filterClause.value.get(0).toString().startsWith(":")) {
            this.addTypedParameter(Type.NAMED, filterClause.value.get(0).toString(), filterClause);
            this.filterJPAParameterInfo(Type.NAMED, filterClause.value.get(0).toString().substring(1), filterClause.fieldName);
        } else if (filterClause.value.toString() != null && filterClause.value.get(0).toString().startsWith("?")) {
            this.addTypedParameter(Type.INDEXED, filterClause.value.get(0).toString(), filterClause);
            this.filterJPAParameterInfo(Type.INDEXED, filterClause.value.get(0).toString().substring(1), filterClause.fieldName);
        }
    }

    private void addTypedParameter(Type type, String parameter, FilterClause clause) {
        if (this.typedParameter == null) {
            this.typedParameter = new TypedParameter(type);
        }
        if (this.typedParameter.getType().equals((Object)type)) {
            this.typedParameter.addParameters(parameter, clause);
        } else {
            logger.warn("Invalid type provided, it can either be name or indexes!");
        }
    }

    private void addTypedParameter(Type type, String parameter, UpdateClause clause) {
        if (type != null) {
            if (this.typedParameter == null) {
                this.typedParameter = new TypedParameter(type);
            }
            if (this.typedParameter.getType().equals((Object)type)) {
                this.typedParameter.addParameters(parameter, clause);
            } else {
                logger.warn("Invalid type provided, it can either be name or indexes!");
            }
        }
    }

    private void filterJPAParameterInfo(Type type, String name, String fieldName) {
        String attributeName = this.getAttributeName(fieldName);
        Attribute entityAttribute = ((MetamodelImpl)this.kunderaMetadata.getApplicationMetadata().getMetamodel(this.persistenceUnit)).getEntityAttribute(this.entityClass, attributeName);
        Class fieldType = entityAttribute.getJavaType();
        if (type.equals((Object)Type.INDEXED)) {
            this.typedParameter.addJPAParameter(new JPAParameter(null, Integer.valueOf(name), fieldType));
        } else {
            this.typedParameter.addJPAParameter(new JPAParameter(name, null, fieldType));
        }
    }

    private String getAttributeName(String fieldName) {
        String attributeName = fieldName;
        if (fieldName.indexOf(".") != -1) {
            attributeName = fieldName.substring(0, fieldName.indexOf("."));
        }
        return attributeName;
    }

    public final void setParameter(String name, Object value) {
        this.setParameterValue(":" + name, value);
        this.parametersMap.put(":" + name, value);
    }

    public final void setParameter(int position, Object value) {
        this.setParameterValue("?" + position, value);
        this.parametersMap.put("?" + position, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setParameterValue(String name, Object value) {
        List<FilterClause> clauses;
        if (this.typedParameter == null) throw new QueryHandlerException("No named parameter present for query");
        List<FilterClause> list = clauses = this.typedParameter.getParameters() != null ? this.typedParameter.getParameters().get(name) : null;
        if (clauses != null) {
            for (FilterClause clause : clauses) {
                clause.setValue(value);
            }
            return;
        } else if (this.typedParameter.getUpdateParameters() != null) {
            UpdateClause updateClause = this.typedParameter.getUpdateParameters().get(name);
            updateClause.setValue(value);
            return;
        } else {
            logger.error("Error while setting parameter.");
            throw new QueryHandlerException("named parameter : " + name + " not found!");
        }
    }

    public final Class getEntityClass() {
        return this.entityClass;
    }

    public final String getEntityAlias() {
        return this.entityAlias;
    }

    public boolean isNative() {
        return this.isNativeQuery;
    }

    public final EntityMetadata getEntityMetadata() {
        EntityMetadata metadata = null;
        try {
            metadata = KunderaMetadataManager.getEntityMetadata(this.kunderaMetadata, this.entityClass);
        }
        catch (KunderaException e) {
            logger.info("No Entity class provided, Proceeding as Scalar Query");
        }
        if (!this.isNativeQuery && metadata == null) {
            throw new KunderaException("Unable to load entity metadata for : " + this.entityClass);
        }
        return metadata;
    }

    public final Queue getFilterClauseQueue() {
        return this.filtersQueue;
    }

    public final Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("KunderaQuery [entityName=");
        builder.append(this.entityName);
        builder.append(", entityAlias=");
        builder.append(this.entityAlias);
        builder.append(", filtersQueue=");
        builder.append(this.filtersQueue);
        builder.append("]");
        return builder.toString();
    }

    private MetamodelImpl getMetamodel(String pu) {
        return KunderaMetadataManager.getMetamodel(this.kunderaMetadata, pu);
    }

    public String getPersistenceUnit() {
        return this.persistenceUnit;
    }

    public void setPersistenceUnit(String persistenceUnit) {
        this.persistenceUnit = persistenceUnit;
    }

    private void parseOrdering(String ordering) {
        String comma = ",";
        String space = " ";
        StringTokenizer tokenizer = new StringTokenizer(ordering, ",");
        this.sortOrders = new ArrayList<SortOrdering>();
        while (tokenizer.hasMoreTokens()) {
            String order = (String)tokenizer.nextElement();
            StringTokenizer token = new StringTokenizer(order, " ");
            SortOrder orderType = SortOrder.ASC;
            String colName = (String)token.nextElement();
            while (token.hasMoreElements()) {
                String nextOrder = (String)token.nextElement();
                if (!StringUtils.isNotBlank((String)nextOrder)) continue;
                try {
                    orderType = SortOrder.valueOf(nextOrder);
                }
                catch (IllegalArgumentException e) {
                    logger.error("Error while parsing order by clause:");
                    throw new JPQLParseException("Invalid sort order provided:" + nextOrder);
                }
            }
            this.sortOrders.add(new SortOrdering(colName, orderType));
        }
    }

    public Queue<UpdateClause> getUpdateClauseQueue() {
        return this.updateClauseQueue;
    }

    public boolean isUpdateClause() {
        return !this.updateClauseQueue.isEmpty();
    }

    public void addUpdateClause(String property, String value) {
        UpdateClause updateClause = new UpdateClause(property.trim(), value.trim());
        this.updateClauseQueue.add(updateClause);
        this.addTypedParameter(value.trim().startsWith("?") ? Type.INDEXED : (value.trim().startsWith(":") ? Type.NAMED : null), property, updateClause);
    }

    public void addFilterClause(String property, String condition2, Object value, String fieldName) {
        if (property != null && condition2 != null) {
            FilterClause filterClause = new FilterClause(property.trim(), condition2.trim(), value, fieldName);
            this.filtersQueue.add(filterClause);
        } else {
            this.filtersQueue.add(property);
        }
    }

    public void addFilterClause(Object filterClause) {
        this.filtersQueue.add(filterClause);
    }

    public void setIsDeleteUpdate(boolean b) {
        this.isDeleteUpdate = b;
    }

    public boolean isDeleteUpdate() {
        return this.isDeleteUpdate;
    }

    public String getJPAQuery() {
        return this.jpaQuery;
    }

    private static Object getValue(Object value) {
        if (value != null && value.getClass().isAssignableFrom(String.class)) {
            return ((String)value).replaceAll("^'", "").replaceAll("'$", "").replaceAll("''", "'");
        }
        return value;
    }

    private class JPAParameter<T>
    implements Parameter<T> {
        private String name;
        private Integer position;
        private Class<T> type;

        JPAParameter(String name, Integer position, Class<T> type) {
            this.name = name;
            this.position = position;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public Integer getPosition() {
            return this.position;
        }

        public Class<T> getParameterType() {
            return this.type;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!obj.getClass().equals(this.getClass())) {
                return false;
            }
            Parameter typed = (Parameter)obj;
            if (typed.getParameterType().equals(this.getParameterType())) {
                if (this.getName() == null && typed.getName() == null) {
                    return this.getPosition() != null && this.getPosition().equals(typed.getPosition());
                }
                return this.getName() != null && this.getName().equals(typed.getName());
            }
            return false;
        }

        public String toString() {
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.append("[ name = " + this.getName() + "]");
            strBuilder.append("[ position = " + this.getPosition() + "]");
            strBuilder.append("[ type = " + this.getParameterType() + "]");
            return strBuilder.toString();
        }
    }

    private static enum Type {
        INDEXED,
        NAMED;

    }

    private class TypedParameter {
        private Type type;
        private Set<Parameter<?>> jpaParameters = new HashSet();
        private Map<String, List<FilterClause>> parameters;
        private Map<String, UpdateClause> updateParameters;

        public TypedParameter(Type type) {
            this.type = type;
        }

        private Type getType() {
            return this.type;
        }

        Map<String, List<FilterClause>> getParameters() {
            return this.parameters;
        }

        Map<String, UpdateClause> getUpdateParameters() {
            return this.updateParameters;
        }

        void addParameters(String key, FilterClause clause) {
            if (this.parameters == null) {
                this.parameters = new HashMap<String, List<FilterClause>>();
            }
            if (!this.parameters.containsKey(key)) {
                this.parameters.put(key, new ArrayList());
            }
            this.parameters.get(key).add(clause);
        }

        void addParameters(String key, UpdateClause clause) {
            if (this.updateParameters == null) {
                this.updateParameters = new HashMap<String, UpdateClause>();
            }
            this.updateParameters.put(key, clause);
        }

        void addJPAParameter(Parameter param) {
            this.jpaParameters.add(param);
        }
    }

    public static enum SortOrder {
        ASC,
        DESC;

    }

    public class SortOrdering {
        String columnName;
        SortOrder order;

        public SortOrdering(String columnName, SortOrder order) {
            this.columnName = columnName;
            this.order = order;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public SortOrder getOrder() {
            return this.order;
        }
    }

    public final class UpdateClause {
        private String property;
        private Object value;

        public UpdateClause(String property, Object value) {
            this.property = property;
            this.value = KunderaQuery.getValue(value);
        }

        public String getProperty() {
            return this.property;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = KunderaQuery.getValue(value);
        }
    }

    public final class FilterClause {
        private String property;
        private String condition;
        private String fieldName;
        private List<Object> value = new ArrayList<Object>();

        public String getFieldName() {
            return this.fieldName;
        }

        public FilterClause(String property, String condition2, Object value, String fieldName) {
            this.property = property;
            this.condition = condition2.trim();
            this.fieldName = fieldName;
            if (value instanceof Collection) {
                for (Object valueObject : (Collection)value) {
                    this.value.add(KunderaQuery.getValue(valueObject));
                }
            } else {
                this.value.add(KunderaQuery.getValue(value));
            }
        }

        public final String getProperty() {
            return this.property;
        }

        public final String getCondition() {
            return this.condition;
        }

        public final List<Object> getValue() {
            return this.value;
        }

        protected void setValue(Object value) {
            ArrayList<Object> valObjects = new ArrayList<Object>();
            if (value instanceof Collection) {
                for (Object valueObject : (Collection)value) {
                    valObjects.add(KunderaQuery.getValue(valueObject));
                }
            } else {
                valObjects.add(KunderaQuery.getValue(value));
            }
            this.value = valObjects;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("FilterClause [property=");
            builder.append(this.property);
            builder.append(", condition=");
            builder.append(this.condition);
            builder.append(", value=");
            builder.append(this.value);
            builder.append(", fieldName=");
            builder.append(this.fieldName);
            builder.append("]");
            return builder.toString();
        }
    }
}

