/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.query;

import com.impetus.kundera.KunderaException;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.MetamodelImpl;
import com.impetus.kundera.metadata.model.attributes.AbstractAttribute;
import com.impetus.kundera.metadata.model.type.AbstractManagedType;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import com.impetus.kundera.property.PropertyAccessorFactory;
import com.impetus.kundera.query.KunderaQuery;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import org.eclipse.persistence.jpa.jpql.parser.AggregateFunction;
import org.eclipse.persistence.jpa.jpql.parser.BetweenExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.ComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.DeleteStatement;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.InExpression;
import org.eclipse.persistence.jpa.jpql.parser.InputParameter;
import org.eclipse.persistence.jpa.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.jpql.parser.KeywordExpression;
import org.eclipse.persistence.jpa.jpql.parser.LikeExpression;
import org.eclipse.persistence.jpa.jpql.parser.LogicalExpression;
import org.eclipse.persistence.jpa.jpql.parser.NumericLiteral;
import org.eclipse.persistence.jpa.jpql.parser.OrderByClause;
import org.eclipse.persistence.jpa.jpql.parser.OrderByItem;
import org.eclipse.persistence.jpa.jpql.parser.RegexpExpression;
import org.eclipse.persistence.jpa.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.StringLiteral;
import org.eclipse.persistence.jpa.jpql.parser.SubExpression;
import org.eclipse.persistence.jpa.jpql.parser.UpdateStatement;
import org.eclipse.persistence.jpa.jpql.parser.WhereClause;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KunderaQueryUtils {
    private static Logger logger = LoggerFactory.getLogger(KunderaQueryUtils.class);

    public static WhereClause getWhereClause(JPQLExpression jpqlExpression) {
        WhereClause whereClause = null;
        if (KunderaQueryUtils.hasWhereClause(jpqlExpression)) {
            if (KunderaQueryUtils.isSelectStatement(jpqlExpression)) {
                whereClause = (WhereClause)((SelectStatement)jpqlExpression.getQueryStatement()).getWhereClause();
            } else if (KunderaQueryUtils.isUpdateStatement(jpqlExpression)) {
                whereClause = (WhereClause)((UpdateStatement)jpqlExpression.getQueryStatement()).getWhereClause();
            }
            if (KunderaQueryUtils.isDeleteStatement(jpqlExpression)) {
                whereClause = (WhereClause)((DeleteStatement)jpqlExpression.getQueryStatement()).getWhereClause();
            }
        }
        return whereClause;
    }

    public static OrderByClause getOrderByClause(JPQLExpression jpqlExpression) {
        OrderByClause orderByClause = null;
        if (KunderaQueryUtils.hasOrderBy(jpqlExpression)) {
            orderByClause = (OrderByClause)((SelectStatement)jpqlExpression.getQueryStatement()).getOrderByClause();
        }
        return orderByClause;
    }

    public static boolean hasWhereClause(JPQLExpression jpqlExpression) {
        if (KunderaQueryUtils.isSelectStatement(jpqlExpression)) {
            return ((SelectStatement)jpqlExpression.getQueryStatement()).hasWhereClause();
        }
        if (KunderaQueryUtils.isUpdateStatement(jpqlExpression)) {
            return ((UpdateStatement)jpqlExpression.getQueryStatement()).hasWhereClause();
        }
        if (KunderaQueryUtils.isDeleteStatement(jpqlExpression)) {
            return ((DeleteStatement)jpqlExpression.getQueryStatement()).hasWhereClause();
        }
        return false;
    }

    public static boolean hasGroupBy(JPQLExpression jpqlExpression) {
        if (KunderaQueryUtils.isSelectStatement(jpqlExpression)) {
            return ((SelectStatement)jpqlExpression.getQueryStatement()).hasGroupByClause();
        }
        return false;
    }

    public static boolean hasHaving(JPQLExpression jpqlExpression) {
        if (KunderaQueryUtils.isSelectStatement(jpqlExpression)) {
            return ((SelectStatement)jpqlExpression.getQueryStatement()).hasHavingClause();
        }
        return false;
    }

    public static boolean hasOrderBy(JPQLExpression jpqlExpression) {
        if (KunderaQueryUtils.isSelectStatement(jpqlExpression)) {
            return ((SelectStatement)jpqlExpression.getQueryStatement()).hasOrderByClause();
        }
        return false;
    }

    public static boolean isSelectStatement(JPQLExpression jpqlExpression) {
        return jpqlExpression.getQueryStatement().getClass().isAssignableFrom(SelectStatement.class);
    }

    public static boolean isDeleteStatement(JPQLExpression jpqlExpression) {
        return jpqlExpression.getQueryStatement().getClass().isAssignableFrom(DeleteStatement.class);
    }

    public static boolean isUpdateStatement(JPQLExpression jpqlExpression) {
        return jpqlExpression.getQueryStatement().getClass().isAssignableFrom(UpdateStatement.class);
    }

    public static boolean isAggregatedExpression(Expression expression) {
        return AggregateFunction.class.isAssignableFrom(expression.getClass());
    }

    public static Object getValue(Expression exp, Class clazz, KunderaQuery kunderaQuery) {
        if (StringLiteral.class.isAssignableFrom(exp.getClass())) {
            return ((StringLiteral)exp).getUnquotedText();
        }
        if (NumericLiteral.class.isAssignableFrom(exp.getClass())) {
            return PropertyAccessorFactory.getPropertyAccessor(clazz).fromString(clazz, ((NumericLiteral)exp).getText());
        }
        if (InputParameter.class.isAssignableFrom(exp.getClass())) {
            InputParameter ip = (InputParameter)exp;
            if (kunderaQuery.getParametersMap().containsKey(ip.getParameter())) {
                return kunderaQuery.getParametersMap().get(ip.getParameter());
            }
            return ip.getParameter();
        }
        if (KeywordExpression.class.isAssignableFrom(exp.getClass())) {
            KeywordExpression keyWordExp = (KeywordExpression)exp;
            return PropertyAccessorFactory.getPropertyAccessor(clazz).fromString(clazz, keyWordExp.getActualIdentifier());
        }
        if (IdentificationVariable.class.isAssignableFrom(exp.getClass())) {
            IdentificationVariable idvExp = (IdentificationVariable)exp;
            return idvExp.getText();
        }
        logger.warn("Arithmetic expression is not supported ");
        throw new KunderaException("Arithmetic expression is not supported currently");
    }

    private static void addToOutputColumns(Expression selectExpression, EntityMetadata m, List<Map<String, Object>> columnsToOutput, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        Map<String, Object> map = KunderaQueryUtils.setFieldClazzAndColumnFamily(selectExpression, m, kunderaMetadata);
        columnsToOutput.add(map);
    }

    public static List<Map<String, Object>> readSelectClause(Expression selectExpression, EntityMetadata m, Boolean useLuceneOrES, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        ArrayList<Map<String, Object>> columnsToOutput = new ArrayList<Map<String, Object>>();
        if (StateFieldPathExpression.class.isAssignableFrom(selectExpression.getClass())) {
            StateFieldPathExpression sfpExp = (StateFieldPathExpression)selectExpression;
            KunderaQueryUtils.addToOutputColumns(selectExpression, m, columnsToOutput, kunderaMetadata);
        } else if (CollectionExpression.class.isAssignableFrom(selectExpression.getClass())) {
            CollectionExpression collExp = (CollectionExpression)selectExpression;
            for (Expression exp : collExp.children()) {
                if (!StateFieldPathExpression.class.isAssignableFrom(exp.getClass())) continue;
                KunderaQueryUtils.addToOutputColumns(exp, m, columnsToOutput, kunderaMetadata);
            }
        }
        return columnsToOutput;
    }

    public static Map<String, Object> setFieldClazzAndColumnFamily(Expression expression, EntityMetadata m, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        StateFieldPathExpression sfpExp = (StateFieldPathExpression)expression;
        MetamodelImpl metaModel = (MetamodelImpl)kunderaMetadata.getApplicationMetadata().getMetamodel(m.getPersistenceUnit());
        EntityType<?> entity = metaModel.entity(m.getEntityClazz());
        String discriminatorColumn = ((AbstractManagedType)entity).getDiscriminatorColumn();
        Class fieldClazz = String.class;
        String colFamily = m.getTableName();
        String colName = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean isEmbeddable = false;
        int count = 1;
        String fieldName = sfpExp.getPath(count++);
        AbstractAttribute attrib = (AbstractAttribute)entity.getAttribute(fieldName);
        String dbColName = attrib.getJPAColumnName();
        isEmbeddable = metaModel.isEmbeddable(attrib.getBindableJavaType());
        while (sfpExp.pathSize() > count) {
            if (isEmbeddable) {
                EmbeddableType embeddableType = metaModel.embeddable(attrib.getBindableJavaType());
                String attName = sfpExp.getPath(count++);
                fieldName = fieldName + "." + attName;
                attrib = (AbstractAttribute)embeddableType.getAttribute(attName);
                isEmbeddable = metaModel.isEmbeddable(attrib.getBindableJavaType());
                dbColName = dbColName + "." + attrib.getJPAColumnName();
            }
            colName = fieldName;
        }
        if (!sfpExp.getPath(count - 1).equals(discriminatorColumn)) {
            fieldClazz = attrib.getBindableJavaType();
            colFamily = attrib.getTableName() != null ? attrib.getTableName() : m.getTableName();
            colName = colName != null ? colName : attrib.getJPAColumnName();
        }
        map.put("fieldClazz", fieldClazz);
        map.put("colFamily", colFamily);
        map.put("colName", colName);
        map.put("fieldName", fieldName);
        map.put("isEmbeddable", isEmbeddable);
        map.put("dbColumn", dbColName);
        return map;
    }

    public static void traverse(Expression expression, EntityMetadata m, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata, KunderaQuery kunderaQuery, boolean isSubExpression) {
        if (ComparisonExpression.class.isAssignableFrom(expression.getClass())) {
            KunderaQueryUtils.onComparisonExpression(expression, m, kunderaMetadata, kunderaQuery);
        } else if (LogicalExpression.class.isAssignableFrom(expression.getClass())) {
            KunderaQueryUtils.onLogicalExpression(expression, m, kunderaMetadata, kunderaQuery);
        } else if (InExpression.class.isAssignableFrom(expression.getClass())) {
            KunderaQueryUtils.onInExpression(expression, m, kunderaMetadata, kunderaQuery);
        } else if (LikeExpression.class.isAssignableFrom(expression.getClass())) {
            KunderaQueryUtils.onLikeExpression(expression, m, kunderaMetadata, kunderaQuery);
        } else if (RegexpExpression.class.isAssignableFrom(expression.getClass())) {
            KunderaQueryUtils.onRegExpression(expression, m, kunderaMetadata, kunderaQuery);
        } else if (BetweenExpression.class.isAssignableFrom(expression.getClass())) {
            KunderaQueryUtils.onBetweenExpression(expression, m, kunderaMetadata, kunderaQuery);
        } else if (SubExpression.class.isAssignableFrom(expression.getClass())) {
            KunderaQueryUtils.onSubExpression(expression, m, kunderaMetadata, kunderaQuery);
        }
    }

    public static void onSubExpression(Expression expression, EntityMetadata m, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata, KunderaQuery kunderaQuery) {
        kunderaQuery.addFilterClause("(");
        KunderaQueryUtils.traverse(((SubExpression)expression).getExpression(), m, kunderaMetadata, kunderaQuery, true);
        kunderaQuery.addFilterClause(")");
    }

    public static Map<String, Object> onBetweenExpression(Expression expression, EntityMetadata m, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata, KunderaQuery kunderaQuery) {
        BetweenExpression betweenExp = (BetweenExpression)expression;
        StateFieldPathExpression sfpExp = (StateFieldPathExpression)betweenExp.getExpression();
        Map<String, Object> map = KunderaQueryUtils.setFieldClazzAndColumnFamily((Expression)sfpExp, m, kunderaMetadata);
        String columnName = (String)map.get("colName");
        String fieldName = (String)map.get("fieldName");
        kunderaQuery.addFilterClause(columnName, ">=", betweenExp.getLowerBoundExpression().toActualText(), fieldName);
        kunderaQuery.addFilterClause("AND");
        kunderaQuery.addFilterClause(columnName, "<=", betweenExp.getUpperBoundExpression().toActualText(), fieldName);
        return map;
    }

    public static Map<String, Object> onLikeExpression(Expression expression, EntityMetadata m, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata, KunderaQuery kunderaQuery) {
        LikeExpression likeExp = (LikeExpression)expression;
        StateFieldPathExpression sfpExp = (StateFieldPathExpression)likeExp.getStringExpression();
        Map<String, Object> map = KunderaQueryUtils.setFieldClazzAndColumnFamily((Expression)sfpExp, m, kunderaMetadata);
        kunderaQuery.addFilterClause((String)map.get("colName"), likeExp.getIdentifier(), likeExp.getPatternValue().toActualText(), (String)map.get("fieldName"));
        return map;
    }

    public static Map<String, Object> onRegExpression(Expression expression, EntityMetadata m, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata, KunderaQuery kunderaQuery) {
        RegexpExpression regExp = (RegexpExpression)expression;
        StateFieldPathExpression sfpExp = (StateFieldPathExpression)regExp.getStringExpression();
        Map<String, Object> map = KunderaQueryUtils.setFieldClazzAndColumnFamily((Expression)sfpExp, m, kunderaMetadata);
        kunderaQuery.addFilterClause((String)map.get("colName"), regExp.getActualRegexpIdentifier().toUpperCase(), regExp.getPatternValue().toActualText(), (String)map.get("fieldName"));
        return map;
    }

    public static void onLogicalExpression(Expression expression, EntityMetadata m, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata, KunderaQuery kunderaQuery) {
        KunderaQueryUtils.traverse(((LogicalExpression)expression).getLeftExpression(), m, kunderaMetadata, kunderaQuery, false);
        kunderaQuery.addFilterClause(((LogicalExpression)expression).getIdentifier());
        KunderaQueryUtils.traverse(((LogicalExpression)expression).getRightExpression(), m, kunderaMetadata, kunderaQuery, false);
    }

    public static Map<String, Object> onInExpression(Expression expression, EntityMetadata m, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata, KunderaQuery kunderaQuery) {
        InExpression inExp = (InExpression)expression;
        StateFieldPathExpression sfpExp = (StateFieldPathExpression)inExp.getExpression();
        Map<String, Object> map = KunderaQueryUtils.setFieldClazzAndColumnFamily((Expression)sfpExp, m, kunderaMetadata);
        kunderaQuery.addFilterClause((String)map.get("colName"), inExp.getIdentifier(), inExp.getInItems(), (String)map.get("fieldName"));
        return map;
    }

    public static Map<String, Object> onComparisonExpression(Expression expression, EntityMetadata m, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata, KunderaQuery kunderaQuery) {
        ComparisonExpression compExp = (ComparisonExpression)expression;
        String condition2 = compExp.getIdentifier();
        StateFieldPathExpression sfpExp = (StateFieldPathExpression)compExp.getLeftExpression();
        Map<String, Object> map = KunderaQueryUtils.setFieldClazzAndColumnFamily((Expression)sfpExp, m, kunderaMetadata);
        Object value = KunderaQueryUtils.getValue(compExp.getRightExpression(), (Class)map.get("fieldClazz"), kunderaQuery);
        kunderaQuery.addFilterClause((String)map.get("colName"), condition2, value, (String)map.get("fieldName"));
        return map;
    }

    public static List<OrderByItem> getOrderByItems(JPQLExpression jpqlExpression) {
        LinkedList<OrderByItem> orderList = new LinkedList<OrderByItem>();
        if (KunderaQueryUtils.hasOrderBy(jpqlExpression)) {
            Expression orderByItems = KunderaQueryUtils.getOrderByClause(jpqlExpression).getOrderByItems();
            if (orderByItems instanceof CollectionExpression) {
                for (OrderByItem orderByItem : orderByItems.children()) {
                    orderList.add(orderByItem);
                }
            } else {
                orderList.add((OrderByItem)orderByItems);
            }
        }
        return orderList;
    }
}

