/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.query;

import com.impetus.kundera.client.Client;
import com.impetus.kundera.client.EnhanceEntity;
import com.impetus.kundera.metadata.model.ApplicationMetadata;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.metadata.model.MetamodelImpl;
import com.impetus.kundera.metadata.model.attributes.AbstractAttribute;
import com.impetus.kundera.metadata.model.type.DefaultEntityType;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import com.impetus.kundera.persistence.EntityReader;
import com.impetus.kundera.persistence.PersistenceDelegator;
import com.impetus.kundera.persistence.context.PersistenceCacheManager;
import com.impetus.kundera.property.PropertyAccessorHelper;
import com.impetus.kundera.query.KunderaQuery;
import com.impetus.kundera.query.KunderaQueryUtils;
import com.impetus.kundera.query.Query;
import com.impetus.kundera.query.QueryHandlerException;
import com.impetus.kundera.utils.KunderaCoreUtils;
import com.impetus.kundera.utils.ReflectUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Parameter;
import javax.persistence.PersistenceException;
import javax.persistence.PostLoad;
import javax.persistence.TemporalType;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.SingularAttribute;
import org.eclipse.persistence.jpa.jpql.parser.AggregateFunction;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QueryImpl<E>
implements javax.persistence.Query,
Query {
    protected KunderaQuery kunderaQuery;
    protected PersistenceDelegator persistenceDelegeator;
    protected EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata;
    private static Logger log = LoggerFactory.getLogger(QueryImpl.class);
    private Set<Parameter<?>> parameters;
    private Map<String, Object> hints = new HashMap<String, Object>();
    protected int maxResult = 100;
    protected int firstResult = 0;
    private Integer fetchSize;
    protected boolean isSingleResult = false;
    protected Integer ttl;

    public QueryImpl(KunderaQuery kunderaQuery, PersistenceDelegator persistenceDelegator, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        this.kunderaQuery = kunderaQuery;
        this.persistenceDelegeator = persistenceDelegator;
        this.kunderaMetadata = kunderaMetadata;
    }

    public String getJPAQuery() {
        return this.kunderaQuery.getJPAQuery();
    }

    public KunderaQuery getKunderaQuery() {
        return this.kunderaQuery;
    }

    public int executeUpdate() {
        return this.onExecuteUpdate();
    }

    public List<?> getResultList() {
        if (log.isDebugEnabled()) {
            log.info("On getResultList() executing query: " + this.getJPAQuery());
        }
        List<Object> results = null;
        if (this.getEntityMetadata() == null) {
            if (this.kunderaQuery.isDeleteUpdate()) {
                this.executeUpdate();
            } else {
                Client client = this.persistenceDelegeator.getClient(this.kunderaQuery.getPersistenceUnit());
                results = this.populateEntities(null, client);
            }
        } else {
            this.handlePostEvent();
            if (this.kunderaQuery.isDeleteUpdate()) {
                this.executeUpdate();
            } else {
                results = this.fetch();
                this.assignReferenceToProxy(results);
            }
        }
        return results != null ? results : new ArrayList();
    }

    protected List<Object> setRelationEntities(List enhanceEntities, Client client, EntityMetadata m) {
        ArrayList<Object> result = new ArrayList<Object>();
        HashMap<Object, Object> relationStack = new HashMap<Object, Object>();
        if (enhanceEntities != null) {
            for (Object e : enhanceEntities) {
                this.addToRelationStack(relationStack, e, m);
            }
        }
        if (enhanceEntities != null) {
            for (Object e : enhanceEntities) {
                if (!(e instanceof EnhanceEntity)) {
                    e = new EnhanceEntity(e, PropertyAccessorHelper.getId(e, m), null);
                }
                EnhanceEntity ee = (EnhanceEntity)e;
                result.add(this.getReader().recursivelyFindEntities(ee.getEntity(), ee.getRelations(), m, this.persistenceDelegeator, false, relationStack));
            }
        }
        return result;
    }

    protected void addToRelationStack(Map<Object, Object> relationStack, Object entity, EntityMetadata m) {
        Object obj = entity;
        if (entity instanceof EnhanceEntity) {
            obj = ((EnhanceEntity)entity).getEntity();
        }
        relationStack.put(obj.getClass().getCanonicalName() + "#" + PropertyAccessorHelper.getId(obj, m), obj);
    }

    private List<Object> populateEmbeddedIdUsingLucene(EntityMetadata m, Client client, List<Object> result, Map<String, Object> searchFilter, MetamodelImpl metaModel) {
        ArrayList<Object> compositeIds = new ArrayList<Object>();
        for (String compositeIdName : searchFilter.keySet()) {
            Object compositeId = null;
            Map uniquePKs = (Map)searchFilter.get(compositeIdName);
            compositeId = KunderaCoreUtils.initialize(m.getIdAttribute().getBindableJavaType(), compositeId);
            this.prepareCompositeIdObject(m.getIdAttribute(), compositeId, uniquePKs, metaModel);
            compositeIds.add(compositeId);
        }
        return this.findUsingLucene(m, client, compositeIds.toArray());
    }

    private Object prepareCompositeIdObject(SingularAttribute attribute, Object compositeId, Map<String, String> uniquePKs, MetamodelImpl metaModel) {
        Field[] fields = attribute.getBindableJavaType().getDeclaredFields();
        EmbeddableType embeddable = metaModel.embeddable(attribute.getBindableJavaType());
        for (Field field : attribute.getBindableJavaType().getDeclaredFields()) {
            if (ReflectUtils.isTransientOrStatic(field)) continue;
            if (metaModel.isEmbeddable(((AbstractAttribute)embeddable.getAttribute(field.getName())).getBindableJavaType())) {
                try {
                    field.setAccessible(true);
                    Object embeddedObject = this.prepareCompositeIdObject((SingularAttribute)embeddable.getAttribute(field.getName()), KunderaCoreUtils.initialize(((AbstractAttribute)embeddable.getAttribute(field.getName())).getBindableJavaType(), field.get(compositeId)), uniquePKs, metaModel);
                    PropertyAccessorHelper.set(compositeId, field, embeddedObject);
                }
                catch (IllegalAccessException e) {
                    log.error(e.getMessage());
                }
                continue;
            }
            PropertyAccessorHelper.set(compositeId, field, PropertyAccessorHelper.fromSourceToTargetClass(field.getType(), String.class, uniquePKs.get(field.getName())));
        }
        return compositeId;
    }

    private List<Object> findUsingLucene(EntityMetadata m, Client client, Object[] primaryKeys) {
        String idField = m.getIdAttribute().getName();
        String equals = "=";
        MetamodelImpl metaModel = (MetamodelImpl)this.kunderaMetadata.getApplicationMetadata().getMetamodel(m.getPersistenceUnit());
        EntityType<?> entityType = metaModel.entity(m.getEntityClazz());
        String columnName = ((AbstractAttribute)entityType.getAttribute(idField)).getJPAColumnName();
        ArrayList<Object> result = new ArrayList<Object>();
        Queue queue = this.getKunderaQuery().getFilterClauseQueue();
        KunderaQuery kunderaQuery = this.getKunderaQuery();
        for (Object primaryKey : primaryKeys) {
            KunderaQuery kunderaQuery2 = kunderaQuery;
            kunderaQuery2.getClass();
            KunderaQuery.FilterClause filterClause = kunderaQuery2.new KunderaQuery.FilterClause(columnName, equals, primaryKey, idField);
            kunderaQuery.setFilter(kunderaQuery.getEntityAlias() + "." + columnName + " = " + primaryKey);
            queue.clear();
            queue.add(filterClause);
            List object = this.findUsingLucene(m, client);
            if (object == null || object.isEmpty()) continue;
            result.add(object.get(0));
        }
        return result;
    }

    protected List<Object> populateUsingLucene(EntityMetadata m, Client client, List<Object> result, String[] columnsToSelect) {
        HashSet<Object> uniquePKs = null;
        MetamodelImpl metaModel = (MetamodelImpl)this.kunderaMetadata.getApplicationMetadata().getMetamodel(m.getPersistenceUnit());
        if (client.getIndexManager().getIndexer().getClass().getName().equals("com.impetus.kundera.index.LuceneIndexer")) {
            String luceneQ = KunderaCoreUtils.getLuceneQueryFromJPAQuery(this.kunderaQuery, this.kunderaMetadata);
            Map<String, Object> searchFilter = client.getIndexManager().search(m.getEntityClazz(), luceneQ, -1, -1);
            boolean isEmbeddedId = metaModel.isEmbeddable(m.getIdAttribute().getBindableJavaType());
            if (isEmbeddedId) {
                return this.populateEmbeddedIdUsingLucene(m, client, result, searchFilter, metaModel);
            }
            Object[] primaryKeys = searchFilter.values().toArray(new Object[0]);
            uniquePKs = new HashSet<Object>(Arrays.asList(primaryKeys));
            return this.findUsingLucene(m, client, uniquePKs.toArray());
        }
        return this.populateUsingElasticSearch(client, m);
    }

    private List populateUsingElasticSearch(Client client, EntityMetadata m) {
        Map<String, Object> searchFilter = client.getIndexManager().search(this.kunderaMetadata, this.kunderaQuery, this.persistenceDelegeator, m, this.maxResult);
        Object[] primaryKeys = ((Map)searchFilter.get("primaryKeys")).values().toArray(new Object[0]);
        Map aggregations = (Map)searchFilter.get("aggregations");
        Iterable resultOrderIterable = (Iterable)searchFilter.get("selectExpressionOrder");
        ArrayList<Object> results = new ArrayList<Object>();
        if (!this.kunderaQuery.isAggregated()) {
            results.addAll(this.findUsingLucene(m, client, primaryKeys));
        } else if (KunderaQueryUtils.hasGroupBy(this.kunderaQuery.getJpqlExpression())) {
            this.populateGroupByResponse(aggregations, resultOrderIterable, results, client, m);
        } else {
            for (Expression expression : resultOrderIterable) {
                if (AggregateFunction.class.isAssignableFrom(expression.getClass())) {
                    if (aggregations.get(expression.toParsedText()) == null) continue;
                    results.add(aggregations.get(expression.toParsedText()));
                    continue;
                }
                results.addAll(this.findUsingLucene(m, client, new Object[]{primaryKeys[0]}));
            }
        }
        return results;
    }

    private void populateGroupByResponse(Map<String, Object> aggregations, Iterable<Expression> resultOrderIterable, List<Object> results, Client client, EntityMetadata m) {
        Object entity = null;
        for (String entry : aggregations.keySet()) {
            entity = null;
            Object obj = aggregations.get(entry);
            ArrayList<Object> temp = new ArrayList<Object>();
            for (Expression expression : resultOrderIterable) {
                if (AggregateFunction.class.isAssignableFrom(expression.getClass())) {
                    if (((Map)obj).get(expression.toParsedText()) == null) continue;
                    temp.add(((Map)obj).get(expression.toParsedText()));
                    continue;
                }
                if (entity == null) {
                    entity = this.findUsingLucene(m, client, new Object[]{entry}).get(0);
                }
                temp.add(this.getEntityFieldValue(m, entity, expression.toParsedText()));
            }
            results.add(temp.size() == 1 ? temp.get(0) : temp);
        }
    }

    private Object getEntityFieldValue(EntityMetadata entityMetadata, Object entity, String field) {
        Class<?> clazz = entityMetadata.getEntityClazz();
        MetamodelImpl metaModel = (MetamodelImpl)this.kunderaMetadata.getApplicationMetadata().getMetamodel(entityMetadata.getPersistenceUnit());
        EntityType<?> entityType = metaModel.entity(clazz);
        if (field.indexOf(".") > 0 && entityMetadata.getEntityClazz().equals(entity.getClass())) {
            String fieldName = field.substring(field.indexOf(".") + 1, field.length());
            Attribute attribute = entityType.getAttribute(fieldName);
            return PropertyAccessorHelper.getObject(entity, (Field)attribute.getJavaMember());
        }
        if (entity instanceof ArrayList) {
            Object element = ((ArrayList)entity).get(0);
            ((ArrayList)entity).remove(0);
            return element;
        }
        return entity;
    }

    protected abstract List<Object> populateEntities(EntityMetadata var1, Client var2);

    protected abstract List findUsingLucene(EntityMetadata var1, Client var2);

    protected abstract List<Object> recursivelyPopulateEntities(EntityMetadata var1, Client var2);

    protected abstract EntityReader getReader();

    protected abstract int onExecuteUpdate();

    protected EntityMetadata getEntityMetadata() {
        return this.kunderaQuery.getEntityMetadata();
    }

    protected int onUpdateDeleteEvent() {
        if (this.kunderaQuery.isDeleteUpdate()) {
            List result = this.fetch();
            this.onDeleteOrUpdate(result);
            return result != null ? result.size() : 0;
        }
        return 0;
    }

    protected void onDeleteOrUpdate(List results) {
        block9: {
            if (results == null) break block9;
            if (!this.kunderaQuery.isUpdateClause()) {
                for (Object result : results) {
                    PersistenceCacheManager.addEntityToPersistenceCache(result, this.persistenceDelegeator, PropertyAccessorHelper.getId(result, this.getEntityMetadata()));
                    this.persistenceDelegeator.remove(result);
                }
            } else {
                EntityMetadata entityMetadata = this.getEntityMetadata();
                for (Object result : results) {
                    PersistenceCacheManager.addEntityToPersistenceCache(result, this.persistenceDelegeator, PropertyAccessorHelper.getId(result, this.getEntityMetadata()));
                    for (KunderaQuery.UpdateClause c : this.kunderaQuery.getUpdateClauseQueue()) {
                        String columnName = c.getProperty();
                        try {
                            DefaultEntityType entityType = (DefaultEntityType)this.kunderaMetadata.getApplicationMetadata().getMetamodel(entityMetadata.getPersistenceUnit()).entity(entityMetadata.getEntityClazz());
                            Attribute attribute = entityType.getAttribute(columnName);
                            if (c.getValue() instanceof String) {
                                PropertyAccessorHelper.set(result, (Field)attribute.getJavaMember(), c.getValue().toString());
                            } else {
                                PropertyAccessorHelper.set(result, (Field)attribute.getJavaMember(), c.getValue());
                            }
                            this.persistenceDelegeator.merge(result);
                        }
                        catch (IllegalArgumentException iax) {
                            log.error("Invalid column name: " + columnName + " for class : " + entityMetadata.getEntityClazz());
                            throw new QueryHandlerException("Error while executing query: " + iax);
                        }
                    }
                }
            }
        }
    }

    public Object getSingleResult() {
        this.isSingleResult = true;
        List<?> results = this.getResultList();
        this.isSingleResult = false;
        return this.onReturnResults(results);
    }

    public javax.persistence.Query setFirstResult(int startPosition) {
        this.firstResult = startPosition;
        return this;
    }

    public javax.persistence.Query setFlushMode(FlushModeType flushMode) {
        throw new UnsupportedOperationException("setFlushMode is unsupported by Kundera");
    }

    public javax.persistence.Query setHint(String hintName, Object value) {
        this.hints.put(hintName, value);
        return this;
    }

    public javax.persistence.Query setMaxResults(int maxResult) {
        this.maxResult = maxResult;
        return this;
    }

    public javax.persistence.Query setParameter(String name, Object value) {
        this.kunderaQuery.setParameter(name, value);
        return this;
    }

    public javax.persistence.Query setParameter(int position, Object value) {
        this.kunderaQuery.setParameter(position, value);
        return this;
    }

    public javax.persistence.Query setParameter(String name, Date value, TemporalType temporalType) {
        throw new UnsupportedOperationException("setParameter is unsupported by Kundera");
    }

    public javax.persistence.Query setParameter(String name, Calendar value, TemporalType temporalType) {
        throw new UnsupportedOperationException("setParameter is unsupported by Kundera");
    }

    public javax.persistence.Query setParameter(int position, Date value, TemporalType temporalType) {
        throw new UnsupportedOperationException("setParameter is unsupported by Kundera");
    }

    public javax.persistence.Query setParameter(int position, Calendar value, TemporalType temporalType) {
        throw new UnsupportedOperationException("setParameter is unsupported by Kundera");
    }

    public int getMaxResults() {
        return this.maxResult;
    }

    public int getFirstResult() {
        throw new UnsupportedOperationException("getFirstResult is unsupported by Kundera");
    }

    public Map<String, Object> getHints() {
        return this.hints;
    }

    public <T> javax.persistence.Query setParameter(Parameter<T> paramParameter, T paramT) {
        if (!this.getParameters().contains(paramParameter)) {
            throw new IllegalArgumentException("parameter does not correspond to a parameter of the query");
        }
        if (paramParameter.getName() != null) {
            this.kunderaQuery.setParameter(paramParameter.getName(), paramT);
        } else {
            this.kunderaQuery.setParameter(paramParameter.getPosition(), paramT);
        }
        return this;
    }

    public javax.persistence.Query setParameter(Parameter<Calendar> paramParameter, Calendar paramCalendar, TemporalType paramTemporalType) {
        throw new UnsupportedOperationException("setParameter is unsupported by Kundera");
    }

    public javax.persistence.Query setParameter(Parameter<Date> paramParameter, Date paramDate, TemporalType paramTemporalType) {
        throw new UnsupportedOperationException("setParameter is unsupported by Kundera");
    }

    public Set<Parameter<?>> getParameters() {
        if (this.parameters == null) {
            this.parameters = this.kunderaQuery.getParameters();
            if (this.parameters == null) {
                this.parameters = new HashSet();
            }
        }
        return this.parameters;
    }

    public Parameter<?> getParameter(String paramString) {
        this.onNativeCondition();
        this.getParameters();
        return this.getParameterByName(paramString);
    }

    public <T> Parameter<T> getParameter(String paramString, Class<T> paramClass) {
        this.onNativeCondition();
        Parameter parameter = this.getParameterByName(paramString);
        return this.onTypeCheck(paramClass, parameter);
    }

    public Parameter<?> getParameter(int paramInt) {
        this.onNativeCondition();
        this.getParameters();
        return this.getParameterByOrdinal(paramInt);
    }

    public <T> Parameter<T> getParameter(int paramInt, Class<T> paramClass) {
        this.onNativeCondition();
        this.getParameters();
        Parameter parameter = this.getParameterByOrdinal(paramInt);
        return this.onTypeCheck(paramClass, parameter);
    }

    public boolean isBound(Parameter<?> paramParameter) {
        return this.kunderaQuery.isBound(paramParameter);
    }

    public <T> T getParameterValue(Parameter<T> paramParameter) {
        List<Object> value = this.kunderaQuery.getClauseValue(paramParameter);
        if (value == null) {
            throw new IllegalStateException("parameter has not been bound" + paramParameter);
        }
        return (T)value;
    }

    public Object getParameterValue(String paramString) {
        return this.onParameterValue(":" + paramString);
    }

    public Object getParameterValue(int paramInt) {
        return this.onParameterValue("?" + paramInt);
    }

    public FlushModeType getFlushMode() {
        throw new UnsupportedOperationException("getFlushMode is unsupported by Kundera");
    }

    public javax.persistence.Query setLockMode(LockModeType paramLockModeType) {
        throw new UnsupportedOperationException("setLockMode is unsupported by Kundera");
    }

    public LockModeType getLockMode() {
        throw new UnsupportedOperationException("getLockMode is unsupported by Kundera");
    }

    public <T> T unwrap(Class<T> paramClass) {
        try {
            return (T)this;
        }
        catch (ClassCastException ccex) {
            throw new PersistenceException("Provider does not support the call for class type:[" + paramClass + "]");
        }
    }

    private Parameter getParameterByName(String name) {
        if (this.getParameters() != null) {
            for (Parameter<?> p : this.parameters) {
                if (!name.equals(p.getName())) continue;
                return p;
            }
        }
        return null;
    }

    private Parameter getParameterByOrdinal(Integer position) {
        for (Parameter<?> p : this.parameters) {
            if (!position.equals(p.getPosition())) continue;
            return p;
        }
        return null;
    }

    private void onNativeCondition() {
        ApplicationMetadata appMetadata = this.kunderaMetadata.getApplicationMetadata();
        if (appMetadata.isNative(this.getJPAQuery())) {
            throw new IllegalStateException("invoked on a native query when the implementation does not support this use");
        }
    }

    private <T> Parameter<T> onTypeCheck(Class<T> paramClass, Parameter<T> parameter) {
        if (parameter != null && parameter.getParameterType() != null && parameter.getParameterType().equals(paramClass)) {
            return parameter;
        }
        throw new IllegalArgumentException("The parameter of the specified name does not exist or is not assignable to the type");
    }

    private List<Object> onParameterValue(String paramString) {
        List<Object> value = this.kunderaQuery.getClauseValue(paramString);
        if (value == null) {
            throw new IllegalStateException("parameter has not been bound" + paramString);
        }
        return value;
    }

    protected String[] getColumns(String[] columns, EntityMetadata m) {
        ArrayList<String> columnAsList = new ArrayList<String>();
        if (columns != null && columns.length > 0) {
            MetamodelImpl metaModel = (MetamodelImpl)this.kunderaMetadata.getApplicationMetadata().getMetamodel(m.getPersistenceUnit());
            EntityType<?> entity = metaModel.entity(m.getEntityClazz());
            for (int i = 1; i < columns.length; ++i) {
                if (columns[i] == null) continue;
                Attribute col = entity.getAttribute(columns[i]);
                if (col == null) {
                    throw new QueryHandlerException("column type is null for: " + columns);
                }
                columnAsList.add(((AbstractAttribute)col).getJPAColumnName());
            }
        }
        return columnAsList.toArray(new String[0]);
    }

    @Override
    public void setFetchSize(Integer fetchsize) {
        this.fetchSize = fetchsize;
    }

    @Override
    public Integer getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public void applyTTL(int ttlInSeconds) {
        this.ttl = ttlInSeconds;
    }

    @Override
    public abstract void close();

    @Override
    public abstract <E> Iterator<E> iterate();

    protected void handlePostEvent() {
        EntityMetadata metadata = this.getEntityMetadata();
        if (!this.kunderaQuery.isDeleteUpdate()) {
            this.persistenceDelegeator.getEventDispatcher().fireEventListeners(metadata, null, PostLoad.class);
        }
    }

    protected List fetch() {
        EntityMetadata metadata = this.getEntityMetadata();
        Client client = this.persistenceDelegeator.getClient(metadata);
        List<Object> results = this.isRelational(metadata) ? this.recursivelyPopulateEntities(metadata, client) : this.populateEntities(metadata, client);
        return results;
    }

    protected void onValidateSingleResult(List results) {
        if (results == null || results.isEmpty()) {
            log.error("No result found for {} ", (Object)this.kunderaQuery.getJPAQuery());
            throw new NoResultException("No result found!");
        }
        if (results.size() > 1) {
            log.error("Non unique results found for query {} ", (Object)this.kunderaQuery.getJPAQuery());
            throw new NonUniqueResultException("Containing more than one result!");
        }
    }

    protected Object onReturnResults(List results) {
        this.onValidateSingleResult(results);
        return results.get(0);
    }

    private boolean isRelational(EntityMetadata m) {
        return m.isRelationViaJoinTable() || m.getRelationNames() != null && !m.getRelationNames().isEmpty();
    }

    private void assignReferenceToProxy(List results) {
        if (results != null) {
            for (Object obj : results) {
                this.kunderaMetadata.getCoreMetadata().getLazyInitializerFactory().setProxyOwners(this.getEntityMetadata(), obj);
            }
        }
    }
}

