/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.query;

import com.impetus.kundera.metadata.KunderaMetadataManager;
import com.impetus.kundera.metadata.model.ApplicationMetadata;
import com.impetus.kundera.metadata.model.EntityMetadata;
import com.impetus.kundera.persistence.EntityManagerFactoryImpl;
import com.impetus.kundera.persistence.PersistenceDelegator;
import com.impetus.kundera.query.KunderaQuery;
import com.impetus.kundera.query.KunderaQueryParser;
import com.impetus.kundera.query.QueryHandlerException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import javax.persistence.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryResolver {
    private static Logger log = LoggerFactory.getLogger(QueryResolver.class);

    public Query getQueryImplementation(String jpaQuery, PersistenceDelegator persistenceDelegator, Class mappedClass, boolean isNative, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) {
        if (jpaQuery == null) {
            throw new QueryHandlerException("Query String should not be null ");
        }
        if (jpaQuery.trim().endsWith(";")) {
            throw new QueryHandlerException("unexpected char: ';' in query [ " + jpaQuery + " ]");
        }
        KunderaQuery kunderaQuery = null;
        ApplicationMetadata appMetadata = kunderaMetadata.getApplicationMetadata();
        String mappedQuery = appMetadata.getQuery(jpaQuery);
        isNative = mappedQuery != null ? appMetadata.isNative(jpaQuery) : isNative;
        EntityMetadata m = null;
        if (!isNative) {
            kunderaQuery = new KunderaQuery(mappedQuery != null ? mappedQuery : jpaQuery, kunderaMetadata);
            KunderaQueryParser parser = new KunderaQueryParser(kunderaQuery);
            parser.parse();
            kunderaQuery.postParsingInit();
            m = kunderaQuery.getEntityMetadata();
        } else {
            if (appMetadata.isNative(jpaQuery)) {
                mappedClass = appMetadata.getMappedClass(jpaQuery);
            }
            kunderaQuery = new KunderaQuery(jpaQuery, kunderaMetadata);
            kunderaQuery.isNativeQuery = true;
            m = KunderaMetadataManager.getEntityMetadata(kunderaMetadata, mappedClass);
            Field entityClazzField = null;
            try {
                entityClazzField = kunderaQuery.getClass().getDeclaredField("entityClass");
                if (entityClazzField != null && !entityClazzField.isAccessible()) {
                    entityClazzField.setAccessible(true);
                }
                entityClazzField.set(kunderaQuery, mappedClass);
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw new QueryHandlerException(e);
            }
        }
        Query query = null;
        try {
            query = this.getQuery(jpaQuery, persistenceDelegator, m, kunderaQuery, kunderaMetadata);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new QueryHandlerException(e);
        }
        return query;
    }

    private Query getQuery(String jpaQuery, PersistenceDelegator persistenceDelegator, EntityMetadata m, KunderaQuery kunderaQuery, EntityManagerFactoryImpl.KunderaMetadata kunderaMetadata) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class clazz = persistenceDelegator.getClient(m).getQueryImplementor();
        Constructor constructor = clazz.getConstructor(KunderaQuery.class, PersistenceDelegator.class, EntityManagerFactoryImpl.KunderaMetadata.class);
        Query query = (Query)constructor.newInstance(kunderaQuery, persistenceDelegator, kunderaMetadata);
        return query;
    }

    public Query getQueryImplementation(String jpaQuery, Class queryClazz, PersistenceDelegator persistenceDelegator, EntityMetadata metadata, String persistenceUnit) {
        KunderaQuery kunderaQuery = new KunderaQuery(jpaQuery, persistenceDelegator.getKunderaMetadata());
        kunderaQuery.isNativeQuery = true;
        kunderaQuery.setPersistenceUnit(persistenceUnit);
        try {
            if (metadata != null) {
                Field entityClazzField = kunderaQuery.getClass().getDeclaredField("entityClass");
                if (entityClazzField != null && !entityClazzField.isAccessible()) {
                    entityClazzField.setAccessible(true);
                }
                entityClazzField.set(kunderaQuery, metadata.getEntityClazz());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new QueryHandlerException(e);
        }
        Query query = null;
        try {
            Constructor constructor = queryClazz.getConstructor(KunderaQuery.class, PersistenceDelegator.class, EntityManagerFactoryImpl.KunderaMetadata.class);
            query = (Query)constructor.newInstance(kunderaQuery, persistenceDelegator, persistenceDelegator.getKunderaMetadata());
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new QueryHandlerException(e);
        }
        return query;
    }
}

