/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.utils;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class KunderaThreadFactory
implements ThreadFactory {
    private ConcurrentHashMap<String, AtomicInteger> counters = new ConcurrentHashMap();
    private final String name;

    public KunderaThreadFactory(String threadName) {
        this.name = threadName;
    }

    private int getNext() {
        AtomicInteger threadCount = this.counters.get(this.name);
        if (threadCount == null) {
            threadCount = new AtomicInteger();
            this.counters.put(this.name, threadCount);
        }
        return threadCount.incrementAndGet();
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(r);
        t.setDaemon(true);
        StringBuilder tdNameBuilder = new StringBuilder(this.name);
        tdNameBuilder.append("#");
        tdNameBuilder.append(this.getNext());
        t.setName(tdNameBuilder.toString());
        return t;
    }
}

