/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.validation.rules;

import com.impetus.kundera.property.PropertyAccessorHelper;
import com.impetus.kundera.validation.rules.AbstractFieldRule;
import com.impetus.kundera.validation.rules.FieldRule;
import com.impetus.kundera.validation.rules.RuleValidationException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import javax.validation.ValidationException;
import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Future;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.validation.constraints.Past;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.apache.commons.lang.math.NumberUtils;

public class AttributeConstraintRule
extends AbstractFieldRule
implements FieldRule {
    private AttributeConstraintType getERuleType(String annotationType) {
        if (AttributeConstraintType.get(annotationType) != null) {
            return AttributeConstraintType.get(annotationType);
        }
        return null;
    }

    @Override
    public boolean validate(Field f, Object validationObject) {
        boolean checkvalidation = true;
        block15: for (Annotation annotation : f.getDeclaredAnnotations()) {
            AttributeConstraintType eruleType = this.getERuleType(annotation.annotationType().getSimpleName());
            if (eruleType == null) continue;
            Object fieldValue = PropertyAccessorHelper.getObject(validationObject, f);
            switch (eruleType) {
                case ASSERT_FALSE: {
                    checkvalidation = this.validateFalse(fieldValue, annotation);
                    continue block15;
                }
                case ASSERT_TRUE: {
                    checkvalidation = this.validateTrue(fieldValue, annotation);
                    continue block15;
                }
                case DECIMAL_MAX: {
                    checkvalidation = this.validateMaxDecimal(fieldValue, annotation);
                    continue block15;
                }
                case DECIMAL_MIN: {
                    checkvalidation = this.validateMinDecimal(fieldValue, annotation);
                    continue block15;
                }
                case DIGITS: {
                    checkvalidation = this.validateDigits(fieldValue, annotation);
                    continue block15;
                }
                case FUTURE: {
                    checkvalidation = this.validateFuture(fieldValue, annotation);
                    continue block15;
                }
                case MAX: {
                    checkvalidation = this.validateMaxValue(fieldValue, annotation);
                    continue block15;
                }
                case MIN: {
                    checkvalidation = this.validateMinValue(fieldValue, annotation);
                    continue block15;
                }
                case NOT_NULL: {
                    checkvalidation = this.validateNotNull(fieldValue, annotation);
                    continue block15;
                }
                case NULL: {
                    checkvalidation = this.validateNull(fieldValue, annotation);
                    continue block15;
                }
                case PAST: {
                    checkvalidation = this.validatePast(fieldValue, annotation);
                    continue block15;
                }
                case PATTERN: {
                    checkvalidation = this.validatePattern(fieldValue, annotation);
                    continue block15;
                }
                case SIZE: {
                    checkvalidation = this.validateSize(fieldValue, annotation);
                }
            }
        }
        return checkvalidation;
    }

    private boolean validateSize(Object validationObject, Annotation annotate) {
        if (this.checkNullObject(validationObject)) {
            return true;
        }
        int objectSize = 0;
        int minSize = ((Size)annotate).min();
        int maxSize = ((Size)annotate).max();
        if (validationObject != null) {
            if (String.class.isAssignableFrom(validationObject.getClass())) {
                objectSize = ((String)validationObject).length();
            } else if (Collection.class.isAssignableFrom(validationObject.getClass())) {
                objectSize = ((Collection)validationObject).size();
            } else if (Map.class.isAssignableFrom(validationObject.getClass())) {
                objectSize = ((Map)validationObject).size();
            } else if (ArrayList.class.isAssignableFrom(validationObject.getClass())) {
                objectSize = ((ArrayList)validationObject).size();
            } else {
                this.throwValidationException(((Size)annotate).message());
            }
        }
        return objectSize <= maxSize && objectSize >= minSize;
    }

    private boolean validatePattern(Object validationObject, Annotation annotate) {
        if (this.checkNullObject(validationObject)) {
            return true;
        }
        java.util.regex.Pattern pattern = java.util.regex.Pattern.compile(((Pattern)annotate).regexp(), ((Pattern)annotate).flags().length);
        Matcher matcherPattern = pattern.matcher((String)validationObject);
        if (!matcherPattern.matches()) {
            this.throwValidationException(((Pattern)annotate).message());
        }
        return true;
    }

    private boolean validatePast(Object validationObject, Annotation annotate) {
        if (this.checkNullObject(validationObject)) {
            return true;
        }
        int res = 0;
        if (validationObject.getClass().isAssignableFrom(Date.class)) {
            Date today = new Date();
            Date pastDate = (Date)validationObject;
            res = pastDate.compareTo(today);
        } else if (validationObject.getClass().isAssignableFrom(Calendar.class)) {
            Calendar cal = Calendar.getInstance();
            Calendar pastDate = (Calendar)validationObject;
            res = pastDate.compareTo(cal);
        }
        if (res >= 0) {
            this.throwValidationException(((Past)annotate).message());
        }
        return true;
    }

    private boolean validateFuture(Object validationObject, Annotation annotate) {
        if (this.checkNullObject(validationObject)) {
            return true;
        }
        int res = 0;
        if (validationObject.getClass().isAssignableFrom(Date.class)) {
            Date today = new Date();
            Date futureDate = (Date)validationObject;
            res = futureDate.compareTo(today);
        } else if (validationObject.getClass().isAssignableFrom(Calendar.class)) {
            Calendar cal = Calendar.getInstance();
            Calendar futureDate = (Calendar)validationObject;
            res = futureDate.compareTo(cal);
        }
        if (res <= 0) {
            this.throwValidationException(((Future)annotate).message());
        }
        return true;
    }

    private boolean validateNull(Object validationObject, Annotation annotate) {
        if (this.checkNullObject(validationObject)) {
            return true;
        }
        if (!validationObject.equals(null) || validationObject != null) {
            this.throwValidationException(((Null)annotate).message());
        }
        return true;
    }

    private boolean validateNotNull(Object validationObject, Annotation annotate) {
        if (validationObject == null || validationObject.equals(null)) {
            this.throwValidationException(((NotNull)annotate).message());
        }
        return true;
    }

    private boolean validateMinValue(Object validationObject, Annotation annotate) {
        if (this.checkNullObject(validationObject)) {
            return true;
        }
        Long minValue = ((Min)annotate).value();
        if (this.checkvalidDigitTypes(validationObject.getClass()) && NumberUtils.toLong((String)this.toString(validationObject)) < minValue) {
            this.throwValidationException(((Min)annotate).message());
        }
        return true;
    }

    private boolean validateMaxValue(Object validationObject, Annotation annotate) {
        if (this.checkNullObject(validationObject)) {
            return true;
        }
        Long maxValue = ((Max)annotate).value();
        if (this.checkvalidDigitTypes(validationObject.getClass()) && NumberUtils.toLong((String)this.toString(validationObject)) > maxValue) {
            this.throwValidationException(((Max)annotate).message());
        }
        return true;
    }

    private boolean validateDigits(Object validationObject, Annotation annotate) {
        if (this.checkNullObject(validationObject)) {
            return true;
        }
        if (this.checkvalidDigitTypes(validationObject.getClass()) && !NumberUtils.isDigits((String)this.toString(validationObject))) {
            this.throwValidationException(((Digits)annotate).message());
        }
        return true;
    }

    private boolean validateMinDecimal(Object validationObject, Annotation annotate) {
        if (validationObject != null) {
            try {
                if (this.checkvalidDeciDigitTypes(validationObject.getClass())) {
                    BigDecimal minValue = NumberUtils.createBigDecimal((String)((DecimalMin)annotate).value());
                    BigDecimal actualValue = NumberUtils.createBigDecimal((String)this.toString(validationObject));
                    int res = actualValue.compareTo(minValue);
                    if (res < 0) {
                        this.throwValidationException(((DecimalMin)annotate).message());
                    }
                }
            }
            catch (NumberFormatException nfe) {
                throw new RuleValidationException(nfe.getMessage());
            }
        }
        return true;
    }

    private boolean validateMaxDecimal(Object validationObject, Annotation annotate) {
        if (validationObject != null) {
            try {
                if (this.checkvalidDeciDigitTypes(validationObject.getClass())) {
                    BigDecimal maxValue = NumberUtils.createBigDecimal((String)((DecimalMax)annotate).value());
                    BigDecimal actualValue = NumberUtils.createBigDecimal((String)this.toString(validationObject));
                    int res = actualValue.compareTo(maxValue);
                    if (res > 0) {
                        this.throwValidationException(((DecimalMax)annotate).message());
                    }
                }
            }
            catch (NumberFormatException nfe) {
                throw new RuleValidationException(nfe.getMessage());
            }
        }
        return true;
    }

    private boolean validateTrue(Object validationObject, Annotation annotate) {
        if (this.checkNullObject(validationObject)) {
            return true;
        }
        if (this.checkvalidBooleanTypes(validationObject.getClass()) && !((Boolean)validationObject).booleanValue()) {
            this.throwValidationException(((AssertTrue)annotate).message());
        }
        return true;
    }

    private boolean validateFalse(Object validationObject, Annotation annotate) {
        if (this.checkNullObject(validationObject)) {
            return true;
        }
        if (this.checkvalidBooleanTypes(validationObject.getClass()) && ((Boolean)validationObject).booleanValue()) {
            this.throwValidationException(((AssertFalse)annotate).message());
        }
        return true;
    }

    private boolean checkvalidDigitTypes(Class<?> javaType) {
        return javaType.isAssignableFrom(BigDecimal.class) || javaType.isAssignableFrom(Byte.TYPE) || javaType.isAssignableFrom(Byte.class) || javaType.isAssignableFrom(Short.TYPE) || javaType.isAssignableFrom(Short.class) || javaType.isAssignableFrom(Integer.TYPE) || javaType.isAssignableFrom(Integer.class) || javaType.isAssignableFrom(Long.TYPE) || javaType.isAssignableFrom(Long.class);
    }

    private boolean checkvalidBooleanTypes(Class<?> javaType) {
        return javaType.isAssignableFrom(Boolean.class) || javaType.isAssignableFrom(Boolean.TYPE);
    }

    private boolean checkvalidDeciDigitTypes(Class<?> javaType) {
        return javaType.isAssignableFrom(BigDecimal.class) || javaType.isAssignableFrom(String.class) || javaType.isAssignableFrom(Byte.TYPE) || javaType.isAssignableFrom(Byte.class) || javaType.isAssignableFrom(Short.TYPE) || javaType.isAssignableFrom(Short.class) || javaType.isAssignableFrom(Integer.TYPE) || javaType.isAssignableFrom(Integer.class) || javaType.isAssignableFrom(Long.TYPE) || javaType.isAssignableFrom(Long.class);
    }

    private String toString(Object validationObject) {
        String stringObject = null;
        if (validationObject.getClass().isAssignableFrom(Integer.TYPE) || validationObject.getClass().isAssignableFrom(Integer.class)) {
            stringObject = Integer.toString((Integer)validationObject);
        } else if (validationObject.getClass().isAssignableFrom(Byte.TYPE) || validationObject.getClass().isAssignableFrom(Byte.class)) {
            stringObject = Byte.toString((Byte)validationObject);
        } else if (validationObject.getClass().isAssignableFrom(Short.TYPE) || validationObject.getClass().isAssignableFrom(Short.class)) {
            stringObject = Short.toString((Short)validationObject);
        } else if (validationObject.getClass().isAssignableFrom(BigDecimal.class)) {
            stringObject = validationObject.toString();
        } else if (validationObject.getClass().isAssignableFrom(Long.class) || validationObject.getClass().isAssignableFrom(Long.TYPE)) {
            stringObject = Long.toString((Long)validationObject);
        } else if (validationObject.getClass().isAssignableFrom(String.class) || validationObject.getClass().isAssignableFrom(String.class)) {
            stringObject = (String)validationObject;
        }
        return stringObject;
    }

    private boolean checkNullObject(Object validationObject) {
        return validationObject == null;
    }

    private void throwValidationException(String message) {
        if (!message.isEmpty() || message != null) {
            throw new ValidationException(message);
        }
        throw new ValidationException("Constraint validation exception");
    }

    static enum AttributeConstraintType {
        ASSERT_FALSE(AssertFalse.class.getSimpleName()),
        ASSERT_TRUE(AssertTrue.class.getSimpleName()),
        DECIMAL_MAX(DecimalMax.class.getSimpleName()),
        DECIMAL_MIN(DecimalMin.class.getSimpleName()),
        DIGITS(Digits.class.getSimpleName()),
        FUTURE(Future.class.getSimpleName()),
        MAX(Max.class.getSimpleName()),
        MIN(Min.class.getSimpleName()),
        NOT_NULL(NotNull.class.getSimpleName()),
        NULL(Null.class.getSimpleName()),
        PAST(Past.class.getSimpleName()),
        PATTERN(Pattern.class.getSimpleName()),
        SIZE(Size.class.getSimpleName());

        private String clazz;
        private static final Map<String, AttributeConstraintType> lookup;

        private AttributeConstraintType(String clazz) {
            this.clazz = clazz;
        }

        public String getClazz() {
            return this.clazz;
        }

        public static AttributeConstraintType get(String clazz) {
            return lookup.get(clazz);
        }

        static {
            lookup = new HashMap<String, AttributeConstraintType>();
            for (AttributeConstraintType s : EnumSet.allOf(AttributeConstraintType.class)) {
                lookup.put(s.getClazz(), s);
            }
        }
    }
}

