/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.validation.rules;

import com.impetus.kundera.validation.rules.AbstractEntityRule;
import com.impetus.kundera.validation.rules.EntityRule;
import com.impetus.kundera.validation.rules.RuleValidationException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javassist.Modifier;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityFieldAnnotationRule
extends AbstractEntityRule
implements EntityRule {
    private static final Logger log = LoggerFactory.getLogger(EntityFieldAnnotationRule.class);

    @Override
    public void validate(Class<?> clazz) {
        ArrayList<Field> keys = new ArrayList<Field>();
        for (Field field : clazz.getDeclaredFields()) {
            this.onIdField(field, clazz);
            if (field.isAnnotationPresent(Id.class)) {
                keys.add(field);
                if (!field.isAnnotationPresent(GeneratedValue.class)) continue;
                this.validateGeneratedValueAnnotation(clazz, field);
                continue;
            }
            if (!field.isAnnotationPresent(EmbeddedId.class)) continue;
            keys.add(field);
        }
        if (clazz.isAnnotationPresent(Entity.class) || clazz.isAnnotationPresent(MappedSuperclass.class)) {
            this.onSuperClass(clazz, keys);
        }
    }

    private void onSuperClass(Class<?> clazz, List<Field> keys) {
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && (superClass.isAnnotationPresent(MappedSuperclass.class) || superClass.isAnnotationPresent(Entity.class))) {
            while (superClass != null && (superClass.isAnnotationPresent(MappedSuperclass.class) || superClass.isAnnotationPresent(Entity.class))) {
                for (Field field : superClass.getDeclaredFields()) {
                    this.onIdField(field, superClass);
                    if (field.isAnnotationPresent(Id.class)) {
                        keys.add(field);
                        if (!field.isAnnotationPresent(GeneratedValue.class)) continue;
                        this.validateGeneratedValueAnnotation(superClass, field);
                        continue;
                    }
                    if (!field.isAnnotationPresent(EmbeddedId.class)) continue;
                    keys.add(field);
                }
                if (keys.size() > 0) {
                    this.onEntityKey(keys, superClass);
                    break;
                }
                superClass = superClass.getSuperclass();
            }
        }
        this.onEntityKey(keys, clazz);
    }

    private void onIdField(Field field, Class<?> clazz) {
        if (field.isAnnotationPresent(Id.class) && field.isAnnotationPresent(EmbeddedId.class)) {
            throw new RuleValidationException(clazz.getName() + " must have either @Id field or @EmbeddedId field");
        }
    }

    private void onEntityKey(List<Field> keys, Class<?> clazz) {
        if (keys.size() <= 0) {
            throw new RuleValidationException(clazz.getName() + " must have an @Id field.");
        }
        if (keys.size() > 1) {
            throw new RuleValidationException(clazz.getName() + " can only have 1 @Id field.");
        }
    }

    private boolean checkValidField(Field field) {
        if (!(field == null || Modifier.isStatic((int)field.getModifiers()) || Modifier.isTransient((int)field.getModifiers()) || field.isAnnotationPresent(Transient.class))) {
            return field.isAnnotationPresent(Id.class) || field.isAnnotationPresent(EmbeddedId.class) || field.isAnnotationPresent(Column.class) || field.isAnnotationPresent(ManyToMany.class) || field.isAnnotationPresent(ManyToOne.class) || field.isAnnotationPresent(OneToOne.class) || field.isAnnotationPresent(Embedded.class) || field.isAnnotationPresent(OneToMany.class) || field.isAnnotationPresent(ElementCollection.class);
        }
        return true;
    }

    private void validateGeneratedValueAnnotation(Class<?> clazz, Field field) {
        String schemaName;
        Table table = clazz.getAnnotation(Table.class);
        if (table != null && (schemaName = table.schema()) != null && schemaName.indexOf(64) > 0) {
            schemaName = schemaName.substring(0, schemaName.indexOf(64));
            GeneratedValue generatedValue = field.getAnnotation(GeneratedValue.class);
            if (generatedValue != null && generatedValue.generator() != null && !generatedValue.generator().isEmpty()) {
                if (!(field.isAnnotationPresent(TableGenerator.class) || field.isAnnotationPresent(SequenceGenerator.class) || clazz.isAnnotationPresent(TableGenerator.class) || clazz.isAnnotationPresent(SequenceGenerator.class))) {
                    throw new IllegalArgumentException("Unknown Id.generator: " + generatedValue.generator());
                }
                this.checkForGenerator(clazz, field, generatedValue, schemaName);
            }
        }
    }

    private void checkForGenerator(Class<?> clazz, Field field, GeneratedValue generatedValue, String schemaName) {
        TableGenerator tableGenerator = field.getAnnotation(TableGenerator.class);
        SequenceGenerator sequenceGenerator = field.getAnnotation(SequenceGenerator.class);
        if (tableGenerator == null || !tableGenerator.name().equals(generatedValue.generator())) {
            tableGenerator = clazz.getAnnotation(TableGenerator.class);
        }
        if (sequenceGenerator == null || !sequenceGenerator.name().equals(generatedValue.generator())) {
            sequenceGenerator = clazz.getAnnotation(SequenceGenerator.class);
        }
        if (tableGenerator == null && sequenceGenerator == null || tableGenerator != null && !tableGenerator.name().equals(generatedValue.generator()) || sequenceGenerator != null && !sequenceGenerator.name().equals(generatedValue.generator())) {
            throw new RuleValidationException("Unknown Id.generator: " + generatedValue.generator());
        }
        if (tableGenerator != null && !tableGenerator.schema().isEmpty() && !tableGenerator.schema().equals(schemaName) || sequenceGenerator != null && !sequenceGenerator.schema().isEmpty() && !sequenceGenerator.schema().equals(schemaName)) {
            throw new RuleValidationException("Generator " + generatedValue.generator() + " in entity : " + clazz.getName() + " has different schema name ,it should be same as entity have");
        }
    }
}

