/*
 * Decompiled with CFR 0.152.
 */
package com.impetus.kundera.validation.rules;

import com.impetus.kundera.metadata.validator.InvalidEntityDefinitionException;
import com.impetus.kundera.property.PropertyAccessorHelper;
import com.impetus.kundera.validation.rules.AbstractFieldRule;
import com.impetus.kundera.validation.rules.FieldRule;
import com.impetus.kundera.validation.rules.RuleValidationException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.AssociationOverride;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyClass;
import javax.persistence.MapKeyJoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationAttributeRule
extends AbstractFieldRule
implements FieldRule {
    private static final Logger log = LoggerFactory.getLogger(RelationAttributeRule.class);

    private RelationType getRuleType(String annotationType) {
        if (RelationType.get(annotationType) != null) {
            return RelationType.get(annotationType);
        }
        return null;
    }

    @Override
    public boolean validate(Field f) throws RuleValidationException {
        boolean checkvalidation = true;
        block6: for (Annotation annotate : f.getDeclaredAnnotations()) {
            RelationType eruleType = this.getRuleType(annotate.annotationType().getSimpleName());
            if (eruleType == null) continue;
            switch (eruleType) {
                case MANY_TO_MANY: {
                    checkvalidation = this.validateManyToMany(f, annotate);
                    continue block6;
                }
                case MANY_TO_ONE: {
                    checkvalidation = this.validateManyToOne(f, annotate);
                    continue block6;
                }
                case ONE_TO_MANY: {
                    checkvalidation = this.validateOneToMany(f, annotate);
                    continue block6;
                }
                case ONE_TO_ONE: {
                    checkvalidation = this.validateOneToOne(f, annotate);
                }
            }
        }
        return checkvalidation;
    }

    private Boolean validateOneToOne(Field relationField, Annotation annotate) {
        boolean isJoinedByTable = relationField.isAnnotationPresent(JoinTable.class);
        if (relationField.isAnnotationPresent(AssociationOverride.class)) {
            AssociationOverride annotation = relationField.getAnnotation(AssociationOverride.class);
            JoinColumn[] joinColumns = annotation.joinColumns();
            this.validateJoinColumns(joinColumns);
            JoinTable joinTable = annotation.joinTable();
            this.onJoinTable(joinTable);
        } else if (isJoinedByTable) {
            throw new UnsupportedOperationException("@JoinTable not supported for one to one association");
        }
        return true;
    }

    private Boolean validateOneToMany(Field relationField, Annotation annotate) throws RuleValidationException {
        boolean isJoinedByTable;
        OneToMany ann = (OneToMany)annotate;
        Class targetEntity = PropertyAccessorHelper.getGenericClass(relationField);
        if (null != ann.targetEntity() && !ann.targetEntity().getSimpleName().equals("void")) {
            targetEntity = ann.targetEntity();
        }
        if (isJoinedByTable = relationField.isAnnotationPresent(JoinTable.class)) {
            throw new UnsupportedOperationException("@JoinTable not supported for one to many association");
        }
        boolean isJoinedByColumn = relationField.isAnnotationPresent(JoinTable.class);
        return true;
    }

    private Boolean validateManyToOne(Field relationField, Annotation annotate) {
        Class<?> targetEntity = relationField.getType();
        boolean isJoinedByTable = relationField.isAnnotationPresent(JoinTable.class);
        if (relationField.isAnnotationPresent(AssociationOverride.class)) {
            AssociationOverride annotation = relationField.getAnnotation(AssociationOverride.class);
            JoinColumn[] joinColumns = annotation.joinColumns();
            this.validateJoinColumns(joinColumns);
            JoinTable joinTable = annotation.joinTable();
            this.onJoinTable(joinTable);
        } else if (isJoinedByTable) {
            throw new UnsupportedOperationException("@JoinTable not supported for many to one association");
        }
        return true;
    }

    private Boolean validateManyToMany(Field relationField, Annotation annotate) throws RuleValidationException {
        String mapKeyJoinColumnName;
        MapKeyJoinColumn mapKeyJoinColumnAnn;
        ManyToMany m2mAnnotation = (ManyToMany)annotate;
        boolean isJoinedByFK = relationField.isAnnotationPresent(JoinColumn.class);
        boolean isJoinedByTable = relationField.isAnnotationPresent(JoinTable.class);
        boolean isJoinedByMap = false;
        if (m2mAnnotation != null && relationField.getType().isAssignableFrom(Map.class)) {
            isJoinedByMap = true;
        }
        Class<?> targetEntity = null;
        Class mapKeyClass = null;
        if (!isJoinedByMap) {
            targetEntity = PropertyAccessorHelper.getGenericClass(relationField);
        } else {
            List<Class<?>> genericClasses = PropertyAccessorHelper.getGenericClasses(relationField);
            if (!genericClasses.isEmpty() && genericClasses.size() == 2) {
                mapKeyClass = genericClasses.get(0);
                targetEntity = genericClasses.get(1);
            }
            MapKeyClass mapKeyClassAnn = relationField.getAnnotation(MapKeyClass.class);
            if (mapKeyClass == null && mapKeyClassAnn != null && mapKeyClassAnn.value() != null && !mapKeyClassAnn.value().getSimpleName().equals("void")) {
                mapKeyClass = mapKeyClassAnn.value();
            }
            if (mapKeyClass == null) {
                throw new InvalidEntityDefinitionException("For a Map relationship field, it is mandatory to specify Map key class either using @MapKeyClass annotation or through generics");
            }
        }
        if (targetEntity == null && null != m2mAnnotation.targetEntity() && !m2mAnnotation.targetEntity().getSimpleName().equals("void")) {
            targetEntity = m2mAnnotation.targetEntity();
        }
        if (targetEntity == null) {
            throw new InvalidEntityDefinitionException("Could not determine target entity class for relationship. It should either be specified using targetEntity attribute of @ManyToMany or through generics");
        }
        if (isJoinedByFK) {
            throw new InvalidEntityDefinitionException("@JoinColumn not allowed for ManyToMany relationship. Use @JoinTable instead");
        }
        if (isJoinedByMap && (mapKeyJoinColumnAnn = relationField.getAnnotation(MapKeyJoinColumn.class)) != null && StringUtils.isEmpty((String)(mapKeyJoinColumnName = mapKeyJoinColumnAnn.name()))) {
            throw new InvalidEntityDefinitionException("It's mandatory to specify name attribute with @MapKeyJoinColumn annotation");
        }
        if (!(isJoinedByTable || isJoinedByMap || m2mAnnotation.mappedBy() != null && !m2mAnnotation.mappedBy().isEmpty())) {
            throw new InvalidEntityDefinitionException("It's manadatory to use @JoinTable with parent side of ManyToMany relationship.");
        }
        return true;
    }

    private void onJoinTable(JoinTable joinTable) {
        if (joinTable != null) {
            throw new UnsupportedOperationException("@JoinTable not supported for many to one association");
        }
    }

    private void validateJoinColumns(JoinColumn[] joinColumns) {
        if (joinColumns.length > 1) {
            throw new UnsupportedOperationException("More than one join columns are not supported.");
        }
    }

    static enum RelationType {
        MANY_TO_MANY(ManyToMany.class.getSimpleName()),
        MANY_TO_ONE(ManyToOne.class.getSimpleName()),
        ONE_TO_MANY(OneToMany.class.getSimpleName()),
        ONE_TO_ONE(OneToOne.class.getSimpleName()),
        ELEMENT_COLLECTION(ElementCollection.class.getSimpleName()),
        EMBEDDED_ID(EmbeddedId.class.getSimpleName()),
        EMBEDDED(Embedded.class.getSimpleName());

        private String clazz;
        private static final Map<String, RelationType> lookup;

        private RelationType(String clazz) {
            this.clazz = clazz;
        }

        public String getClazz() {
            return this.clazz;
        }

        public static RelationType get(String clazz) {
            return lookup.get(clazz);
        }

        static {
            lookup = new HashMap<String, RelationType>();
            for (RelationType s : EnumSet.allOf(RelationType.class)) {
                lookup.put(s.getClazz(), s);
            }
        }
    }
}

