/**
 * Copyright (c) 2013, impossibl.com
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of impossibl.com nor the names of its contributors may
 *    be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package com.impossibl.postgres.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

/**
 * Statement delegator
 */
public class PGStatementDelegator implements Statement {
  private PGPooledConnectionDelegator owner;
  private Statement delegator;

  /**
   * Constructor
   * @param owner The owner
   * @param delegator The delegator
   */
  public PGStatementDelegator(PGPooledConnectionDelegator owner, Statement delegator) {
    this.owner = owner;
    this.delegator = delegator;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void addBatch(String sql) throws SQLException {
    delegator.addBatch(sql);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void cancel() throws SQLException {
    delegator.cancel();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void clearBatch() throws SQLException {
    delegator.clearBatch();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void clearWarnings() throws SQLException {
    delegator.clearWarnings();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void close() throws SQLException {
    delegator.close();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void closeOnCompletion() throws SQLException {
    delegator.closeOnCompletion();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean execute(String sql) throws SQLException {
    return delegator.execute(sql);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
    return delegator.execute(sql, autoGeneratedKeys);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean execute(String sql, int[] columnIndexes) throws SQLException {
    return delegator.execute(sql, columnIndexes);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean execute(String sql, String[] columnNames) throws SQLException {
    return delegator.execute(sql, columnNames);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int[] executeBatch() throws SQLException {
    return delegator.executeBatch();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ResultSet executeQuery(String sql) throws SQLException {
    return delegator.executeQuery(sql);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int executeUpdate(String sql) throws SQLException {
    return delegator.executeUpdate(sql);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
    return delegator.executeUpdate(sql, autoGeneratedKeys);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
    return delegator.executeUpdate(sql, columnIndexes);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int executeUpdate(String sql, String[] columnNames) throws SQLException {
    return delegator.executeUpdate(sql, columnNames);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Connection getConnection() throws SQLException {
    return owner;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int getFetchDirection() throws SQLException {
    return delegator.getFetchDirection();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int getFetchSize() throws SQLException {
    return delegator.getFetchSize();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ResultSet getGeneratedKeys() throws SQLException {
    return delegator.getGeneratedKeys();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int getMaxFieldSize() throws SQLException {
    return delegator.getMaxFieldSize();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int getMaxRows() throws SQLException {
    return delegator.getMaxRows();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean getMoreResults() throws SQLException {
    return delegator.getMoreResults();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean getMoreResults(int current) throws SQLException {
    return delegator.getMoreResults(current);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int getQueryTimeout() throws SQLException {
    return delegator.getQueryTimeout();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ResultSet getResultSet() throws SQLException {
    return delegator.getResultSet();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int getResultSetConcurrency() throws SQLException {
    return delegator.getResultSetConcurrency();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int getResultSetHoldability() throws SQLException {
    return delegator.getResultSetHoldability();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int getResultSetType() throws SQLException {
    return delegator.getResultSetType();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int getUpdateCount() throws SQLException {
    return delegator.getUpdateCount();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public SQLWarning getWarnings() throws SQLException {
    return delegator.getWarnings();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isClosed() throws SQLException {
    return delegator.isClosed();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isCloseOnCompletion() throws SQLException {
    return delegator.isCloseOnCompletion();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isPoolable() throws SQLException {
    return delegator.isPoolable();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setCursorName(String name) throws SQLException {
    delegator.setCursorName(name);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setEscapeProcessing(boolean enable) throws SQLException {
    delegator.setEscapeProcessing(enable);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setFetchDirection(int direction) throws SQLException {
    delegator.setFetchDirection(direction);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setFetchSize(int rows) throws SQLException {
    delegator.setFetchSize(rows);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setMaxFieldSize(int max) throws SQLException {
    delegator.setMaxFieldSize(max);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setMaxRows(int max) throws SQLException {
    delegator.setMaxRows(max);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setPoolable(boolean poolable) throws SQLException {
    delegator.setPoolable(poolable);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setQueryTimeout(int seconds) throws SQLException {
    delegator.setQueryTimeout(seconds);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isWrapperFor(Class<?> iface) throws SQLException {
    try {
      //checkClosed();
      return delegator.isWrapperFor(iface);
    }
    catch (SQLException se) {
      owner.fireConnectionError(se);
      throw se;
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public <T> T unwrap(Class<T> iface) throws SQLException {
    try {
      //checkClosed();
      return delegator.unwrap(iface);
    }
    catch (SQLException se) {
      owner.fireConnectionError(se);
      throw se;
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int hashCode() {
    return super.hashCode();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean equals(Object o) {
    if (this == o)
      return true;
    if (o == null || !(o instanceof PGStatementDelegator))
      return false;

    PGStatementDelegator other = (PGStatementDelegator)o;
    return delegator.equals(other.delegator);
  }
}
