/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.api.data;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;

public class Interval {
    private int totalMonths;
    private int totalDays;
    private long totalMicros;
    private static final long SECS_TO_MICROS = TimeUnit.SECONDS.toMicros(1L);
    private static final long SECS_TO_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    private static final DecimalFormat secondsFormat = new DecimalFormat("0.00####");

    public Interval(int months, int days, long timeMicros) {
        this.setValue(months, days, timeMicros);
    }

    public Interval(int years, int months, int days, int hours, int minutes, double seconds) {
        this.setValue(years, months, days, hours, minutes, seconds);
    }

    public Interval(String interval) {
        this.setValue(interval);
    }

    public Interval() {
    }

    public void setValue(String value) {
        boolean isISOFormat;
        boolean bl = isISOFormat = !value.startsWith("@");
        if (!isISOFormat && value.length() == 3 && value.charAt(2) == '0') {
            this.totalDays = 0;
            this.totalMonths = 0;
            this.totalMicros = 0L;
            return;
        }
        int years = 0;
        int months = 0;
        int days = 0;
        int hours = 0;
        int minutes = 0;
        double seconds = 0.0;
        boolean ago = false;
        try {
            String valueToken = null;
            value = value.replace('+', ' ').replace('@', ' ');
            StringTokenizer st = new StringTokenizer(value);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.equals("ago")) {
                    ago = true;
                    break;
                }
                int endHours = token.indexOf(58);
                if (endHours != -1) {
                    int offset = token.charAt(0) == '-' ? 1 : 0;
                    hours = Integer.parseInt(token.substring(offset + 0, endHours));
                    minutes = Integer.parseInt(token.substring(endHours + 1, endHours + 3));
                    int endMinutes = token.indexOf(58, endHours + 1);
                    if (endMinutes != -1) {
                        seconds = Double.parseDouble(token.substring(endMinutes + 1));
                    }
                    if (offset == 1) {
                        hours = -hours;
                        minutes = -minutes;
                        seconds = -seconds;
                    }
                    valueToken = null;
                    break;
                }
                valueToken = token;
                if (!st.hasMoreTokens()) {
                    throw new IllegalArgumentException("invalid interval");
                }
                token = st.nextToken();
                if (token.startsWith("year")) {
                    years = Integer.parseInt(valueToken);
                    continue;
                }
                if (token.startsWith("mon")) {
                    months = Integer.parseInt(valueToken);
                    continue;
                }
                if (token.startsWith("day")) {
                    days = Integer.parseInt(valueToken);
                    continue;
                }
                if (token.startsWith("hour")) {
                    hours = Integer.parseInt(valueToken);
                    continue;
                }
                if (token.startsWith("min")) {
                    minutes = Integer.parseInt(valueToken);
                    continue;
                }
                if (!token.startsWith("sec")) continue;
                seconds = Double.parseDouble(valueToken);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("invalid interval", e);
        }
        if (!isISOFormat && ago) {
            this.setValue(-years, -months, -days, -hours, -minutes, -seconds);
        } else {
            this.setValue(years, months, days, hours, minutes, seconds);
        }
    }

    public void setValue(int months, int days, long timeMicros) {
        this.totalMonths = months;
        this.totalDays = days;
        this.totalMicros = timeMicros;
    }

    public void setValue(int years, int months, int days, int hours, int minutes, double seconds) {
        this.totalMonths += years * 12 + months;
        this.totalDays = days;
        this.totalMicros += TimeUnit.HOURS.toMicros(hours);
        this.totalMicros += TimeUnit.MINUTES.toMicros(minutes);
        this.totalMicros += (long)(seconds * (double)TimeUnit.SECONDS.toMicros(1L));
    }

    public long getRawTime() {
        return this.totalMicros;
    }

    public void setRawTime(long time) {
        this.totalMicros = time;
    }

    public int getRawDays() {
        return this.totalDays;
    }

    public void setRawDays(int days) {
        this.totalDays = days;
    }

    public int getRawMonths() {
        return this.totalMonths;
    }

    public void setRawMonths(int months) {
        this.totalMonths = months;
    }

    public long getHours() {
        return TimeUnit.MICROSECONDS.toHours(this.totalMicros);
    }

    public void setHours(long hours) {
        this.totalMicros -= TimeUnit.HOURS.toMicros(this.getHours());
        this.totalMicros += TimeUnit.HOURS.toMicros(hours);
    }

    public long getMinutes() {
        return TimeUnit.MICROSECONDS.toMinutes(this.totalMicros) - TimeUnit.HOURS.toMinutes(this.getHours());
    }

    public void setMinutes(long minutes) {
        this.totalMicros -= TimeUnit.MINUTES.toMicros(this.getMinutes());
        this.totalMicros += TimeUnit.MINUTES.toMicros(minutes);
    }

    public double getSeconds() {
        double microsDiff = this.totalMicros - TimeUnit.MINUTES.toMicros(TimeUnit.MICROSECONDS.toMinutes(this.totalMicros));
        return microsDiff / (double)SECS_TO_MICROS;
    }

    public void setSeconds(double seconds) {
        this.totalMicros = (long)((double)this.totalMicros - this.getSeconds() * (double)SECS_TO_MICROS);
        this.totalMicros = (long)((double)this.totalMicros + seconds * (double)SECS_TO_MICROS);
    }

    public int getDays() {
        return this.totalDays;
    }

    public void setDays(int days) {
        this.totalDays = days;
    }

    public int getMonths() {
        return this.totalMonths % 12;
    }

    public void setMonths(int months) {
        this.totalMonths -= this.getMonths();
        this.totalMonths += months;
    }

    public int getYears() {
        return this.totalMonths / 12;
    }

    public void setYears(int years) {
        this.totalMonths -= this.getYears() * 12;
        this.totalMonths += years * 12;
    }

    public void addTo(Calendar cal) {
        long millis = Math.round(this.getSeconds() * (double)SECS_TO_MILLIS);
        cal.add(14, (int)millis);
        cal.add(12, (int)this.getMinutes());
        cal.add(10, (int)this.getHours());
        cal.add(5, this.getDays());
        cal.add(2, this.getMonths());
        cal.add(1, this.getYears());
    }

    public void addTo(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        this.addTo(cal);
        date.setTime(cal.getTimeInMillis());
    }

    public void addTo(Interval interval) {
        interval.totalMonths += this.totalMonths;
        interval.totalDays += this.totalDays;
        interval.totalMicros += this.totalMicros;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.totalDays;
        result = 31 * result + this.totalMonths;
        result = 31 * result + (int)(this.totalMicros ^ this.totalMicros >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Interval other = (Interval)obj;
        if (this.totalDays != other.totalDays) {
            return false;
        }
        if (this.totalMonths != other.totalMonths) {
            return false;
        }
        return this.totalMicros == other.totalMicros;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("@ ").append(this.getYears()).append(" years ").append(this.getMonths()).append(" months ").append(this.getDays()).append(" days ").append(this.getHours()).append(" hours ").append(this.getMinutes()).append(" minutes ").append(secondsFormat.format(this.getSeconds())).append(" seconds");
        return buffer.toString();
    }

    static {
        DecimalFormatSymbols dfs = secondsFormat.getDecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        secondsFormat.setDecimalFormatSymbols(dfs);
    }
}

